/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model.responses;

import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import fish.payara.microprofile.openapi.impl.model.ExtensibleImpl;
import fish.payara.microprofile.openapi.impl.model.headers.HeaderImpl;
import fish.payara.microprofile.openapi.impl.model.links.LinkImpl;
import fish.payara.microprofile.openapi.impl.model.media.ContentImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;

public class APIResponseImpl
extends ExtensibleImpl<APIResponse>
implements APIResponse {
    private String description;
    private Map<String, Header> headers = new HashMap<String, Header>();
    private Content content = new ContentImpl();
    private List<Content> contents = new ArrayList<Content>();
    private Map<String, Link> links = new HashMap<String, Link>();
    private String ref;
    private String responseCode;

    public static APIResponseImpl createInstance(AnnotationModel annotation, ApiContext context) {
        APIResponseImpl from = new APIResponseImpl();
        from.setDescription((String)annotation.getValue("description", String.class));
        from.getHeaders().putAll(HeaderImpl.createInstances(annotation, context));
        ModelUtils.extractAnnotations(annotation, context, "content", ContentImpl::createInstance, from.getContents());
        ModelUtils.extractAnnotations(annotation, context, "links", "name", LinkImpl::createInstance, from.getLinks());
        String ref = (String)annotation.getValue("ref", String.class);
        if (ref != null && !ref.isEmpty()) {
            from.setRef(ref);
        }
        from.setResponseCode((String)annotation.getValue("responseCode", String.class));
        return from;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Map<String, Header> getHeaders() {
        return this.headers;
    }

    @Override
    public void setHeaders(Map<String, Header> headers) {
        this.headers = headers;
    }

    @Override
    public APIResponse addHeader(String name, Header header) {
        if (header != null) {
            this.headers.put(name, header);
        }
        return this;
    }

    @Override
    public void removeHeader(String name) {
        this.headers.remove(name);
    }

    @Override
    public Content getContent() {
        return this.content;
    }

    @Override
    public void setContent(Content content) {
        this.content = content;
    }

    @Override
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @Override
    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    @Override
    public APIResponse addLink(String name, Link link) {
        if (link != null) {
            this.links.put(name, link);
        }
        return this;
    }

    @Override
    public void removeLink(String name) {
        this.links.remove(name);
    }

    @Override
    public String getRef() {
        return this.ref;
    }

    @Override
    public void setRef(String ref) {
        if (ref != null && !ref.contains(".") && !ref.contains("/")) {
            ref = "#/components/responses/" + ref;
        }
        this.ref = ref;
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(String responseCode) {
        this.responseCode = responseCode;
    }

    public List<Content> getContents() {
        return this.contents;
    }

    public void setContents(List<Content> contents) {
        this.contents = contents;
    }

    public static void merge(APIResponse from, APIResponse to, boolean override, ApiContext context) {
        APIResponseImpl fromImpl;
        if (from == null) {
            return;
        }
        if (from.getRef() != null && !from.getRef().isEmpty()) {
            ModelUtils.applyReference(to, from.getRef());
            return;
        }
        to.setDescription(ModelUtils.mergeProperty(to.getDescription(), from.getDescription(), override));
        if (from.getContent() != null) {
            if (to.getContent() == null) {
                to.setContent(new ContentImpl());
            }
            ContentImpl.merge((ContentImpl)from.getContent(), to.getContent(), override, context);
        }
        if (from instanceof APIResponseImpl && (fromImpl = (APIResponseImpl)from).getContents() != null) {
            if (to.getContent() == null) {
                to.setContent(new ContentImpl());
            }
            for (Content content : fromImpl.getContents()) {
                ContentImpl.merge((ContentImpl)content, to.getContent(), override, context);
            }
        }
        if (from.getContent() != null) {
            if (to.getContent() == null) {
                to.setContent(new ContentImpl());
            }
            ContentImpl.merge((ContentImpl)from.getContent(), to.getContent(), override, context);
        }
        if (from.getHeaders() != null) {
            for (String headerName : from.getHeaders().keySet()) {
                HeaderImpl.merge(headerName, from.getHeaders().get(headerName), to.getHeaders(), override, context);
            }
        }
        if (from.getLinks() != null) {
            for (String linkName : from.getLinks().keySet()) {
                LinkImpl.merge(linkName, from.getLinks().get(linkName), to.getLinks(), override);
            }
        }
    }
}

