/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model.responses;

import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import fish.payara.microprofile.openapi.impl.model.ExtensibleTreeMap;
import fish.payara.microprofile.openapi.impl.model.responses.APIResponseImpl;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;

public class APIResponsesImpl
extends ExtensibleTreeMap<APIResponse, APIResponses>
implements APIResponses {
    private static final long serialVersionUID = 2811935761440110541L;

    public APIResponsesImpl() {
    }

    public APIResponsesImpl(Map<String, APIResponse> responses) {
        super(responses);
    }

    @Override
    public APIResponses addAPIResponse(String name, APIResponse apiResponse) {
        if (apiResponse != null) {
            this.put(name, apiResponse);
        }
        return this;
    }

    @Override
    public void removeAPIResponse(String name) {
        this.remove(name);
    }

    @Override
    public Map<String, APIResponse> getAPIResponses() {
        return new APIResponsesImpl(this);
    }

    @Override
    public void setAPIResponses(Map<String, APIResponse> items) {
        this.clear();
        this.putAll(items);
    }

    @Override
    public APIResponse getDefaultValue() {
        return (APIResponse)this.get("default");
    }

    @Override
    public void setDefaultValue(APIResponse defaultValue) {
        this.put("default", defaultValue);
    }

    public static void merge(APIResponse from, APIResponses to, boolean override, ApiContext context) {
        if (from == null) {
            return;
        }
        String responseName = null;
        if (from instanceof APIResponseImpl) {
            responseName = ((APIResponseImpl)from).getResponseCode();
        }
        if (responseName == null || responseName.isEmpty()) {
            responseName = "default";
        }
        APIResponse response = to.getOrDefault(responseName, new APIResponseImpl());
        to.addAPIResponse(responseName, response);
        APIResponseImpl.merge(from, response, override, context);
    }
}

