/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model.security;

import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;

public class SecurityRequirementImpl
extends LinkedHashMap<String, List<String>>
implements SecurityRequirement {
    private static final long serialVersionUID = -677783376083861245L;

    public static SecurityRequirement createInstance(AnnotationModel annotation, ApiContext context) {
        SecurityRequirementImpl from = new SecurityRequirementImpl();
        String name = (String)annotation.getValue("name", String.class);
        List<String> scopes = (List<String>)annotation.getValue("scopes", List.class);
        from.addScheme(name, scopes != null ? scopes : Collections.emptyList());
        return from;
    }

    public SecurityRequirementImpl() {
    }

    public SecurityRequirementImpl(Map<? extends String, ? extends List<String>> items) {
        super(items);
    }

    @Override
    public SecurityRequirement addScheme(String name, String item) {
        this.put(name, item == null ? new ArrayList() : Arrays.asList(item));
        return this;
    }

    @Override
    public SecurityRequirement addScheme(String name, List<String> item) {
        this.put(name, item == null ? new ArrayList() : item);
        return this;
    }

    @Override
    public SecurityRequirement addScheme(String name) {
        this.put(name, new ArrayList());
        return this;
    }

    @Override
    public void removeScheme(String securitySchemeName) {
        this.remove(securitySchemeName);
    }

    @Override
    public Map<String, List<String>> getSchemes() {
        return new SecurityRequirementImpl(this);
    }

    @Override
    public void setSchemes(Map<String, List<String>> items) {
        this.clear();
        this.putAll(items);
    }

    public static void merge(SecurityRequirement from, SecurityRequirement to) {
        if (from == null) {
            return;
        }
        for (String name : from.getSchemes().keySet()) {
            if (name == null || name.isEmpty()) continue;
            to.addScheme(name, from.getSchemes().get(name));
        }
    }
}

