/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model.servers;

import fish.payara.microprofile.openapi.impl.model.ExtensibleTreeMap;
import fish.payara.microprofile.openapi.impl.model.servers.ServerVariableImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.servers.ServerVariable;
import org.eclipse.microprofile.openapi.models.servers.ServerVariables;

public class ServerVariablesImpl
extends ExtensibleTreeMap<ServerVariable, ServerVariables>
implements ServerVariables {
    private static final long serialVersionUID = 8869393484826870024L;

    public ServerVariablesImpl() {
    }

    public ServerVariablesImpl(Map<String, ServerVariable> variables) {
        super(variables);
    }

    @Override
    public ServerVariables addServerVariable(String name, ServerVariable item) {
        if (item != null) {
            this.put(name, item);
        }
        return this;
    }

    @Override
    public void removeServerVariable(String name) {
        this.remove(name);
    }

    @Override
    public Map<String, ServerVariable> getServerVariables() {
        return new ServerVariablesImpl(this);
    }

    @Override
    public void setServerVariables(Map<String, ServerVariable> items) {
        this.clear();
        this.putAll(items);
    }

    public static void merge(String serverVariableName, ServerVariable from, ServerVariables to, boolean override) {
        if (from == null) {
            return;
        }
        ServerVariableImpl variable = new ServerVariableImpl();
        variable.setDefaultValue(ModelUtils.mergeProperty(variable.getDefaultValue(), from.getDefaultValue(), override));
        variable.setDescription(ModelUtils.mergeProperty(variable.getDescription(), from.getDescription(), override));
        if (from.getEnumeration() != null && !from.getEnumeration().isEmpty()) {
            if (variable.getEnumeration() == null) {
                variable.setEnumeration(new ArrayList<String>());
            }
            for (String value : from.getEnumeration()) {
                variable.addEnumeration(value);
            }
        }
        if (to.hasServerVariable(serverVariableName) && override || !to.hasServerVariable(serverVariableName)) {
            to.addServerVariable(serverVariableName, variable);
        }
    }
}

