/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.processor;

import fish.payara.microprofile.openapi.api.processor.OASProcessor;
import fish.payara.microprofile.openapi.impl.config.OpenApiConfiguration;
import fish.payara.microprofile.openapi.impl.model.PathItemImpl;
import fish.payara.microprofile.openapi.impl.model.info.InfoImpl;
import fish.payara.microprofile.openapi.impl.model.servers.ServerImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;

public class BaseProcessor
implements OASProcessor {
    private final List<URL> baseURLs;

    public BaseProcessor(List<URL> baseURLs) {
        this.baseURLs = baseURLs;
    }

    @Override
    public OpenAPI process(OpenAPI api, OpenApiConfiguration config) {
        if (api.getOpenapi() == null) {
            api.setOpenapi("3.0.0");
        }
        if (api.getInfo() == null) {
            api.setInfo(new InfoImpl().title("Deployed Resources").version("1.0.0"));
        }
        if (config != null && !config.getServers().isEmpty()) {
            api.getServers().clear();
            config.getServers().forEach(serverUrl -> api.addServer(new ServerImpl().url((String)serverUrl)));
        }
        if (api.getServers().isEmpty()) {
            for (URL uRL : this.baseURLs) {
                api.addServer(new ServerImpl().url(uRL.toString()).description("Default Server."));
            }
        }
        if (config != null && !config.getPathServerMap().isEmpty()) {
            for (Map.Entry entry : config.getPathServerMap().entrySet()) {
                String path = ModelUtils.normaliseUrl((String)entry.getKey());
                if (!api.getPaths().hasPathItem(path)) {
                    api.getPaths().addPathItem(path, new PathItemImpl());
                }
                api.getPaths().getPathItem(path).getServers().clear();
                for (String serverUrl2 : (Set)entry.getValue()) {
                    api.getPaths().getPathItem(path).addServer(new ServerImpl().url(serverUrl2));
                }
            }
        }
        if (config != null && !config.getOperationServerMap().isEmpty()) {
            for (Map.Entry entry : config.getOperationServerMap().entrySet()) {
                for (PathItem pathItem : api.getPaths().values()) {
                    for (Operation operation : pathItem.getOperations().values()) {
                        if (!operation.getOperationId().equals(entry.getKey())) continue;
                        operation.getServers().clear();
                        for (String serverUrl3 : (Set)entry.getValue()) {
                            operation.addServer(new ServerImpl().url(serverUrl3));
                        }
                    }
                }
            }
        }
        BaseProcessor.removeEmptyPaths(api);
        return api;
    }

    private static void removeEmptyPaths(OpenAPI api) {
        PathItemImpl emptyItem = new PathItemImpl();
        api.getPaths().entrySet().removeIf(entry -> emptyItem.equals(entry.getValue()));
    }
}

