/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import fish.payara.microprofile.openapi.api.processor.OASProcessor;
import fish.payara.microprofile.openapi.impl.config.OpenApiConfiguration;
import fish.payara.microprofile.openapi.impl.model.OpenAPIImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import fish.payara.microprofile.openapi.impl.rest.app.provider.ObjectMapperFactory;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.openapi.models.OpenAPI;

public class FileProcessor
implements OASProcessor {
    private static final Logger LOGGER = Logger.getLogger(FileProcessor.class.getName());
    private File file;
    private ObjectMapper mapper;

    public FileProcessor(ClassLoader appClassLoader) {
        try {
            URL fileUrl = appClassLoader.getResource("META-INF/openapi.json");
            fileUrl = fileUrl != null ? fileUrl : appClassLoader.getResource("../../META-INF/openapi.json");
            fileUrl = fileUrl != null ? fileUrl : appClassLoader.getResource("META-INF/openapi.yaml");
            fileUrl = fileUrl != null ? fileUrl : appClassLoader.getResource("../../META-INF/openapi.yaml");
            fileUrl = fileUrl != null ? fileUrl : appClassLoader.getResource("META-INF/openapi.yml");
            URL uRL = fileUrl = fileUrl != null ? fileUrl : appClassLoader.getResource("../../META-INF/openapi.yml");
            if (fileUrl != null) {
                this.file = new File(fileUrl.toURI());
                this.mapper = this.file.getPath().endsWith(".json") ? ObjectMapperFactory.createJson() : ObjectMapperFactory.createYaml();
            } else {
                LOGGER.fine("No static OpenAPI document provided.");
            }
        }
        catch (URISyntaxException ex) {
            LOGGER.log(Level.WARNING, "Invalid URI syntax", ex);
        }
    }

    @Override
    public OpenAPI process(OpenAPI api, OpenApiConfiguration config) {
        if (this.file != null) {
            OpenAPI readResult = null;
            try {
                readResult = (OpenAPI)this.mapper.readValue(this.file, OpenAPIImpl.class);
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "Error when reading static OpenAPI document.", ex);
            }
            if (readResult != null) {
                ModelUtils.merge(readResult, api, true);
            }
        }
        return api;
    }
}

