/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.processor;

import fish.payara.microprofile.openapi.api.processor.OASProcessor;
import fish.payara.microprofile.openapi.impl.config.OpenApiConfiguration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.openapi.OASModelReader;
import org.eclipse.microprofile.openapi.models.OpenAPI;

public class ModelReaderProcessor
implements OASProcessor {
    private static final Logger LOGGER = Logger.getLogger(ModelReaderProcessor.class.getName());
    private OASModelReader reader;

    @Override
    public OpenAPI process(OpenAPI api, OpenApiConfiguration config) {
        try {
            if (config.getModelReader() != null) {
                this.reader = config.getModelReader().newInstance();
            }
        }
        catch (IllegalAccessException | InstantiationException ex) {
            LOGGER.log(Level.WARNING, "Error creating OASModelReader instance.", ex);
        }
        if (this.reader != null) {
            OpenAPI model = this.reader.buildModel();
            if (model != null) {
                return model;
            }
            LOGGER.log(Level.WARNING, "The OpenAPI model returned by " + this.reader.getClass().getName() + " was null!");
        } else {
            LOGGER.fine("No OASModelReader provided.");
        }
        return api;
    }
}

