/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.rest.app.service;

import fish.payara.microprofile.openapi.api.OpenAPIBuildException;
import fish.payara.microprofile.openapi.impl.OpenApiService;
import fish.payara.microprofile.openapi.impl.model.OpenAPIImpl;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.openapi.models.OpenAPI;

@Path(value="/")
public class OpenApiResource {
    private static final Logger LOGGER = Logger.getLogger(OpenApiResource.class.getName());

    @GET
    @Produces(value={"text/plain", "application/json"})
    public Response getResponse(@Context HttpServletRequest request, @Context HttpServletResponse response) throws IOException {
        OpenApiService openApiService = OpenApiService.getInstance();
        if (!openApiService.isEnabled()) {
            response.sendError(Response.Status.FORBIDDEN.getStatusCode(), "MicroProfile OpenAPI Service is disabled.");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        OpenAPI document = null;
        try {
            document = openApiService.getDocument();
        }
        catch (OpenAPIBuildException | IOException ex) {
            LOGGER.log(Level.WARNING, "OpenAPI document creation failed.", ex);
        }
        if (document == null) {
            LOGGER.info("No OpenAPI document found.");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new OpenAPIImpl()).build();
        }
        return Response.ok((Object)document).build();
    }
}

