/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.visitor;

import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import fish.payara.microprofile.openapi.impl.visitor.AnnotationInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.glassfish.hk2.classmodel.reflect.AnnotatedElement;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;
import org.glassfish.hk2.classmodel.reflect.ClassModel;
import org.glassfish.hk2.classmodel.reflect.ExtensibleType;
import org.glassfish.hk2.classmodel.reflect.MethodModel;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.Types;

public class OpenApiContext
implements ApiContext {
    private final Types allTypes;
    private final ClassLoader appClassLoader;
    private final OpenAPI api;
    private final Set<Type> allowedTypes;
    private final Map<String, Set<Type>> resourceMapping;
    private String path;
    private Operation operation;
    private AnnotatedElement annotatedElement;
    private static final Logger LOGGER = Logger.getLogger(OpenApiContext.class.getName());
    private Map<ExtensibleType<? extends ExtensibleType>, AnnotationInfo> parsedTypes = new ConcurrentHashMap<ExtensibleType<? extends ExtensibleType>, AnnotationInfo>();

    public OpenApiContext(Types allTypes, Set<Type> allowedTypes, ClassLoader appClassLoader, OpenAPI api) {
        this.allTypes = allTypes;
        this.allowedTypes = allowedTypes;
        this.api = api;
        this.appClassLoader = appClassLoader;
        this.resourceMapping = this.generateResourceMapping();
    }

    public OpenApiContext(OpenApiContext parentApiContext, AnnotatedElement annotatedElement) {
        this.allTypes = parentApiContext.allTypes;
        this.allowedTypes = parentApiContext.allowedTypes;
        this.api = parentApiContext.api;
        this.appClassLoader = parentApiContext.appClassLoader;
        this.resourceMapping = parentApiContext.resourceMapping;
        this.parsedTypes = parentApiContext.parsedTypes;
        this.annotatedElement = annotatedElement;
    }

    @Override
    public OpenAPI getApi() {
        return this.api;
    }

    @Override
    public String getPath() {
        if (this.path == null) {
            this.path = this.getResourcePath(this.annotatedElement);
        }
        return this.path;
    }

    @Override
    public Operation getWorkingOperation() {
        if (this.operation == null && this.annotatedElement instanceof MethodModel) {
            this.operation = this.getOperation((MethodModel)this.annotatedElement);
        }
        return this.operation;
    }

    @Override
    public boolean isAllowedType(Type type) {
        return this.allowedTypes.contains(type);
    }

    @Override
    public boolean isApplicationType(String type) {
        return this.allTypes.getBy(type) != null;
    }

    @Override
    public Type getType(String type) {
        return this.allTypes.getBy(type);
    }

    @Override
    public ClassLoader getApplicationClassLoader() {
        return this.appClassLoader;
    }

    @Override
    public AnnotationInfo getAnnotationInfo(ExtensibleType<? extends ExtensibleType> type) {
        return this.parsedTypes.computeIfAbsent(type, key -> new AnnotationInfo((ExtensibleType<? extends ExtensibleType>)key));
    }

    private Map<String, Set<Type>> generateResourceMapping() {
        Set classes;
        HashSet<ClassModel> classList = new HashSet<ClassModel>();
        HashMap<String, Set<Type>> mapping = new HashMap<String, Set<Type>>();
        for (Type type : this.allowedTypes) {
            if (!(type instanceof ClassModel)) continue;
            ClassModel classModel = (ClassModel)type;
            if (classModel.getAnnotation(ApplicationPath.class.getName()) != null) {
                AnnotationModel annotation = classModel.getAnnotation(ApplicationPath.class.getName());
                String key = (String)annotation.getValue("value", String.class);
                HashSet resourceClasses = new HashSet();
                mapping.put(key, resourceClasses);
                try {
                    Class<?> clazz = this.appClassLoader.loadClass(classModel.getName());
                    Application app = (Application)clazz.newInstance();
                    resourceClasses.addAll(app.getClasses().stream().map(Class::getName).filter(name -> !name.startsWith("org.glassfish.jersey")).map(arg_0 -> ((Types)this.allTypes).getBy(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet()));
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                    LOGGER.log(Level.WARNING, "Unable to initialise application class.", ex);
                }
                continue;
            }
            classList.add(classModel);
        }
        if (mapping.keySet().size() == 1 && (classes = (Set)mapping.values().iterator().next()).isEmpty()) {
            classes.addAll(classList);
        }
        if (mapping.isEmpty()) {
            mapping.put("/", classList);
        }
        return mapping;
    }

    private Operation getOperation(MethodModel method) {
        PathItem pathItem;
        String resourcePath = this.getResourcePath(method);
        if (resourcePath != null && (pathItem = this.api.getPaths().getPathItem(resourcePath)) != null) {
            PathItem.HttpMethod httpMethod = ModelUtils.getHttpMethod(this, method);
            return pathItem.getOperations().get((Object)httpMethod);
        }
        return null;
    }

    private String getResourcePath(AnnotatedElement declaration) {
        if (declaration instanceof MethodModel) {
            return this.getResourcePath((MethodModel)declaration);
        }
        if (declaration instanceof ClassModel) {
            return this.getResourcePath((ClassModel)declaration);
        }
        return null;
    }

    private String getResourcePath(ClassModel clazz) {
        AnnotationInfo annotations = this.getAnnotationInfo((ExtensibleType<? extends ExtensibleType>)clazz);
        if (annotations.isAnnotationPresent(Path.class)) {
            for (Map.Entry<String, Set<Type>> entry : this.resourceMapping.entrySet()) {
                if (entry.getValue() == null || !entry.getValue().contains(clazz)) continue;
                return ModelUtils.normaliseUrl(entry.getKey() + "/" + annotations.getAnnotationValue(Path.class));
            }
        }
        return null;
    }

    private String getResourcePath(MethodModel method) {
        AnnotationInfo annotations = this.getAnnotationInfo((ExtensibleType<? extends ExtensibleType>)method.getDeclaringType());
        if (annotations.isAnyAnnotationPresent((AnnotatedElement)method, GET.class, POST.class, PUT.class, DELETE.class, HEAD.class, OPTIONS.class, PATCH.class)) {
            if (annotations.isAnnotationPresent(Path.class, method)) {
                return ModelUtils.normaliseUrl(this.getResourcePath((AnnotatedElement)method.getDeclaringType()) + "/" + annotations.getAnnotationValue(Path.class, (AnnotatedElement)method));
            }
            return ModelUtils.normaliseUrl(this.getResourcePath((AnnotatedElement)method.getDeclaringType()));
        }
        return null;
    }
}

