/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime.common;

import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.common.MessageNode;
import com.sun.enterprise.deployment.node.runtime.common.ProtectionNode;
import com.sun.enterprise.deployment.runtime.common.MessageDescriptor;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityDescriptor;
import com.sun.enterprise.deployment.runtime.common.ProtectionDescriptor;
import java.util.List;
import org.w3c.dom.Node;

public class MessageSecurityNode
extends DeploymentDescriptorNode<MessageSecurityDescriptor> {
    MessageSecurityDescriptor descriptor;

    public MessageSecurityNode() {
        this.registerElementHandler(new XMLElement("message"), MessageNode.class, "addMessageDescriptor");
        this.registerElementHandler(new XMLElement("request-protection"), ProtectionNode.class, "setRequestProtectionDescriptor");
        this.registerElementHandler(new XMLElement("response-protection"), ProtectionNode.class, "setResponseProtectionDescriptor");
    }

    @Override
    public MessageSecurityDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new MessageSecurityDescriptor();
        }
        return this.descriptor;
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, MessageSecurityDescriptor messageSecurityDesc) {
        ProtectionDescriptor responseProtectionDesc;
        ProtectionDescriptor requestProtectionDesc;
        Node messageSecurityNode = super.writeDescriptor(parent, nodeName, messageSecurityDesc);
        List<MessageDescriptor> messageDescriptors = messageSecurityDesc.getMessageDescriptors();
        if (!messageDescriptors.isEmpty()) {
            MessageNode messageNode = new MessageNode();
            for (MessageDescriptor messageDesc : messageDescriptors) {
                messageNode.writeDescriptor(messageSecurityNode, "message", messageDesc);
            }
        }
        if ((requestProtectionDesc = messageSecurityDesc.getRequestProtectionDescriptor()) != null) {
            new ProtectionNode().writeDescriptor(messageSecurityNode, "request-protection", requestProtectionDesc);
        }
        if ((responseProtectionDesc = messageSecurityDesc.getResponseProtectionDescriptor()) != null) {
            new ProtectionNode().writeDescriptor(messageSecurityNode, "response-protection", responseProtectionDesc);
        }
        return messageSecurityNode;
    }
}

