/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deployment.AbstractConnectorResourceDescriptor;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerFactoryReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitsDescriptor;
import com.sun.enterprise.deployment.ResourceDescriptor;
import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.ResourceValidatorVisitor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.api.JavaEEContextUtil;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.jvnet.hk2.annotations.Service;

@Service
@RunLevel(value=20, mode=1)
public class ResourceValidator
implements EventListener,
ResourceValidatorVisitor {
    public static final Logger deplLogger = DOLUtils.deplLogger;
    @LogMessageInfo(message="JNDI lookup failed for the resource: Name: {0}, Lookup: {1}, Type: {2}.", level="SEVERE", cause="JNDI lookup for the specified resource failed.", action="Configure the required resources before deploying the application.", comment="For the method validateJNDIRefs of com.sun.enterprise.deployment.util.ResourceValidator.")
    private static final String RESOURCE_REF_JNDI_LOOKUP_FAILED = "AS-DEPLOYMENT-00026";
    @LogMessageInfo(message="Skipping resource validation")
    private static final String SKIP_RESOURCE_VALIDATION = "AS-DEPLOYMENT-00028";
    @LogMessageInfo(message="Resource Adapter not present: RA Name: {0}, Type: {1}.", level="SEVERE", cause="Resource apapter specified is invalid.", action="Configure the required resource adapter.")
    private static final String RESOURCE_REF_INVALID_RA = "AS-DEPLOYMENT-00027";
    private String target;
    @Inject
    private Events events;
    @Inject
    private Domain domain;
    @Inject
    private JavaEEContextUtil contextUtil;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ResourceValidator.class);
    @Inject
    @Named(value="default-instance-name")
    private Server server;

    public void postConstruct() {
        this.events.register((EventListener)this);
    }

    public void event(EventListener.Event<?> event) {
        if (event.is(Deployment.AFTER_APPLICATION_CLASSLOADER_CREATION)) {
            DeploymentContext deploymentContext = (DeploymentContext)event.hook();
            Application application = (Application)deploymentContext.getModuleMetaData(Application.class);
            DeployCommandParameters commandParams = (DeployCommandParameters)deploymentContext.getCommandParameters(DeployCommandParameters.class);
            this.target = commandParams.target;
            if (System.getProperty("deployment.resource.validation", "true").equals("false")) {
                deplLogger.log(Level.INFO, SKIP_RESOURCE_VALIDATION);
                return;
            }
            if (application == null) {
                return;
            }
            AppResources appResources = new AppResources();
            this.parseResources(deploymentContext, application, appResources);
            this.contextUtil.setEmptyInvocation();
            try (JavaEEContextUtil.Context ctx = this.contextUtil.pushContext();){
                this.validateResources(deploymentContext, application, appResources);
            }
        }
    }

    private void parseResources(DeploymentContext deploymentContext, Application application, AppResources appResources) {
        this.parseResourcesBd(application, appResources);
        for (BundleDescriptor bd : application.getBundleDescriptors()) {
            if (bd instanceof WebBundleDescriptor || bd instanceof ApplicationClientDescriptor) {
                this.parseResourcesBd(bd, appResources);
            }
            if (!(bd instanceof EjbBundleDescriptor)) continue;
            for (ManagedBeanDescriptor mbd : bd.getManagedBeans()) {
                this.parseResources(mbd, (JndiNameEnvironment)((Object)bd), appResources);
            }
            EjbBundleDescriptor ebd = (EjbBundleDescriptor)bd;
            for (EjbDescriptor ejbDescriptor : ebd.getEjbs()) {
                this.parseEJB(ejbDescriptor, appResources);
            }
        }
        this.parseManagedBeans(application, appResources);
        String appName = DOLUtils.getApplicationName(application);
        Map resourcesList = (Map)deploymentContext.getTransientAppMetadata().get("app-scoped-resources-jndi-names");
        appResources.storeAppScopedResources(resourcesList, appName);
    }

    private void parseEJB(EjbDescriptor ejb, AppResources appResources) {
        Object fullyQualifiedJavaGlobalName;
        Object intf;
        String javaGlobalName = this.getJavaGlobalJndiNamePrefix(ejb);
        boolean disableNonPortableJndiName = false;
        Boolean disableInDD = ejb.getEjbBundleDescriptor().getDisableNonportableJndiNames();
        if (disableInDD != null) {
            disableNonPortableJndiName = disableInDD;
        }
        String glassfishSpecificJndiName = null;
        if (!disableNonPortableJndiName) {
            glassfishSpecificJndiName = ejb.getJndiName();
        }
        if (glassfishSpecificJndiName != null && (glassfishSpecificJndiName.equals("") || glassfishSpecificJndiName.equals(javaGlobalName))) {
            glassfishSpecificJndiName = null;
        }
        int countPortableJndiNames = 0;
        if (ejb.isRemoteInterfacesSupported()) {
            intf = ejb.getHomeClassName();
            fullyQualifiedJavaGlobalName = javaGlobalName + "!" + (String)intf;
            appResources.storeInNamespace((String)fullyQualifiedJavaGlobalName, ejb);
            ++countPortableJndiNames;
            if (glassfishSpecificJndiName != null) {
                appResources.storeInNamespace(glassfishSpecificJndiName, ejb);
            }
        }
        if (ejb.isRemoteBusinessInterfacesSupported()) {
            int count = 0;
            for (String intf2 : ejb.getRemoteBusinessClassNames()) {
                ++count;
                String fullyQualifiedJavaGlobalName2 = javaGlobalName + "!" + intf2;
                appResources.storeInNamespace(fullyQualifiedJavaGlobalName2, ejb);
                ++countPortableJndiNames;
                if (glassfishSpecificJndiName == null) continue;
                String remoteJndiName = this.getRemoteEjbJndiName(true, intf2, glassfishSpecificJndiName);
                appResources.storeInNamespace(remoteJndiName, ejb);
            }
            if (glassfishSpecificJndiName != null && !ejb.isRemoteInterfacesSupported() && count == 1) {
                appResources.storeInNamespace(glassfishSpecificJndiName, ejb);
            }
        }
        if (ejb.isLocalInterfacesSupported()) {
            intf = ejb.getLocalHomeClassName();
            fullyQualifiedJavaGlobalName = javaGlobalName + "!" + (String)intf;
            appResources.storeInNamespace((String)fullyQualifiedJavaGlobalName, ejb);
            ++countPortableJndiNames;
        }
        if (ejb.isLocalBusinessInterfacesSupported()) {
            for (String intf3 : ejb.getLocalBusinessClassNames()) {
                String fullyQualifiedJavaGlobalName3 = javaGlobalName + "!" + intf3;
                appResources.storeInNamespace(fullyQualifiedJavaGlobalName3, ejb);
                ++countPortableJndiNames;
            }
        }
        if (ejb.isLocalBean()) {
            intf = ejb.getEjbClassName();
            fullyQualifiedJavaGlobalName = javaGlobalName + "!" + (String)intf;
            appResources.storeInNamespace((String)fullyQualifiedJavaGlobalName, ejb);
            ++countPortableJndiNames;
        }
        if (countPortableJndiNames == 1) {
            appResources.storeInNamespace(javaGlobalName, ejb);
        }
        this.parseResources(ejb, appResources);
    }

    private String getJavaGlobalJndiNamePrefix(EjbDescriptor ejbDescriptor) {
        String appName = null;
        Application app = ejbDescriptor.getApplication();
        if (!app.isVirtual()) {
            appName = ejbDescriptor.getApplication().getAppName();
        }
        EjbBundleDescriptor ejbBundle = ejbDescriptor.getEjbBundleDescriptor();
        String modName = ejbBundle.getModuleDescriptor().getModuleName();
        String ejbName = ejbDescriptor.getName();
        StringBuilder javaGlobalPrefix = new StringBuilder("java:global/");
        if (appName != null) {
            javaGlobalPrefix.append(appName);
            javaGlobalPrefix.append("/");
        }
        javaGlobalPrefix.append(modName);
        javaGlobalPrefix.append("/");
        javaGlobalPrefix.append(ejbName);
        return javaGlobalPrefix.toString();
    }

    private String getRemoteEjbJndiName(EjbReferenceDescriptor refDesc) {
        String intf = refDesc.isEJB30ClientView() ? refDesc.getEjbInterface() : refDesc.getHomeClassName();
        return this.getRemoteEjbJndiName(refDesc.isEJB30ClientView(), intf, refDesc.getJndiName());
    }

    private String getRemoteEjbJndiName(boolean businessView, String interfaceName, String jndiName) {
        String returnValue = jndiName;
        String portableFullyQualifiedPortion = "!" + interfaceName;
        String glassfishFullyQualifiedPortion = "#" + interfaceName;
        if (businessView) {
            if (!jndiName.startsWith("corbaname:")) {
                returnValue = jndiName.startsWith("java:global/") ? ResourceValidator.checkFullyQualifiedJndiName(jndiName, portableFullyQualifiedPortion) : ResourceValidator.checkFullyQualifiedJndiName(jndiName, glassfishFullyQualifiedPortion);
            }
        } else if (jndiName.startsWith("java:global/")) {
            returnValue = ResourceValidator.checkFullyQualifiedJndiName(jndiName, portableFullyQualifiedPortion);
        }
        return returnValue;
    }

    private static String checkFullyQualifiedJndiName(String origJndiName, String fullyQualifiedPortion) {
        String returnValue = origJndiName;
        if (!origJndiName.endsWith(fullyQualifiedPortion)) {
            returnValue = origJndiName + fullyQualifiedPortion;
        }
        return returnValue;
    }

    private void parseManagedBeans(Application application, AppResources appResources) {
        for (BundleDescriptor bd : application.getBundleDescriptors()) {
            for (ManagedBeanDescriptor managedBean : bd.getManagedBeans()) {
                appResources.storeInNamespace(managedBean.getGlobalJndiName(), (JndiNameEnvironment)((Object)bd));
            }
        }
    }

    private void parseResourcesBd(BundleDescriptor bd, AppResources appResources) {
        if (!(bd instanceof JndiNameEnvironment)) {
            return;
        }
        JndiNameEnvironment env = (JndiNameEnvironment)((Object)bd);
        for (ResourceReferenceDescriptor resourceReferenceDescriptor : env.getResourceReferenceDescriptors()) {
            this.parseResources(resourceReferenceDescriptor, env, appResources);
        }
        for (EnvironmentProperty environmentProperty : env.getResourceEnvReferenceDescriptors()) {
            this.parseResources((ResourceEnvReferenceDescriptor)environmentProperty, env, appResources);
        }
        for (Object object : env.getMessageDestinationReferenceDescriptors()) {
            this.parseResources((MessageDestinationReferenceDescriptor)object, env, appResources);
        }
        for (Object object : env.getEnvironmentProperties()) {
            this.parseResources((EnvironmentProperty)object, env, appResources);
        }
        for (Object object : env.getAllResourcesDescriptors()) {
            this.parseResources((ResourceDescriptor)((Object)object), env, appResources);
        }
        for (Object object : env.getEntityManagerReferenceDescriptors()) {
            this.storeInNamespace(((EntityManagerReferenceDescriptor)object).getName(), env, appResources);
        }
        for (Object object : env.getEntityManagerFactoryReferenceDescriptors()) {
            this.storeInNamespace(((EntityManagerFactoryReferenceDescriptor)object).getName(), env, appResources);
        }
        for (Object object : env.getEjbReferenceDescriptors()) {
            this.parseResources((EjbReferenceDescriptor)object, env, appResources);
        }
        for (Object object : env.getServiceReferenceDescriptors()) {
            this.parseResources((ServiceReferenceDescriptor)object, env, appResources);
        }
        for (PersistenceUnitsDescriptor persistenceUnitsDescriptor : bd.getExtensionsDescriptors(PersistenceUnitsDescriptor.class)) {
            for (PersistenceUnitDescriptor pu : persistenceUnitsDescriptor.getPersistenceUnitDescriptors()) {
                this.parseResources(pu, env, appResources);
            }
        }
        for (ManagedBeanDescriptor managedBeanDescriptor : bd.getManagedBeans()) {
            this.parseResources(managedBeanDescriptor, env, appResources);
        }
    }

    private void parseResources(ResourceReferenceDescriptor resRef, JndiNameEnvironment env, AppResources appResources) {
        resRef.checkType();
        String name = this.getLogicalJNDIName(resRef.getName(), env);
        String type = resRef.getType();
        String jndiName = resRef.getJndiName();
        AppResource resRefResource = new AppResource(name, jndiName, type, env, true);
        if (resRef.isURLResource() && jndiName != null && !jndiName.startsWith("java:")) {
            try {
                new URL(jndiName);
                resRefResource.noValidation();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (resRef.isWebServiceContext()) {
            resRefResource.noValidation();
        }
        appResources.store(resRefResource);
    }

    private void parseResources(ResourceEnvReferenceDescriptor resEnvRef, JndiNameEnvironment env, AppResources appResources) {
        resEnvRef.checkType();
        String name = this.getLogicalJNDIName(resEnvRef.getName(), env);
        String type = resEnvRef.getType();
        String jndiName = resEnvRef.getJndiName();
        AppResource resEnvRefResource = new AppResource(name, jndiName, type, env, true);
        if (resEnvRef.isEJBContext() || resEnvRef.isValidator() || resEnvRef.isValidatorFactory() || resEnvRef.isCDIBeanManager()) {
            resEnvRefResource.noValidation();
        }
        appResources.store(resEnvRefResource);
    }

    private void parseResources(MessageDestinationReferenceDescriptor msgDestRef, JndiNameEnvironment env, AppResources appResources) {
        String name = this.getLogicalJNDIName(msgDestRef.getName(), env);
        String jndiName = msgDestRef.isLinkedToMessageDestination() ? msgDestRef.getMessageDestination().getJndiName() : msgDestRef.getJndiName();
        appResources.store(new AppResource(name, jndiName, msgDestRef.getType(), env, true));
    }

    private void parseResources(EnvironmentProperty envProp, JndiNameEnvironment env, AppResources appResources) {
        String name = this.getLogicalJNDIName(envProp.getName(), env);
        String jndiName = "";
        if (envProp.hasLookupName()) {
            jndiName = envProp.getLookupName();
        } else if (envProp.getMappedName().length() > 0) {
            jndiName = envProp.getMappedName();
        }
        AppResource envPropResource = new AppResource(name, jndiName, envProp.getType(), env, true);
        if (jndiName.length() == 0) {
            envPropResource.noValidation();
        }
        appResources.store(envPropResource);
        appResources.storeInNamespace(name, env);
    }

    private void parseResources(Application application, EjbReferenceDescriptor ejbRef, JndiNameEnvironment env, AppResources appResources) {
        String name = this.getLogicalJNDIName(ejbRef.getName(), env);
        if (ejbRef.getEjbDescriptor() != null) {
            appResources.storeInNamespace(name, env);
            return;
        }
        String jndiName = "";
        boolean validationRequired = false;
        if (ejbRef.isLocal()) {
            if (ejbRef.hasLookupName()) {
                jndiName = ejbRef.getLookupName();
                validationRequired = true;
            }
        } else if (!ejbRef.hasJndiName() && ejbRef.hasLookupName()) {
            jndiName = ejbRef.getLookupName();
            validationRequired = true;
        } else if (ejbRef.hasJndiName() && ejbRef.getJndiName().startsWith("java:app/") && !ejbRef.getJndiName().startsWith("java:app/env/")) {
            String remoteJndiName = ejbRef.getJndiName();
            String appName = DOLUtils.getApplicationName(application);
            String newPrefix = "java:global/" + appName + "/";
            int javaAppLength = "java:app/".length();
            jndiName = newPrefix + remoteJndiName.substring(javaAppLength);
            validationRequired = true;
        } else {
            String remoteJndiName = this.getRemoteEjbJndiName(ejbRef);
            if (!remoteJndiName.startsWith("corbaname:")) {
                validationRequired = true;
                jndiName = remoteJndiName;
            }
        }
        appResources.store(new AppResource(name, jndiName, ejbRef.getType(), env, validationRequired));
    }

    private void parseResources(ServiceReferenceDescriptor serviceRef, JndiNameEnvironment env, AppResources appResources) {
        String name = this.getLogicalJNDIName(serviceRef.getName(), env);
        if (serviceRef.hasLookupName()) {
            appResources.store(new AppResource(name, serviceRef.getLookupName(), serviceRef.getType(), env, true));
        } else {
            appResources.storeInNamespace(name, env);
        }
    }

    private void parseResources(ResourceDescriptor resourceDescriptor, JndiNameEnvironment env, AppResources appResources) {
        JavaEEResourceType type = resourceDescriptor.getResourceType();
        if (type.equals((Object)JavaEEResourceType.CFD) || type.equals((Object)JavaEEResourceType.AODD)) {
            if (env instanceof ApplicationClientDescriptor) {
                return;
            }
            AbstractConnectorResourceDescriptor acrd = (AbstractConnectorResourceDescriptor)resourceDescriptor;
            appResources.store(new AppResource(resourceDescriptor.getName(), acrd.getResourceAdapter(), type.toString(), env, true));
        } else {
            this.storeInNamespace(resourceDescriptor.getName(), env, appResources);
        }
    }

    private void parseResources(PersistenceUnitDescriptor pu, JndiNameEnvironment env, AppResources appResources) {
        String jtaDataSourceName = pu.getJtaDataSource();
        String nonJtaDataSourceName = pu.getNonJtaDataSource();
        if (jtaDataSourceName != null && jtaDataSourceName.length() > 0) {
            appResources.store(new AppResource(pu.getName(), jtaDataSourceName, "javax.sql.DataSource", env, true));
        }
        if (nonJtaDataSourceName != null && nonJtaDataSourceName.length() > 0) {
            appResources.store(new AppResource(pu.getName(), nonJtaDataSourceName, "javax.sql.DataSource", env, true));
        }
    }

    private void parseResources(ManagedBeanDescriptor managedBean, JndiNameEnvironment env, AppResources appResources) {
        for (ResourceReferenceDescriptor resourceReferenceDescriptor : managedBean.getResourceReferenceDescriptors()) {
            this.parseResources(resourceReferenceDescriptor, env, appResources);
        }
        for (EnvironmentProperty environmentProperty : managedBean.getResourceEnvReferenceDescriptors()) {
            this.parseResources((ResourceEnvReferenceDescriptor)environmentProperty, env, appResources);
        }
        for (EnvironmentProperty environmentProperty : managedBean.getMessageDestinationReferenceDescriptors()) {
            this.parseResources((MessageDestinationReferenceDescriptor)environmentProperty, env, appResources);
        }
        for (InjectionCapable injectionCapable : managedBean.getEjbReferenceDescriptors()) {
            this.parseResources((EjbReferenceDescriptor)injectionCapable, env, appResources);
        }
        for (InjectionCapable injectionCapable : managedBean.getEnvironmentProperties()) {
            this.parseResources((EnvironmentProperty)injectionCapable, env, appResources);
        }
        for (Object object : env.getAllResourcesDescriptors()) {
            this.parseResources((ResourceDescriptor)((Object)object), env, appResources);
        }
    }

    private void parseResources(EjbDescriptor ejb, AppResources appResources) {
        for (ResourceReferenceDescriptor resourceReferenceDescriptor : ejb.getResourceReferenceDescriptors()) {
            this.parseResources(resourceReferenceDescriptor, (JndiNameEnvironment)ejb, appResources);
        }
        for (EnvironmentProperty environmentProperty : ejb.getResourceEnvReferenceDescriptors()) {
            this.parseResources((ResourceEnvReferenceDescriptor)environmentProperty, (JndiNameEnvironment)ejb, appResources);
        }
        for (Object object : ejb.getMessageDestinationReferenceDescriptors()) {
            this.parseResources((MessageDestinationReferenceDescriptor)object, (JndiNameEnvironment)ejb, appResources);
        }
        for (Object object : ejb.getEnvironmentProperties()) {
            this.parseResources((EnvironmentProperty)object, (JndiNameEnvironment)ejb, appResources);
        }
        for (Object object : ejb.getEjbReferenceDescriptors()) {
            this.parseResources((EjbReferenceDescriptor)object, (JndiNameEnvironment)ejb, appResources);
        }
        for (Object object : ejb.getAllResourcesDescriptors()) {
            this.parseResources((ResourceDescriptor)((Object)object), (JndiNameEnvironment)ejb, appResources);
        }
    }

    private void storeInNamespace(String name, JndiNameEnvironment env, AppResources appResources) {
        String logicalJNDIName = this.getLogicalJNDIName(name, env);
        appResources.storeInNamespace(logicalJNDIName, env);
    }

    private String getLogicalJNDIName(String rawName, JndiNameEnvironment env) {
        String logicalJndiName = this.rawNameToLogicalJndiName(rawName);
        boolean treatComponentAsModule = DOLUtils.getTreatComponentAsModule(env);
        if (treatComponentAsModule && logicalJndiName.startsWith("java:comp/")) {
            logicalJndiName = this.logicalCompJndiNameToModule(logicalJndiName);
        }
        return logicalJndiName;
    }

    private String logicalCompJndiNameToModule(String logicalCompName) {
        String tail = logicalCompName.substring("java:comp/".length());
        return "java:module/" + tail;
    }

    private String rawNameToLogicalJndiName(String rawName) {
        return rawName.startsWith("java:") ? rawName : "java:comp/env/" + rawName;
    }

    private String convertModuleOrAppJNDIName(Application application, String jndiName, JndiNameEnvironment env) {
        BundleDescriptor bd = null;
        if (env instanceof EjbDescriptor) {
            bd = ((EjbDescriptor)env).getEjbBundleDescriptor();
        } else if (env instanceof BundleDescriptor) {
            bd = (BundleDescriptor)((Object)env);
        }
        if (jndiName == null) {
            return null;
        }
        if (bd != null) {
            String appName = null;
            if (!application.isVirtual()) {
                appName = application.getAppName();
            }
            String moduleName = bd.getModuleDescriptor().getModuleName();
            StringBuilder javaGlobalName = new StringBuilder("java:global/");
            if (jndiName.startsWith("java:app/")) {
                if (appName != null) {
                    javaGlobalName.append(appName);
                    javaGlobalName.append("/");
                }
                int javaAppLength = "java:app/".length();
                javaGlobalName.append(jndiName.substring(javaAppLength));
            } else if (jndiName.startsWith("java:module/")) {
                if (appName != null) {
                    javaGlobalName.append(appName);
                    javaGlobalName.append("/");
                }
                javaGlobalName.append(moduleName);
                javaGlobalName.append("/");
                int javaModuleLength = "java:module/".length();
                javaGlobalName.append(jndiName.substring(javaModuleLength));
            } else {
                return "";
            }
            return javaGlobalName.toString();
        }
        return "";
    }

    private void validateResources(DeploymentContext deploymentContext, Application application, AppResources appResources) {
        for (AppResource resource : appResources.myResources) {
            if (!resource.validate) continue;
            if (resource.getType().equals("CFD") || resource.getType().equals("AODD")) {
                this.validateRAName(application, resource);
                continue;
            }
            this.validateJNDIRefs(deploymentContext, application, resource, appResources.myNamespace);
        }
        List raNames = (List)deploymentContext.getTransientAppMetadata().get("app-scoped-resources-ra-names");
        if (raNames == null) {
            return;
        }
        for (Map.Entry entry : raNames) {
            this.validateRAName(application, (String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void validateRAName(Application application, AppResource resource) {
        this.validateRAName(application, resource.getJndiName(), resource.getType());
    }

    private void validateRAName(Application application, String raname, String type) {
        if (raname == null || raname.length() == 0) {
            deplLogger.log(Level.SEVERE, RESOURCE_REF_INVALID_RA, new Object[]{null, type});
            throw new DeploymentException(localStrings.getLocalString("enterprise.deployment.util.ra.validation", "Resource Adapter not present: RA Name: {0}, Type: {1}.", new Object[]{null, type}));
        }
        int poundIndex = raname.indexOf("#");
        if (poundIndex < 0) {
            if (this.domain.getApplications().getApplication(raname) != null) {
                return;
            }
            if (raname.equals("jmsra") || raname.equals("__ds_jdbc_ra") || raname.equals("jaxr-ra") || raname.equals("__cp_jdbc_ra") || raname.equals("__xa_jdbc_ra") || raname.equals("__dm_jdbc_ra")) {
                return;
            }
            if (this.isEmbedded(application, raname)) {
                return;
            }
        } else if (raname.substring(0, poundIndex).equals(application.getAppName()) && this.isEmbedded(application, raname = raname.substring(poundIndex + 1))) {
            return;
        }
        deplLogger.log(Level.SEVERE, RESOURCE_REF_INVALID_RA, new Object[]{raname, type});
        throw new DeploymentException(localStrings.getLocalString("enterprise.deployment.util.ra.validation", "Resource Adapter not present: RA Name: {0}, Type: {1}.", new Object[]{raname, type}));
    }

    private boolean isEmbedded(Application application, String raname) {
        String ranameWithRAR = raname + ".rar";
        for (BundleDescriptor bundleDescriptor : application.getBundleDescriptors(ConnectorDescriptor.class)) {
            if (!raname.equals(bundleDescriptor.getModuleName()) && !ranameWithRAR.equals(bundleDescriptor.getModuleName())) continue;
            return true;
        }
        return false;
    }

    private void validateJNDIRefs(DeploymentContext deploymentContext, Application application, AppResource resource, JNDINamespace namespace) {
        if (!resource.hasLookup() && !namespace.find(resource.getName(), resource.getEnv())) {
            deplLogger.log(Level.SEVERE, RESOURCE_REF_JNDI_LOOKUP_FAILED, new Object[]{resource.getName(), null, resource.getType()});
            throw new DeploymentException(localStrings.getLocalString("enterprise.deployment.util.resource.validation", "JNDI lookup failed for the resource: Name: {0}, Lookup: {1}, Type: {2}", new Object[]{resource.getName(), null, resource.getType()}));
        }
        String jndiName = TranslatedConfigView.expandConfigValue((String)resource.getJndiName());
        if (jndiName == null) {
            return;
        }
        JndiNameEnvironment env = resource.getEnv();
        if (this.isResourceInDomainXML(jndiName) || this.isDefaultResource(jndiName)) {
            return;
        }
        if (jndiName.startsWith("java:module/") || jndiName.startsWith("java:app/")) {
            if (namespace.find(jndiName, env)) {
                return;
            }
            String newName = this.convertModuleOrAppJNDIName(application, jndiName, resource.getEnv());
            if (namespace.find(newName, env)) {
                return;
            }
            try {
                InitialContext ctx = new InitialContext();
                ctx.lookup(newName);
                return;
            }
            catch (NamingException ctx) {
                // empty catch block
            }
        }
        if (!jndiName.startsWith("java:") && namespace.find(jndiName, env)) {
            return;
        }
        String convertedJndiName = this.getLogicalJNDIName(jndiName, env);
        if (namespace.find(convertedJndiName, env)) {
            return;
        }
        try {
            if (this.loadOnCurrentInstance(deploymentContext)) {
                InitialContext ctx = new InitialContext();
                ctx.lookup(jndiName);
            }
        }
        catch (NamingException e) {
            deplLogger.log(Level.SEVERE, RESOURCE_REF_JNDI_LOOKUP_FAILED, new Object[]{resource.getName(), jndiName, resource.getType()});
            throw new DeploymentException(localStrings.getLocalString("enterprise.deployment.util.resource.validation", "JNDI lookup failed for the resource: Name: {0}, Lookup: {1}, Type: {2}", new Object[]{resource.getName(), jndiName, resource.getType()}), (Throwable)e);
        }
    }

    private boolean isResourceInDomainXML(String jndiName) {
        if (jndiName == null) {
            return false;
        }
        Server svr = this.domain.getServerNamed(this.target);
        if (svr != null) {
            return svr.isResourceRefExists(jndiName);
        }
        Cluster cluster = this.domain.getClusterNamed(this.target);
        return cluster != null && cluster.isResourceRefExists(jndiName);
    }

    private boolean isDefaultResource(String jndiName) {
        return jndiName != null && (jndiName.equals("java:comp/DefaultDataSource") || jndiName.equals("java:comp/DefaultJMSConnectionFactory") || jndiName.equals("java:comp/ORB") || jndiName.equals("java:comp/DefaultManagedExecutorService") || jndiName.equals("java:comp/DefaultManagedScheduledExecutorService") || jndiName.equals("java:comp/DefaultManagedThreadFactory") || jndiName.equals("java:comp/DefaultContextService") || jndiName.equals("java:comp/UserTransaction") || jndiName.equals("java:comp/TransactionSynchronizationRegistry") || jndiName.equals("java:comp/BeanManager") || jndiName.equals("java:comp/ValidatorFactory") || jndiName.equals("java:comp/Validator") || jndiName.equals("java:module/ModuleName") || jndiName.equals("java:app/AppName") || jndiName.equals("java:comp/InAppClientContainer"));
    }

    private boolean loadOnCurrentInstance(DeploymentContext deploymentContext) {
        DeployCommandParameters commandParams = (DeployCommandParameters)deploymentContext.getCommandParameters(DeployCommandParameters.class);
        Properties appProps = deploymentContext.getAppProps();
        if (commandParams.enabled.booleanValue()) {
            String objectType;
            if (this.domain.isCurrentInstanceMatchingTarget(commandParams.target, commandParams.name(), this.server.getName(), (List)deploymentContext.getTransientAppMetaData("previousTargets", List.class))) {
                return true;
            }
            if (this.server.isDas() && (objectType = appProps.getProperty("object-type")) != null && (objectType.equals("system-admin") || objectType.equals("system-all"))) {
                return true;
            }
        }
        return false;
    }

    private static class JNDINamespace {
        private final Map<String, List<String>> componentNamespaces = new HashMap<String, List<String>>();
        private final Map<String, List<String>> moduleNamespaces = new HashMap<String, List<String>>();
        private final List<String> appNamespace = new ArrayList<String>();
        private final List<String> globalNameSpace = new ArrayList<String>();
        private final List<String> nonPortableJndiNames = new ArrayList<String>();

        private JNDINamespace() {
        }

        private void storeAppScopedResources(Map<String, List<String>> resources, String appName) {
            if (resources == null) {
                return;
            }
            List<String> appLevelResources = resources.get(appName);
            this.appNamespace.addAll(appLevelResources);
            for (Map.Entry<String, List<String>> entry : resources.entrySet()) {
                if (entry.getKey().equals(appName)) continue;
                String moduleName = this.getActualModuleName(entry.getKey());
                List<String> jndiNames = this.moduleNamespaces.get(moduleName);
                if (jndiNames == null) {
                    jndiNames = new ArrayList<String>();
                    jndiNames.addAll((Collection<String>)entry.getValue());
                    this.moduleNamespaces.put(moduleName, jndiNames);
                    continue;
                }
                jndiNames.addAll((Collection<String>)entry.getValue());
            }
        }

        public void store(String jndiName, JndiNameEnvironment env) {
            if (jndiName.startsWith("java:comp/")) {
                String componentId = DOLUtils.getComponentEnvId(env);
                List<String> jndiNames = this.componentNamespaces.get(componentId);
                if (jndiNames == null) {
                    jndiNames = new ArrayList<String>();
                    jndiNames.add(jndiName);
                    this.componentNamespaces.put(componentId, jndiNames);
                } else {
                    jndiNames.add(jndiName);
                }
            } else if (jndiName.startsWith("java:module/")) {
                String moduleName = this.getActualModuleName(DOLUtils.getModuleName(env));
                List<String> jndiNames = this.moduleNamespaces.get(moduleName);
                if (jndiNames == null) {
                    jndiNames = new ArrayList<String>();
                    jndiNames.add(jndiName);
                    this.moduleNamespaces.put(moduleName, jndiNames);
                } else {
                    jndiNames.add(jndiName);
                }
            } else if (jndiName.startsWith("java:app/")) {
                this.appNamespace.add(jndiName);
            } else if (jndiName.startsWith("java:global/")) {
                this.globalNameSpace.add(jndiName);
            } else {
                this.nonPortableJndiNames.add(jndiName);
            }
        }

        public boolean find(String jndiName, JndiNameEnvironment env) {
            if (jndiName == null) {
                return false;
            }
            if (jndiName.startsWith("java:comp/")) {
                String componentId = DOLUtils.getComponentEnvId(env);
                List<String> jndiNames = this.componentNamespaces.get(componentId);
                return jndiNames != null && jndiNames.contains(jndiName);
            }
            if (jndiName.startsWith("java:module/")) {
                String moduleName = this.getActualModuleName(DOLUtils.getModuleName(env));
                List<String> jndiNames = this.moduleNamespaces.get(moduleName);
                return jndiNames != null && jndiNames.contains(jndiName);
            }
            if (jndiName.startsWith("java:app/")) {
                return this.appNamespace.contains(jndiName);
            }
            if (jndiName.startsWith("java:global/")) {
                return this.globalNameSpace.contains(jndiName);
            }
            return this.nonPortableJndiNames.contains(jndiName);
        }

        private String getActualModuleName(String moduleName) {
            if (moduleName != null && (moduleName.endsWith(".jar") || moduleName.endsWith(".war") || moduleName.endsWith(".rar"))) {
                moduleName = moduleName.substring(0, moduleName.length() - 4);
            }
            return moduleName;
        }
    }

    private static class AppResources {
        private final List<AppResource> myResources = new ArrayList<AppResource>();
        private final JNDINamespace myNamespace = new JNDINamespace();

        private AppResources() {
        }

        private void store(AppResource resource) {
            this.myResources.add(resource);
            if (resource.hasLookup()) {
                this.myNamespace.store(resource.name, resource.env);
            }
        }

        private void storeInNamespace(String name, JndiNameEnvironment env) {
            this.myNamespace.store(name, env);
        }

        private void storeAppScopedResources(Map<String, List<String>> resourcesList, String appName) {
            this.myNamespace.storeAppScopedResources(resourcesList, appName);
        }
    }

    private static class AppResource {
        private final String name;
        private final String lookup;
        private final String type;
        private final JndiNameEnvironment env;
        boolean validate;

        private AppResource(String name, String lookup, String type, JndiNameEnvironment env, boolean validate) {
            this.name = name;
            this.lookup = lookup;
            this.type = type;
            this.env = env;
            this.validate = validate;
        }

        private String getJndiName() {
            return this.lookup;
        }

        private JndiNameEnvironment getEnv() {
            return this.env;
        }

        private String getName() {
            return this.name;
        }

        private String getType() {
            return this.type;
        }

        private boolean hasLookup() {
            return this.lookup != null && this.lookup.length() > 0;
        }

        private void noValidation() {
            this.validate = false;
        }
    }
}

