/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.enterprise.server.logging.AnsiColor;
import java.util.HashMap;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;

public abstract class AnsiColorFormatter
extends Formatter {
    private boolean ansiColor;
    private HashMap<Level, AnsiColor> colors;
    private AnsiColor loggerColor;

    public AnsiColorFormatter() {
        String colorProp;
        LogManager manager = LogManager.getLogManager();
        String color = manager.getProperty(this.getClass().getCanonicalName() + ".ansiColor");
        if ("true".equals(color)) {
            this.ansiColor = true;
        }
        this.colors = new HashMap();
        this.colors.put(Level.INFO, AnsiColor.BOLD_INTENSE_GREEN);
        this.colors.put(Level.WARNING, AnsiColor.BOLD_INTENSE_YELLOW);
        this.colors.put(Level.SEVERE, AnsiColor.BOLD_INTENSE_RED);
        this.loggerColor = AnsiColor.BOLD_INTENSE_BLUE;
        String infoColor = manager.getProperty(this.getClass().getCanonicalName() + ".infoColor");
        if (infoColor != null) {
            try {
                this.colors.put(Level.INFO, AnsiColor.valueOf(infoColor));
            }
            catch (IllegalArgumentException iae) {
                this.colors.put(Level.INFO, AnsiColor.BOLD_INTENSE_GREEN);
            }
        }
        if ((colorProp = manager.getProperty(this.getClass().getCanonicalName() + ".warnColor")) != null) {
            try {
                this.colors.put(Level.WARNING, AnsiColor.valueOf(colorProp));
            }
            catch (IllegalArgumentException iae) {
                this.colors.put(Level.WARNING, AnsiColor.BOLD_INTENSE_YELLOW);
            }
        }
        if ((colorProp = manager.getProperty(this.getClass().getCanonicalName() + ".severeColor")) != null) {
            try {
                this.colors.put(Level.SEVERE, AnsiColor.valueOf(colorProp));
            }
            catch (IllegalArgumentException iae) {
                this.colors.put(Level.SEVERE, AnsiColor.BOLD_INTENSE_RED);
            }
        }
        if ((colorProp = manager.getProperty(this.getClass().getCanonicalName() + ".loggerColor")) != null) {
            try {
                this.loggerColor = AnsiColor.valueOf(colorProp);
            }
            catch (IllegalArgumentException iae) {
                this.loggerColor = AnsiColor.BOLD_INTENSE_BLUE;
            }
        }
    }

    public AnsiColor getLoggerColor() {
        return this.loggerColor;
    }

    protected boolean color() {
        return this.ansiColor;
    }

    public void noAnsi() {
        this.ansiColor = false;
    }

    protected AnsiColor getColor(Level level) {
        AnsiColor result = this.colors.get(level);
        if (result == null) {
            result = AnsiColor.NOTHING;
        }
        return result;
    }

    protected AnsiColor getReset() {
        return AnsiColor.RESET;
    }
}

