/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.appserv.server.util.Version;
import com.sun.common.util.logging.BooleanLatch;
import com.sun.common.util.logging.GFLogRecord;
import com.sun.common.util.logging.LoggingOutputStream;
import com.sun.enterprise.admin.monitor.callflow.Agent;
import com.sun.enterprise.module.bootstrap.EarlyLogHandler;
import com.sun.enterprise.server.logging.LogEvent;
import com.sun.enterprise.server.logging.LogEventBroadcaster;
import com.sun.enterprise.server.logging.LogEventImpl;
import com.sun.enterprise.server.logging.LogEventListener;
import com.sun.enterprise.server.logging.LogFacade;
import com.sun.enterprise.server.logging.LogFormatHelper;
import com.sun.enterprise.server.logging.LogRotationTimer;
import com.sun.enterprise.server.logging.LogRotationTimerTask;
import com.sun.enterprise.server.logging.LoggingRuntime;
import com.sun.enterprise.server.logging.ODLLogFormatter;
import com.sun.enterprise.server.logging.UniformLogFormatter;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.logging.AgentFormatterDelegate;
import fish.payara.enterprise.server.logging.JSONLogFormatter;
import fish.payara.enterprise.server.logging.PayaraNotificationLogRotationTimer;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.ErrorManager;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import java.util.zip.GZIPOutputStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.api.logging.Task;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
@ContractsProvided(value={GFFileHandler.class, Handler.class, LogEventBroadcaster.class, LoggingRuntime.class})
public class GFFileHandler
extends StreamHandler
implements PostConstruct,
PreDestroy,
LogEventBroadcaster,
LoggingRuntime {
    private static final int DEFAULT_ROTATION_LIMIT_BYTES = 2000000;
    public static final int DISABLE_LOG_FILE_ROTATION_VALUE = 0;
    private static final LocalStringManagerImpl LOCAL_STRINGS = new LocalStringManagerImpl(GFFileHandler.class);
    private static final String RECORD_BEGIN_MARKER = "[#|";
    private static final String RECORD_END_MARKER = "|#]";
    private static final String RECORD_FIELD_SEPARATOR = "|";
    private static final String RECORD_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    @Inject
    protected ServerEnvironmentImpl env;
    @Inject
    @Optional
    private Agent agent;
    @Inject
    private ServiceLocator habitat;
    private MeteredStream meter;
    protected static final String LOGS_DIR = "logs";
    private static final String LOG_FILE_NAME = "server.log";
    private static final String GZIP_EXTENSION = ".gz";
    private String absoluteServerLogName = null;
    private File absoluteFile = null;
    private int flushFrequency = 1;
    private int maxHistoryFiles = 10;
    private boolean logToFile = true;
    private boolean rotationOnDateChange;
    private String excludeFields;
    private Integer rotationLimitAttrValue;
    private Long rotationTimeLimitValue;
    private boolean compressionOnRotation;
    private boolean multiLineMode;
    private String fileHandlerFormatter = "";
    private String currentFileHandlerFormatter = "";
    private boolean logStandardStreams;
    private PrintStream oStdOutBackup = System.out;
    private PrintStream oStdErrBackup = System.err;
    private LoggingOutputStream stdoutOutputStream = null;
    private LoggingOutputStream stderrOutputStream = null;
    private int limitForFileRotation = 0;
    private BlockingQueue<LogRecord> pendingRecords = new ArrayBlockingQueue<LogRecord>(10000);
    private AtomicBoolean rotationRequested = new AtomicBoolean(false);
    private final Object rotationLock = new Object();
    private static final String LOG_ROTATE_DATE_FORMAT = "yyyy-MM-dd'T'HH-mm-ss";
    private static final String DEFAULT_LOG_FILE_FORMATTER_CLASS_NAME = UniformLogFormatter.class.getName();
    public static final int MINIMUM_ROTATION_LIMIT_VALUE = 500000;
    private BooleanLatch done = new BooleanLatch();
    private boolean dayBasedFileRotation = false;
    private List<LogEventListener> logEventListeners = new ArrayList<LogEventListener>();
    private Thread pump;
    protected String logFileProperty = "";
    private final LogManager manager = LogManager.getLogManager();
    private final String className = this.getClass().getName();
    private static final String GF_FILE_HANDLER = GFFileHandler.class.getCanonicalName();
    private LogRecord logRecord = new LogRecord(Level.INFO, "NCLS-LOGGING-00009");

    public void postConstruct() {
        String formatterName;
        boolean mustRotate;
        int jsonLogFormatter;
        int uniformLogFormatter;
        int odlFormatter;
        block43: {
            String filename = this.evaluateFileName();
            File logFile = new File(filename);
            this.absoluteServerLogName = filename;
            if (!logFile.isAbsolute()) {
                logFile = new File(this.env.getInstanceRoot(), filename);
                this.absoluteServerLogName = this.env.getInstanceRoot() + File.separator + filename;
            }
            this.changeFileName(logFile);
            odlFormatter = 0;
            uniformLogFormatter = 0;
            jsonLogFormatter = 0;
            int otherFormatter = 0;
            mustRotate = false;
            try (BufferedReader br = new BufferedReader(new FileReader(logFile));){
                String strLine;
                while ((strLine = br.readLine()) != null) {
                    if ((strLine = strLine.trim()).equals("")) continue;
                    if (LogFormatHelper.isUniformFormatLogHeader(strLine)) {
                        ++uniformLogFormatter;
                    } else if (LogFormatHelper.isODLFormatLogHeader(strLine)) {
                        ++odlFormatter;
                    } else if (LogFormatHelper.isJSONFormatLogHeader(strLine)) {
                        ++jsonLogFormatter;
                    } else {
                        ++otherFormatter;
                    }
                    if (otherFormatter > 0) {
                        mustRotate = true;
                    }
                    break;
                }
            }
            catch (Exception e) {
                ErrorManager em = this.getErrorManager();
                if (em == null) break block43;
                em.error(e.getMessage(), e, 0);
            }
        }
        if (odlFormatter > 0) {
            this.currentFileHandlerFormatter = "com.sun.enterprise.server.logging.ODLLogFormatter";
        } else if (uniformLogFormatter > 0) {
            this.currentFileHandlerFormatter = "com.sun.enterprise.server.logging.UniformLogFormatter";
        } else if (jsonLogFormatter > 0) {
            this.currentFileHandlerFormatter = "fish.payara.enterprise.server.logging.JSONLogFormatter";
        }
        String propertyValue = this.manager.getProperty(this.className + ".logtoFile");
        boolean logToFile = true;
        if (propertyValue != null) {
            logToFile = Boolean.parseBoolean(propertyValue);
        }
        this.setLogToFile(logToFile);
        this.logRecord.setParameters(new Object[]{Version.getFullVersion()});
        this.logRecord.setResourceBundle(ResourceBundle.getBundle("com.sun.enterprise.server.logging.LogMessages"));
        this.logRecord.setThreadID((int)Thread.currentThread().getId());
        this.logRecord.setLoggerName("javax.enterprise.logging");
        EarlyLogHandler.earlyMessages.add(this.logRecord);
        propertyValue = this.manager.getProperty(this.className + ".rotationOnDateChange");
        this.timeBasedRotation(propertyValue);
        propertyValue = this.manager.getProperty(this.className + ".rotationLimitInBytes");
        this.rotationOnFileSizeLimit(propertyValue);
        propertyValue = this.manager.getProperty(this.className + ".flushFrequency");
        if (propertyValue != null) {
            try {
                this.flushFrequency = Integer.parseInt(propertyValue);
            }
            catch (NumberFormatException e) {
                this.logRecord = new LogRecord(Level.WARNING, "NCLS-LOGGING-00012");
                this.logRecord.setParameters(new Object[]{propertyValue, "flushFrequency"});
                this.logRecord.setResourceBundle(ResourceBundle.getBundle("com.sun.enterprise.server.logging.LogMessages"));
                this.logRecord.setThreadID((int)Thread.currentThread().getId());
                this.logRecord.setLoggerName("javax.enterprise.logging");
                EarlyLogHandler.earlyMessages.add(this.logRecord);
            }
        }
        if (this.flushFrequency <= 0) {
            this.flushFrequency = 1;
        }
        propertyValue = this.manager.getProperty(this.className + ".maxHistoryFiles");
        try {
            if (propertyValue != null) {
                this.maxHistoryFiles = Integer.parseInt(propertyValue);
            }
        }
        catch (NumberFormatException e) {
            this.logRecord = new LogRecord(Level.WARNING, "NCLS-LOGGING-00012");
            this.logRecord.setParameters(new Object[]{propertyValue, "maxHistoryFiles"});
            this.logRecord.setResourceBundle(ResourceBundle.getBundle("com.sun.enterprise.server.logging.LogMessages"));
            this.logRecord.setThreadID((int)Thread.currentThread().getId());
            this.logRecord.setLoggerName("javax.enterprise.logging");
            EarlyLogHandler.earlyMessages.add(this.logRecord);
        }
        if (this.maxHistoryFiles < 0) {
            this.maxHistoryFiles = 10;
        }
        propertyValue = this.manager.getProperty(this.className + ".compressOnRotation");
        this.compressionOnRotation = false;
        if (propertyValue != null) {
            this.compressionOnRotation = Boolean.parseBoolean(propertyValue);
        }
        if ((propertyValue = this.manager.getProperty(this.className + ".logStandardStreams")) != null) {
            this.logStandardStreams = Boolean.parseBoolean(propertyValue);
            if (this.logStandardStreams) {
                this.logStandardStreams();
            }
        }
        this.fileHandlerFormatter = formatterName = (formatterName = this.manager.getProperty(this.className + ".formatter")) == null ? DEFAULT_LOG_FILE_FORMATTER_CLASS_NAME : formatterName;
        if (mustRotate) {
            this.rotate();
        } else if (this.fileHandlerFormatter != null && !this.fileHandlerFormatter.equals(this.currentFileHandlerFormatter)) {
            this.rotate();
        }
        this.excludeFields = this.manager.getProperty("com.sun.enterprise.server.logging.GFFileHandler.excludeFields");
        this.multiLineMode = Boolean.parseBoolean(this.manager.getProperty("com.sun.enterprise.server.logging.GFFileHandler.multiLineMode"));
        this.configureLogFormatter(formatterName, this.excludeFields, this.multiLineMode);
    }

    private void configureLogFormatter(String formatterName, String excludeFields, boolean multiLineMode) {
        if (UniformLogFormatter.class.getName().equals(formatterName)) {
            this.configureUniformLogFormatter(excludeFields, multiLineMode);
        } else if (ODLLogFormatter.class.getName().equals(formatterName)) {
            this.configureODLFormatter(excludeFields, multiLineMode);
        } else if (JSONLogFormatter.class.getName().equals(formatterName)) {
            this.configureJSONFormatter(excludeFields);
        } else {
            Formatter currentFormatter = this.getFormatter();
            if (currentFormatter == null || !currentFormatter.getClass().getName().equals(formatterName)) {
                Formatter formatter = this.findFormatterService(formatterName);
                if (formatter == null) {
                    this.logRecord = new LogRecord(Level.SEVERE, "NCLS-LOGGING-00013");
                    this.logRecord.setParameters(new Object[]{formatterName});
                    this.logRecord.setThreadID((int)Thread.currentThread().getId());
                    this.logRecord.setResourceBundle(ResourceBundle.getBundle("com.sun.enterprise.server.logging.LogMessages"));
                    this.logRecord.setLoggerName("javax.enterprise.logging");
                    EarlyLogHandler.earlyMessages.add(this.logRecord);
                    this.configureDefaultFormatter(excludeFields, multiLineMode);
                } else {
                    this.setFormatter(formatter);
                }
            }
        }
        formatterName = this.getFormatter().getClass().getName();
        this.logRecord = new LogRecord(Level.INFO, "NCLS-LOGGING-00010");
        this.logRecord.setParameters(new Object[]{formatterName});
        this.logRecord.setResourceBundle(ResourceBundle.getBundle("com.sun.enterprise.server.logging.LogMessages"));
        this.logRecord.setThreadID((int)Thread.currentThread().getId());
        this.logRecord.setLoggerName("javax.enterprise.logging");
        EarlyLogHandler.earlyMessages.add(this.logRecord);
    }

    private void timeBasedRotation(String propertyValue) {
        this.rotationOnDateChange = false;
        if (propertyValue != null) {
            this.rotationOnDateChange = Boolean.parseBoolean(propertyValue);
        }
        if (this.rotationOnDateChange) {
            this.rotationOnDateChange();
        } else {
            this.rotationTimeLimitValue = 0L;
            try {
                propertyValue = this.manager.getProperty(this.className + ".rotationTimelimitInMinutes");
                if (propertyValue != null) {
                    this.rotationTimeLimitValue = Long.parseLong(propertyValue);
                }
            }
            catch (NumberFormatException e) {
                this.logRecord = new LogRecord(Level.WARNING, "NCLS-LOGGING-00012");
                this.logRecord.setParameters(new Object[]{propertyValue, "rotationTimelimitInMinutes"});
                this.logRecord.setResourceBundle(ResourceBundle.getBundle("com.sun.enterprise.server.logging.LogMessages"));
                this.logRecord.setThreadID((int)Thread.currentThread().getId());
                this.logRecord.setLoggerName("javax.enterprise.logging");
                EarlyLogHandler.earlyMessages.add(this.logRecord);
            }
            this.rotationOnTimeLimit();
        }
    }

    private void rotationOnDateChange() {
        Date nextDay;
        this.dayBasedFileRotation = true;
        this.rotationTimeLimitValue = 0L;
        int millisecondsInDay = 86400000;
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
        long systemTime = System.currentTimeMillis();
        String nextDate = dateFormat.format(date.getTime() + (long)millisecondsInDay);
        try {
            nextDay = dateFormat.parse(nextDate);
        }
        catch (ParseException e) {
            nextDay = new Date();
            this.logRecord = new LogRecord(Level.WARNING, "NCLS-LOGGING-00011");
            this.logRecord.setParameters(new Object[]{nextDate});
            this.logRecord.setResourceBundle(ResourceBundle.getBundle("com.sun.enterprise.server.logging.LogMessages"));
            this.logRecord.setThreadID((int)Thread.currentThread().getId());
            this.logRecord.setLoggerName("javax.enterprise.logging");
            EarlyLogHandler.earlyMessages.add(this.logRecord);
        }
        long nextDaySystemTime = nextDay.getTime();
        this.rotationTimeLimitValue = nextDaySystemTime - systemTime;
        Task<Object> rotationTask = () -> {
            this.rotate();
            return null;
        };
        if (this.className.equals(GF_FILE_HANDLER)) {
            LogRotationTimer.getInstance().startTimer(new LogRotationTimerTask(rotationTask, this.rotationTimeLimitValue / 60000L));
        } else {
            PayaraNotificationLogRotationTimer.getInstance().startTimer(new LogRotationTimerTask(rotationTask, this.rotationTimeLimitValue / 60000L));
        }
    }

    private void rotationOnTimeLimit() {
        if (this.rotationTimeLimitValue > 0L) {
            Task<Object> rotationTask = () -> {
                this.rotate();
                return null;
            };
            if (this.className.equals(GF_FILE_HANDLER)) {
                LogRotationTimer.getInstance().startTimer(new LogRotationTimerTask(rotationTask, this.rotationTimeLimitValue));
            } else {
                PayaraNotificationLogRotationTimer.getInstance().startTimer(new LogRotationTimerTask(rotationTask, this.rotationTimeLimitValue));
            }
        }
    }

    private void rotationOnFileSizeLimit(String propertyValue) {
        try {
            this.rotationLimitAttrValue = propertyValue != null ? Integer.valueOf(Integer.parseInt(propertyValue)) : Integer.valueOf(2000000);
        }
        catch (NumberFormatException e) {
            this.logRecord = new LogRecord(Level.WARNING, "NCLS-LOGGING-00012");
            this.logRecord.setParameters(new Object[]{propertyValue, "rotationLimitInBytes"});
            this.logRecord.setResourceBundle(ResourceBundle.getBundle("com.sun.enterprise.server.logging.LogMessages"));
            this.logRecord.setThreadID((int)Thread.currentThread().getId());
            this.logRecord.setLoggerName("javax.enterprise.logging");
            EarlyLogHandler.earlyMessages.add(this.logRecord);
        }
        if (this.rotationLimitAttrValue >= 500000 || this.rotationLimitAttrValue == 0) {
            this.setLimitForRotation(this.rotationLimitAttrValue);
        }
    }

    protected String evaluateFileName() {
        String cname = this.getClass().getName();
        LogManager manager = LogManager.getLogManager();
        this.logFileProperty = manager.getProperty(cname + ".file");
        if (this.logFileProperty == null || this.logFileProperty.trim().equals("")) {
            this.logFileProperty = this.env.getInstanceRoot().getAbsolutePath() + File.separator + LOGS_DIR + File.separator + LOG_FILE_NAME;
        }
        return TranslatedConfigView.expandConfigValue((String)this.logFileProperty);
    }

    Formatter findFormatterService(String formatterName) {
        List formatterServices = this.habitat.getAllServices(Formatter.class, new Annotation[0]);
        for (Formatter formatter : formatterServices) {
            if (!formatter.getClass().getName().equals(formatterName)) continue;
            return formatter;
        }
        return null;
    }

    private void configureDefaultFormatter(String excludeFields, boolean multiLineMode) {
        this.configureUniformLogFormatter(excludeFields, multiLineMode);
    }

    private void configureODLFormatter(String excludeFields, boolean multiLineMode) {
        ODLLogFormatter formatterClass;
        if (this.agent != null) {
            formatterClass = new ODLLogFormatter(new AgentFormatterDelegate(this.agent));
            this.setFormatter(formatterClass);
        } else {
            formatterClass = new ODLLogFormatter();
            this.setFormatter(formatterClass);
        }
        formatterClass.setExcludeFields(excludeFields);
        formatterClass.setMultiLineMode(multiLineMode);
        formatterClass.noAnsi();
        formatterClass.setLogEventBroadcaster(this);
    }

    private void configureUniformLogFormatter(String excludeFields, boolean multiLineMode) {
        String recordDateFormat;
        String recordFieldSeparator;
        String recordEndMarker;
        UniformLogFormatter formatterClass;
        LogManager manager = LogManager.getLogManager();
        String cname = this.getClass().getName();
        if (this.agent != null) {
            formatterClass = new UniformLogFormatter(new AgentFormatterDelegate(this.agent));
            this.setFormatter(formatterClass);
        } else {
            formatterClass = new UniformLogFormatter();
            this.setFormatter(formatterClass);
        }
        formatterClass.setExcludeFields(excludeFields);
        formatterClass.setMultiLineMode(multiLineMode);
        formatterClass.setLogEventBroadcaster(this);
        formatterClass.noAnsi();
        String recordBeginMarker = manager.getProperty(cname + ".logFormatBeginMarker");
        if (recordBeginMarker == null || "".equals(recordBeginMarker)) {
            recordBeginMarker = RECORD_BEGIN_MARKER;
        }
        if ((recordEndMarker = manager.getProperty(cname + ".logFormatEndMarker")) == null || "".equals(recordEndMarker)) {
            recordEndMarker = RECORD_END_MARKER;
        }
        if ((recordFieldSeparator = manager.getProperty(cname + ".logFormatFieldSeparator")) == null || "".equals(recordFieldSeparator) || recordFieldSeparator.length() > 1) {
            recordFieldSeparator = RECORD_FIELD_SEPARATOR;
        }
        if ((recordDateFormat = manager.getProperty(cname + ".logFormatDateFormat")) != null && !"".equals(recordDateFormat)) {
            SimpleDateFormat sdf = new SimpleDateFormat(recordDateFormat);
            try {
                sdf.format(new Date());
            }
            catch (Exception e) {
                recordDateFormat = RECORD_DATE_FORMAT;
            }
        } else {
            recordDateFormat = RECORD_DATE_FORMAT;
        }
        formatterClass.setRecordBeginMarker(recordBeginMarker);
        formatterClass.setRecordEndMarker(recordEndMarker);
        formatterClass.setRecordDateFormat(recordDateFormat);
        formatterClass.setRecordFieldSeparator(recordFieldSeparator);
    }

    void initializePump() {
        this.pump = new Thread(){

            @Override
            public void run() {
                while (!GFFileHandler.this.done.isSignalled() && GFFileHandler.this.logToFile) {
                    try {
                        GFFileHandler.this.log();
                    }
                    catch (Exception exception) {}
                }
            }
        };
        this.pump.setName("GFFileHandler log pump");
        this.pump.setDaemon(true);
        this.pump.start();
    }

    public void preDestroy() {
        if (LogFacade.LOGGING_LOGGER.isLoggable(Level.FINE)) {
            LogFacade.LOGGING_LOGGER.fine("Logger handler killed");
        }
        System.setOut(this.oStdOutBackup);
        System.setErr(this.oStdErrBackup);
        try {
            if (this.stdoutOutputStream != null) {
                this.stdoutOutputStream.close();
            }
            if (this.stderrOutputStream != null) {
                this.stderrOutputStream.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.done.tryReleaseShared(1);
        if (this.pump != null) {
            this.pump.interrupt();
        }
        this.drainAllPendingRecords();
        this.flush();
    }

    private void drainAllPendingRecords() {
        this.drainPendingRecords(0);
    }

    private void drainPendingRecords(int flushAmount) {
        if (!this.pendingRecords.isEmpty()) {
            ArrayList records;
            if (flushAmount > 0) {
                records = new ArrayList(flushAmount);
                this.pendingRecords.drainTo(records, flushAmount);
            } else {
                records = new ArrayList(this.pendingRecords.size());
                this.pendingRecords.drainTo(records);
            }
            for (LogRecord record : records) {
                super.publish(record);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeFileName(File file) {
        if (file.equals(this.absoluteFile)) {
            return;
        }
        Object object = this.rotationLock;
        synchronized (object) {
            super.flush();
            super.close();
            try {
                this.openFile(file);
                this.absoluteFile = file;
            }
            catch (IOException ix) {
                new ErrorManager().error("FATAL ERROR: COULD NOT OPEN LOG FILE. Please Check to make sure that the directory for Logfile exists. Currently reverting back to use the  default server.log", ix, 4);
                try {
                    this.openFile(this.absoluteFile);
                }
                catch (Exception e) {
                    new ErrorManager().error("FATAL ERROR: COULD NOT RE-OPEN SERVER LOG FILE. ", e, 4);
                }
            }
        }
    }

    @Override
    public File getCurrentLogFile() {
        return this.absoluteFile;
    }

    private synchronized void setLimitForRotation(int rotationLimitInBytes) {
        this.limitForFileRotation = rotationLimitInBytes;
    }

    private void configureJSONFormatter(String excludeFields) {
        JSONLogFormatter formatterClass;
        if (this.agent != null) {
            formatterClass = new JSONLogFormatter(new AgentFormatterDelegate(this.agent));
            this.setFormatter(formatterClass);
        } else {
            formatterClass = new JSONLogFormatter();
            this.setFormatter(formatterClass);
        }
        formatterClass.setExcludeFields(excludeFields);
        formatterClass.setLogEventBroadcaster(this);
    }

    private void openFile(File file) throws IOException {
        File parent = file.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException(LOCAL_STRINGS.getLocalString("parent.dir.create.failed", "Failed to create the parent dir {0}", new Object[]{parent.getAbsolutePath()}));
        }
        FileOutputStream fout = new FileOutputStream(file, true);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        this.meter = new MeteredStream(bout, file.length());
        this.setOutputStream(this.meter);
    }

    void requestRotation() {
        this.rotationRequested.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUpHistoryLogFiles() {
        if (this.maxHistoryFiles == 0) {
            return;
        }
        Object object = this.rotationLock;
        synchronized (object) {
            File dir = this.absoluteFile.getParentFile();
            String logFileName = this.absoluteFile.getName();
            if (dir == null) {
                return;
            }
            File[] fset = dir.listFiles();
            ArrayList<String> candidates = new ArrayList<String>();
            for (int i = 0; fset != null && i < fset.length; ++i) {
                if (logFileName.equals(fset[i].getName()) || !fset[i].isFile() || !fset[i].getName().startsWith(logFileName)) continue;
                candidates.add(fset[i].getAbsolutePath());
            }
            if (candidates.size() <= this.maxHistoryFiles) {
                return;
            }
            Object[] paths = candidates.toArray();
            Arrays.sort(paths);
            try {
                for (int i = 0; i < paths.length - this.maxHistoryFiles; ++i) {
                    File logFile = new File((String)paths[i]);
                    boolean delFile = logFile.delete();
                    if (delFile) continue;
                    throw new IOException("Could not delete log file: " + logFile.getAbsolutePath());
                }
            }
            catch (Exception e) {
                new ErrorManager().error("FATAL ERROR: COULD NOT DELETE LOG FILE.", e, 0);
            }
        }
    }

    public void rotate() {
        GFFileHandler thisInstance = this;
        AccessController.doPrivileged(() -> {
            Object object = thisInstance.rotationLock;
            synchronized (object) {
                if (thisInstance.meter != null && thisInstance.meter.written <= 0L) {
                    return null;
                }
                thisInstance.flush();
                thisInstance.close();
                try {
                    if (!this.absoluteFile.exists()) {
                        File creatingDeletedLogFile = new File(this.absoluteFile.getAbsolutePath());
                        if (creatingDeletedLogFile.createNewFile()) {
                            this.absoluteFile = creatingDeletedLogFile;
                        }
                    } else {
                        File oldFile = this.absoluteFile;
                        StringBuffer renamedFileName = new StringBuffer(this.absoluteFile + "_");
                        new SimpleDateFormat(LOG_ROTATE_DATE_FORMAT).format(new Date(), renamedFileName, new FieldPosition(0));
                        File rotatedFile = new File(renamedFileName.toString());
                        boolean renameSuccess = oldFile.renameTo(rotatedFile);
                        if (!renameSuccess) {
                            FileUtils.copy((File)this.absoluteFile, (File)rotatedFile);
                            File freshServerLogFile = this.getLogFileName();
                            FileOutputStream fo = new FileOutputStream(freshServerLogFile);
                            fo.close();
                        }
                        FileOutputStream oldFileFO = new FileOutputStream(oldFile);
                        oldFileFO.close();
                        this.openFile(this.getLogFileName());
                        this.absoluteFile = this.getLogFileName();
                        this.restartTimeBasedLogRotation();
                        if (this.compressionOnRotation) {
                            boolean compressed = this.gzipFile(rotatedFile);
                            if (compressed) {
                                boolean deleted = rotatedFile.delete();
                                if (!deleted) {
                                    throw new IOException("Could not delete uncompressed log file: " + rotatedFile.getAbsolutePath());
                                }
                            } else {
                                throw new IOException("Could not compress log file: " + rotatedFile.getAbsolutePath());
                            }
                        }
                        this.cleanUpHistoryLogFiles();
                    }
                }
                catch (IOException ix) {
                    new ErrorManager().error("Error, could not rotate log file", ix, 0);
                }
                return null;
            }
        });
    }

    private void restartTimeBasedLogRotation() {
        if (this.dayBasedFileRotation) {
            if (this.className.equals(GF_FILE_HANDLER)) {
                LogRotationTimer.getInstance().restartTimerForDayBasedRotation();
            } else {
                PayaraNotificationLogRotationTimer.getInstance().restartTimerForDayBasedRotation();
            }
        } else if (this.className.equals(GF_FILE_HANDLER)) {
            LogRotationTimer.getInstance().restartTimer();
        } else {
            PayaraNotificationLogRotationTimer.getInstance().restartTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log() {
        if (this.logToFile) {
            try {
                LogRecord record = this.pendingRecords.take();
                super.publish(record);
            }
            catch (InterruptedException e) {
                return;
            }
            if (this.flushFrequency > 1) {
                this.drainPendingRecords(this.flushFrequency - 1);
            }
            this.flush();
            if (this.rotationRequested.get() || this.limitForFileRotation > 0 && this.meter.written >= (long)this.limitForFileRotation) {
                Object object = this.rotationLock;
                synchronized (object) {
                    this.rotate();
                    this.rotationRequested.set(false);
                }
            }
        }
    }

    @Override
    public void publish(LogRecord record) {
        Formatter formatter;
        GFLogRecord recordWrapper;
        if (this.done.isSignalled()) {
            return;
        }
        if (record.getClass().getSimpleName().equals("GFLogRecord")) {
            recordWrapper = (GFLogRecord)record;
            if (recordWrapper.getThreadName() == null) {
                recordWrapper.setThreadName(Thread.currentThread().getName());
            }
        } else {
            recordWrapper = new GFLogRecord(record);
            recordWrapper.setThreadName(Thread.currentThread().getName());
        }
        if (this.logToFile) {
            try {
                this.pendingRecords.add((LogRecord)recordWrapper);
            }
            catch (IllegalStateException e) {
                new ErrorManager().error("GFFileHandler: Queue full. Waiting to submit.", e, 0);
                try {
                    this.pendingRecords.put((LogRecord)recordWrapper);
                }
                catch (InterruptedException e1) {
                    new ErrorManager().error("GFFileHandler: Waiting was interrupted. Log record lost.", e1, 0);
                }
            }
        }
        if (!((formatter = this.getFormatter()) instanceof LogEventBroadcaster)) {
            LogEventImpl logEvent = new LogEventImpl(record);
            this.informLogEventListeners(logEvent);
        }
    }

    protected File getLogFileName() {
        return new File(this.absoluteServerLogName);
    }

    public boolean addLogEventListener(LogEventListener listener) {
        if (this.logEventListeners.contains(listener)) {
            return false;
        }
        return this.logEventListeners.add(listener);
    }

    public boolean removeLogEventListener(LogEventListener listener) {
        return this.logEventListeners.remove(listener);
    }

    @Override
    public void informLogEventListeners(LogEvent logEvent) {
        for (LogEventListener listener : this.logEventListeners) {
            listener.messageLogged(logEvent);
        }
    }

    private boolean gzipFile(File infile) {
        boolean status = false;
        try (FileInputStream fis = new FileInputStream(infile);
             FileOutputStream fos = new FileOutputStream(infile.getCanonicalPath() + GZIP_EXTENSION);
             GZIPOutputStream gzos = new GZIPOutputStream(fos);){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = fis.read(buffer)) != -1) {
                gzos.write(buffer, 0, len);
            }
            gzos.finish();
            status = true;
        }
        catch (IOException ix) {
            new ErrorManager().error("Error gzipping log file", ix, 0);
        }
        return status;
    }

    private void logStandardStreams() {
        Logger _ologger = LogFacade.STDOUT_LOGGER;
        LoggingOutputStream loggingOutputStream = this.stdoutOutputStream = new LoggingOutputStream(_ologger, Level.INFO);
        loggingOutputStream.getClass();
        LoggingOutputStream.LoggingPrintStream pout = new LoggingOutputStream.LoggingPrintStream(loggingOutputStream, (ByteArrayOutputStream)this.stdoutOutputStream);
        System.setOut((PrintStream)pout);
        Logger _elogger = LogFacade.STDERR_LOGGER;
        LoggingOutputStream loggingOutputStream2 = this.stderrOutputStream = new LoggingOutputStream(_elogger, Level.SEVERE);
        loggingOutputStream2.getClass();
        LoggingOutputStream.LoggingPrintStream perr = new LoggingOutputStream.LoggingPrintStream(loggingOutputStream2, (ByteArrayOutputStream)this.stderrOutputStream);
        System.setErr((PrintStream)perr);
    }

    public synchronized void setLogFile(String fileName) {
        String logFileName = TranslatedConfigView.expandConfigValue((String)fileName);
        File logFile = new File(logFileName);
        if (!logFile.isAbsolute()) {
            logFile = new File(this.env.getInstanceRoot(), logFileName);
        }
        this.changeFileName(logFile);
        this.absoluteServerLogName = logFileName;
    }

    public synchronized void setLogToFile(boolean logToFile) {
        this.logToFile = logToFile;
        this.initializePump();
    }

    public synchronized void setRotationOnDateChange(boolean rotationOnDateChange) {
        this.rotationOnDateChange = rotationOnDateChange;
        this.restartTimeBasedLogRotation();
        this.rotationOnDateChange();
    }

    public synchronized void setMultiLineMode(boolean multiLineMode) {
        this.multiLineMode = multiLineMode;
        this.rotate();
        this.configureLogFormatter(this.fileHandlerFormatter, this.excludeFields, multiLineMode);
    }

    public synchronized void setFileHandlerFormatter(String fileHandlerFormatter) {
        this.fileHandlerFormatter = fileHandlerFormatter;
        this.rotate();
        this.configureLogFormatter(fileHandlerFormatter, this.excludeFields, this.multiLineMode);
    }

    public synchronized void setExcludeFields(String excludeFields) {
        this.excludeFields = excludeFields;
        this.rotate();
        this.configureLogFormatter(this.fileHandlerFormatter, excludeFields, this.multiLineMode);
    }

    public synchronized void setRotationLimitAttrValue(Integer rotationLimitAttrValue) {
        this.rotationLimitAttrValue = rotationLimitAttrValue;
        if (rotationLimitAttrValue >= 500000 || rotationLimitAttrValue == 0) {
            this.setLimitForRotation(rotationLimitAttrValue);
        }
    }

    public synchronized void setRotationTimeLimitValue(Long rotationTimeLimitValue) {
        this.rotationTimeLimitValue = rotationTimeLimitValue;
        this.restartTimeBasedLogRotation();
        this.rotationOnTimeLimit();
    }

    public synchronized void setMaxHistoryFiles(int maxHistoryFiles) {
        this.maxHistoryFiles = maxHistoryFiles;
    }

    public synchronized void setFlushFrequency(int flushFrequency) {
        this.flushFrequency = flushFrequency;
    }

    public synchronized void setCompressionOnRotation(boolean compressionOnRotation) {
        this.compressionOnRotation = compressionOnRotation;
    }

    public synchronized void setLogStandardStreams(boolean logStandardStreams) {
        this.logStandardStreams = logStandardStreams;
        if (logStandardStreams) {
            this.logStandardStreams();
        } else {
            System.setOut(this.oStdOutBackup);
            System.setErr(this.oStdErrBackup);
        }
    }

    private static final class MeteredStream
    extends OutputStream {
        private volatile boolean isOpen;
        OutputStream out;
        long written;

        MeteredStream(OutputStream out, long written) {
            this.out = out;
            this.written = written;
            this.isOpen = true;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.written;
        }

        @Override
        public void write(byte[] buff) throws IOException {
            this.out.write(buff);
            this.written += (long)buff.length;
        }

        @Override
        public void write(byte[] buff, int off, int len) throws IOException {
            this.out.write(buff, off, len);
            this.written += (long)len;
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            if (this.isOpen) {
                this.isOpen = false;
                this.flush();
                this.out.close();
            }
        }
    }
}

