/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.enterprise.server.logging;

import com.sun.common.util.logging.GFLogRecord;
import com.sun.enterprise.server.logging.ExcludeFieldsSupport;
import com.sun.enterprise.server.logging.FormatterDelegate;
import com.sun.enterprise.server.logging.LogEvent;
import com.sun.enterprise.server.logging.LogEventBroadcaster;
import com.sun.enterprise.server.logging.LogEventImpl;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.ErrorManager;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.glassfish.api.VersionInfo;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Service;

@Service
@ContractsProvided(value={JSONLogFormatter.class, Formatter.class})
@PerLookup
public class JSONLogFormatter
extends Formatter
implements LogEventBroadcaster {
    private static final String RECORD_NUMBER = "RecordNumber";
    private static final String METHOD_NAME = "MethodName";
    private static final String CLASS_NAME = "ClassName";
    private final ServiceLocator habitat = Globals.getDefaultBaseServiceLocator();
    private Map<String, ResourceBundle> loggerResourceBundleTable;
    private LogManager logManager;
    private final Date date = new Date();
    private static boolean LOG_SOURCE_IN_KEY_VALUE;
    private static boolean RECORD_NUMBER_IN_KEY_VALUE;
    private FormatterDelegate _delegate = null;
    private long recordNumber = 0L;
    private String recordDateFormat;
    private static final String LINE_SEPARATOR;
    private String TIMESTAMP_KEY = "Timestamp";
    private String LOG_LEVEL_KEY = "Level";
    private String PRODUCT_ID_KEY = "Version";
    private String LOGGER_NAME_KEY = "LoggerName";
    private String EXCEPTION_KEY = "Exception";
    private String STACK_TRACE_KEY = "StackTrace";
    private String THREAD_ID_KEY = "ThreadID";
    private String THREAD_NAME_KEY = "ThreadName";
    private String USER_ID_KEY = "UserId";
    private String ECID_KEY = "ECId";
    private String LEVEL_VALUE_KEY = "LevelValue";
    private String TIME_MILLIS_KEY = "TimeMillis";
    private String MESSAGE_ID_KEY = "MessageID";
    private String LOG_MESSAGE_KEY = "LogMessage";
    private String THROWABLE_KEY = "Throwable";
    private static final String RFC3339_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private final ExcludeFieldsSupport excludeFieldsSupport = new ExcludeFieldsSupport();
    private LogEventBroadcaster logEventBroadcasterDelegate;
    private String productId = "";
    @Deprecated
    private static final String PAYARA_JSONLOGFORMATTER_UNDERSCORE = "fish.payara.deprecated.jsonlogformatter.underscoreprefix";

    public JSONLogFormatter() {
        this.loggerResourceBundleTable = new HashMap<String, ResourceBundle>();
        this.logManager = LogManager.getLogManager();
        String underscorePrefix = this.logManager.getProperty(PAYARA_JSONLOGFORMATTER_UNDERSCORE);
        if (Boolean.parseBoolean(underscorePrefix)) {
            this.TIMESTAMP_KEY = "_" + this.TIMESTAMP_KEY;
            this.LOG_LEVEL_KEY = "_" + this.LOG_LEVEL_KEY;
            this.PRODUCT_ID_KEY = "_" + this.PRODUCT_ID_KEY;
            this.LOGGER_NAME_KEY = "_" + this.LOGGER_NAME_KEY;
            this.EXCEPTION_KEY = "_" + this.EXCEPTION_KEY;
            this.STACK_TRACE_KEY = "_" + this.STACK_TRACE_KEY;
            this.THREAD_ID_KEY = "_" + this.THREAD_ID_KEY;
            this.THREAD_NAME_KEY = "_" + this.THREAD_NAME_KEY;
            this.USER_ID_KEY = "_" + this.USER_ID_KEY;
            this.ECID_KEY = "_" + this.ECID_KEY;
            this.LEVEL_VALUE_KEY = "_" + this.LEVEL_VALUE_KEY;
            this.TIME_MILLIS_KEY = "_" + this.TIME_MILLIS_KEY;
            this.MESSAGE_ID_KEY = "_" + this.MESSAGE_ID_KEY;
            this.LOG_MESSAGE_KEY = "_" + this.LOG_MESSAGE_KEY;
            this.THROWABLE_KEY = "_" + this.THROWABLE_KEY;
        }
    }

    public JSONLogFormatter(FormatterDelegate delegate) {
        this();
        this._delegate = delegate;
    }

    public void setDelegate(FormatterDelegate delegate) {
        this._delegate = delegate;
    }

    @Override
    public String format(LogRecord record) {
        return this.jsonLogFormat(record);
    }

    @Override
    public String formatMessage(LogRecord record) {
        return this.jsonLogFormat(record);
    }

    protected String getProductId() {
        if (this.habitat != null) {
            VersionInfo version = (VersionInfo)this.habitat.getService(VersionInfo.class, new Annotation[0]);
            if (this.productId.isEmpty() && version != null) {
                StringBuilder builder = new StringBuilder();
                builder.append(version.getAbbreviatedProductName());
                builder.append(' ');
                builder.append(version.getVersionPrefix());
                builder.append(version.getMajorVersion());
                builder.append('.');
                builder.append(version.getMinorVersion());
                builder.append('.');
                builder.append(version.getUpdateVersion());
                this.productId = builder.toString();
            }
        }
        return this.productId;
    }

    private String jsonLogFormat(LogRecord record) {
        try {
            JsonObjectBuilder eventObject;
            LogEventImpl logEvent;
            block76: {
                String logMessage;
                Object[] parameters;
                String messageId;
                String ecid;
                String userId;
                logEvent = new LogEventImpl();
                eventObject = Json.createObjectBuilder();
                SimpleDateFormat dateFormatter = null != this.getRecordDateFormat() ? new SimpleDateFormat(this.getRecordDateFormat()) : new SimpleDateFormat(RFC3339_DATE_FORMAT);
                this.date.setTime(record.getMillis());
                String timestampValue = dateFormatter.format(this.date);
                logEvent.setTimestamp(timestampValue);
                eventObject.add(this.TIMESTAMP_KEY, timestampValue);
                Level eventLevel = record.getLevel();
                logEvent.setLevel(eventLevel.getName());
                eventObject.add(this.LOG_LEVEL_KEY, eventLevel.getLocalizedName());
                this.productId = this.getProductId();
                logEvent.setComponentId(this.productId);
                eventObject.add(this.PRODUCT_ID_KEY, this.productId);
                String loggerName = record.getLoggerName();
                if (null == loggerName) {
                    loggerName = "";
                }
                logEvent.setLogger(loggerName);
                eventObject.add(this.LOGGER_NAME_KEY, loggerName);
                if (!this.excludeFieldsSupport.isSet(ExcludeFieldsSupport.SupplementalAttribute.TID)) {
                    int threadId = record.getThreadID();
                    logEvent.setThreadId(threadId);
                    eventObject.add(this.THREAD_ID_KEY, String.valueOf(threadId));
                    String threadName = record instanceof GFLogRecord ? ((GFLogRecord)record).getThreadName() : Thread.currentThread().getName();
                    logEvent.setThreadName(threadName);
                    eventObject.add(this.THREAD_NAME_KEY, threadName);
                }
                if (!this.excludeFieldsSupport.isSet(ExcludeFieldsSupport.SupplementalAttribute.USERID) && null != (userId = logEvent.getUser()) && !userId.isEmpty()) {
                    eventObject.add(this.USER_ID_KEY, userId);
                }
                if (!this.excludeFieldsSupport.isSet(ExcludeFieldsSupport.SupplementalAttribute.ECID) && null != (ecid = logEvent.getECId()) && !ecid.isEmpty()) {
                    eventObject.add(this.ECID_KEY, ecid);
                }
                if (!this.excludeFieldsSupport.isSet(ExcludeFieldsSupport.SupplementalAttribute.TIME_MILLIS)) {
                    long timestamp = record.getMillis();
                    logEvent.setTimeMillis(timestamp);
                    eventObject.add(this.TIME_MILLIS_KEY, String.valueOf(timestamp));
                }
                Level level = record.getLevel();
                if (!this.excludeFieldsSupport.isSet(ExcludeFieldsSupport.SupplementalAttribute.LEVEL_VALUE)) {
                    int levelValue = level.intValue();
                    logEvent.setLevelValue(levelValue);
                    eventObject.add(this.LEVEL_VALUE_KEY, String.valueOf(levelValue));
                }
                if ((messageId = JSONLogFormatter.getMessageId(record)) != null && !messageId.isEmpty()) {
                    logEvent.setMessageId(messageId);
                    eventObject.add(this.MESSAGE_ID_KEY, messageId);
                }
                if (LOG_SOURCE_IN_KEY_VALUE || level.intValue() <= Level.FINE.intValue()) {
                    Object[] sourceMethodName;
                    String sourceClassName = record.getSourceClassName();
                    if (null != sourceClassName && !sourceClassName.isEmpty()) {
                        logEvent.getSupplementalAttributes().put(CLASS_NAME, sourceClassName);
                        eventObject.add(CLASS_NAME, sourceClassName);
                    }
                    if (null != (sourceMethodName = record.getSourceMethodName()) && !sourceMethodName.isEmpty()) {
                        logEvent.getSupplementalAttributes().put(METHOD_NAME, sourceMethodName);
                        eventObject.add(METHOD_NAME, (String)sourceMethodName);
                    }
                }
                if (RECORD_NUMBER_IN_KEY_VALUE) {
                    ++this.recordNumber;
                    logEvent.getSupplementalAttributes().put(RECORD_NUMBER, this.recordNumber);
                    eventObject.add(RECORD_NUMBER, String.valueOf(this.recordNumber));
                }
                if (null != this._delegate) {
                    this._delegate.format(new StringBuilder().append(eventObject.toString()), level);
                }
                if ((parameters = record.getParameters()) != null) {
                    for (Object parameter : parameters) {
                        if (!(parameter instanceof Map)) continue;
                        for (Map.Entry entry : ((Map)parameter).entrySet()) {
                            String key = entry.getKey() != null ? entry.getKey().toString() : "null";
                            if (entry.getValue() != null) {
                                eventObject.add(key, entry.getValue().toString());
                                continue;
                            }
                            eventObject.add(key, "null");
                        }
                    }
                }
                if (null == (logMessage = record.getMessage()) || logMessage.trim().equals("")) {
                    Throwable throwable = record.getThrown();
                    if (null != throwable) {
                        Object parameter;
                        StringWriter stringWriter = new StringWriter();
                        parameter = null;
                        try {
                            Map.Entry entry;
                            PrintWriter printWriter = new PrintWriter(stringWriter);
                            entry = null;
                            try {
                                JsonObjectBuilder traceObject = Json.createObjectBuilder();
                                throwable.printStackTrace(printWriter);
                                if (throwable.getMessage() != null) {
                                    traceObject.add(this.EXCEPTION_KEY, throwable.getMessage());
                                }
                                logMessage = stringWriter.toString();
                                traceObject.add(this.STACK_TRACE_KEY, logMessage);
                                logEvent.setMessage(logMessage);
                                eventObject.add(this.THROWABLE_KEY, (JsonValue)traceObject.build());
                            }
                            catch (Throwable throwable2) {
                                entry = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (printWriter != null) {
                                    if (entry != null) {
                                        try {
                                            printWriter.close();
                                        }
                                        catch (Throwable throwable3) {
                                            ((Throwable)((Object)entry)).addSuppressed(throwable3);
                                        }
                                    } else {
                                        printWriter.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable4) {
                            parameter = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (stringWriter != null) {
                                if (parameter != null) {
                                    try {
                                        stringWriter.close();
                                    }
                                    catch (Throwable throwable5) {
                                        ((Throwable)parameter).addSuppressed(throwable5);
                                    }
                                } else {
                                    stringWriter.close();
                                }
                            }
                        }
                    }
                } else {
                    if (logMessage.contains("{0") && logMessage.contains("}") && null != record.getParameters()) {
                        logMessage = MessageFormat.format(logMessage, record.getParameters());
                    } else {
                        ResourceBundle bundle = this.getResourceBundle(record.getLoggerName());
                        if (null != bundle) {
                            try {
                                logMessage = MessageFormat.format(bundle.getString(logMessage), record.getParameters());
                            }
                            catch (MissingResourceException stringWriter) {
                                // empty catch block
                            }
                        }
                    }
                    StringBuilder logMessageBuilder = new StringBuilder();
                    logMessageBuilder.append(logMessage);
                    Throwable throwable = JSONLogFormatter.getThrowable(record);
                    if (null != throwable) {
                        StringWriter stringWriter = new StringWriter();
                        Object object = null;
                        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
                            JsonObjectBuilder traceObject = Json.createObjectBuilder();
                            throwable.printStackTrace(printWriter);
                            logMessage = stringWriter.toString();
                            traceObject.add(this.EXCEPTION_KEY, logMessageBuilder.toString());
                            traceObject.add(this.STACK_TRACE_KEY, logMessage);
                            logEvent.setMessage(logMessage);
                            eventObject.add(this.THROWABLE_KEY, (JsonValue)traceObject.build());
                            break block76;
                        }
                        catch (Throwable throwable6) {
                            object = throwable6;
                            throw throwable6;
                        }
                        finally {
                            if (stringWriter != null) {
                                if (object != null) {
                                    try {
                                        stringWriter.close();
                                    }
                                    catch (Throwable throwable7) {
                                        ((Throwable)object).addSuppressed(throwable7);
                                    }
                                } else {
                                    stringWriter.close();
                                }
                            }
                        }
                    }
                    logMessage = logMessageBuilder.toString();
                    logEvent.setMessage(logMessage);
                    eventObject.add(this.LOG_MESSAGE_KEY, logMessage);
                }
            }
            this.informLogEventListeners(logEvent);
            return eventObject.build().toString() + LINE_SEPARATOR;
        }
        catch (Exception ex) {
            new ErrorManager().error("Error in formatting Logrecord", ex, 5);
            return "";
        }
    }

    static String getMessageId(LogRecord record) {
        ResourceBundle bundle;
        String message = record.getMessage();
        if (null != message && !message.isEmpty() && null != (bundle = record.getResourceBundle()) && bundle.containsKey(message) && !bundle.getString(message).isEmpty()) {
            return message;
        }
        return null;
    }

    static Throwable getThrowable(LogRecord record) {
        return record.getThrown();
    }

    private synchronized ResourceBundle getResourceBundle(String loggerName) {
        if (loggerName == null) {
            return null;
        }
        ResourceBundle bundle = this.loggerResourceBundleTable.get(loggerName);
        Logger logger = this.logManager.getLogger(loggerName);
        if (null == bundle && null != logger) {
            bundle = logger.getResourceBundle();
            this.loggerResourceBundleTable.put(loggerName, bundle);
        }
        return bundle;
    }

    public String getRecordDateFormat() {
        return this.recordDateFormat;
    }

    public void setRecordDateFormat(String recordDateFormat) {
        this.recordDateFormat = recordDateFormat;
    }

    LogEventBroadcaster getLogEventBroadcaster() {
        return this.logEventBroadcasterDelegate;
    }

    public void setLogEventBroadcaster(LogEventBroadcaster logEventBroadcaster) {
        this.logEventBroadcasterDelegate = logEventBroadcaster;
    }

    @Override
    public void informLogEventListeners(LogEvent logEvent) {
        if (this.logEventBroadcasterDelegate != null) {
            this.logEventBroadcasterDelegate.informLogEventListeners(logEvent);
        }
    }

    public void setExcludeFields(String excludeFields) {
        this.excludeFieldsSupport.setExcludeFields(excludeFields);
    }

    static {
        String recordCount;
        LOG_SOURCE_IN_KEY_VALUE = false;
        RECORD_NUMBER_IN_KEY_VALUE = false;
        String logSource = System.getProperty("com.sun.aas.logging.keyvalue.logsource");
        if (logSource != null && logSource.equals("true")) {
            LOG_SOURCE_IN_KEY_VALUE = true;
        }
        if ((recordCount = System.getProperty("com.sun.aas.logging.keyvalue.recordnumber")) != null && recordCount.equals("true")) {
            RECORD_NUMBER_IN_KEY_VALUE = true;
        }
        LINE_SEPARATOR = System.lineSeparator();
    }
}

