/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.node;

import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.LocaleEncodingMappingDescriptor;
import com.sun.enterprise.deployment.LocaleEncodingMappingListDescriptor;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.node.AbstractBundleNode;
import com.sun.enterprise.deployment.node.AdministeredObjectDefinitionNode;
import com.sun.enterprise.deployment.node.ConnectionFactoryDefinitionNode;
import com.sun.enterprise.deployment.node.DataSourceDefinitionNode;
import com.sun.enterprise.deployment.node.EjbLocalReferenceNode;
import com.sun.enterprise.deployment.node.EjbReferenceNode;
import com.sun.enterprise.deployment.node.EntityManagerFactoryReferenceNode;
import com.sun.enterprise.deployment.node.EntityManagerReferenceNode;
import com.sun.enterprise.deployment.node.EnvEntryNode;
import com.sun.enterprise.deployment.node.JMSConnectionFactoryDefinitionNode;
import com.sun.enterprise.deployment.node.JMSDestinationDefinitionNode;
import com.sun.enterprise.deployment.node.JndiEnvRefNode;
import com.sun.enterprise.deployment.node.LifecycleCallbackNode;
import com.sun.enterprise.deployment.node.MailSessionNode;
import com.sun.enterprise.deployment.node.MessageDestinationNode;
import com.sun.enterprise.deployment.node.MessageDestinationRefNode;
import com.sun.enterprise.deployment.node.ResourceEnvRefNode;
import com.sun.enterprise.deployment.node.ResourceRefNode;
import com.sun.enterprise.deployment.node.SecurityRoleNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.web.AppListenerDescriptor;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.deployment.web.MimeMapping;
import com.sun.enterprise.deployment.web.SecurityConstraint;
import com.sun.enterprise.deployment.web.ServletFilter;
import com.sun.enterprise.deployment.web.ServletFilterMapping;
import com.sun.enterprise.deployment.web.SessionConfig;
import java.lang.annotation.Annotation;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.web.deployment.descriptor.AppListenerDescriptorImpl;
import org.glassfish.web.deployment.descriptor.ErrorPageDescriptor;
import org.glassfish.web.deployment.descriptor.JspConfigDescriptorImpl;
import org.glassfish.web.deployment.descriptor.LoginConfigurationImpl;
import org.glassfish.web.deployment.descriptor.MimeMappingDescriptor;
import org.glassfish.web.deployment.descriptor.SecurityConstraintImpl;
import org.glassfish.web.deployment.descriptor.ServletFilterDescriptor;
import org.glassfish.web.deployment.descriptor.ServletFilterMappingDescriptor;
import org.glassfish.web.deployment.descriptor.SessionConfigDescriptor;
import org.glassfish.web.deployment.descriptor.TagLibConfigurationDescriptor;
import org.glassfish.web.deployment.descriptor.WebBundleDescriptorImpl;
import org.glassfish.web.deployment.descriptor.WebComponentDescriptorStub;
import org.glassfish.web.deployment.node.ErrorPageNode;
import org.glassfish.web.deployment.node.FilterMappingNode;
import org.glassfish.web.deployment.node.FilterNode;
import org.glassfish.web.deployment.node.InitParamNode;
import org.glassfish.web.deployment.node.JspConfigNode;
import org.glassfish.web.deployment.node.ListenerNode;
import org.glassfish.web.deployment.node.LocaleEncodingMappingNode;
import org.glassfish.web.deployment.node.LoginConfigNode;
import org.glassfish.web.deployment.node.MimeMappingNode;
import org.glassfish.web.deployment.node.SecurityConstraintNode;
import org.glassfish.web.deployment.node.ServletMappingNode;
import org.glassfish.web.deployment.node.ServletNode;
import org.glassfish.web.deployment.node.SessionConfigNode;
import org.glassfish.web.deployment.node.TagLibNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class WebCommonNode<T extends WebBundleDescriptorImpl>
extends AbstractBundleNode<T> {
    public static final String SPEC_VERSION = "4.0";
    protected T descriptor;
    private Map<String, Vector<String>> servletMappings;

    protected WebCommonNode() {
        this.registerElementHandler(new XMLElement("env-entry"), EnvEntryNode.class);
        this.registerElementHandler(new XMLElement("ejb-ref"), EjbReferenceNode.class);
        this.registerElementHandler(new XMLElement("ejb-local-ref"), EjbLocalReferenceNode.class);
        JndiEnvRefNode serviceRefNode = (JndiEnvRefNode)this.serviceLocator.getService(JndiEnvRefNode.class, "service-ref", new Annotation[0]);
        if (serviceRefNode != null) {
            this.registerElementHandler(new XMLElement("service-ref"), serviceRefNode.getClass(), "addServiceReferenceDescriptor");
        }
        this.registerElementHandler(new XMLElement("resource-ref"), ResourceRefNode.class, "addResourceReferenceDescriptor");
        this.registerElementHandler(new XMLElement("resource-env-ref"), ResourceEnvRefNode.class, "addResourceEnvReferenceDescriptor");
        this.registerElementHandler(new XMLElement("message-destination-ref"), MessageDestinationRefNode.class, "addMessageDestinationReferenceDescriptor");
        this.registerElementHandler(new XMLElement("persistence-context-ref"), EntityManagerReferenceNode.class, "addEntityManagerReferenceDescriptor");
        this.registerElementHandler(new XMLElement("persistence-unit-ref"), EntityManagerFactoryReferenceNode.class, "addEntityManagerFactoryReferenceDescriptor");
        this.registerElementHandler(new XMLElement("security-role"), SecurityRoleNode.class, "addRole");
        this.registerElementHandler(new XMLElement("servlet"), ServletNode.class);
        this.registerElementHandler(new XMLElement("servlet-mapping"), ServletMappingNode.class);
        this.registerElementHandler(new XMLElement("session-config"), SessionConfigNode.class);
        this.registerElementHandler(new XMLElement("mime-mapping"), MimeMappingNode.class, "addMimeMapping");
        this.registerElementHandler(new XMLElement("context-param"), InitParamNode.class, "addContextParameter");
        this.registerElementHandler(new XMLElement("security-constraint"), SecurityConstraintNode.class, "addSecurityConstraint");
        this.registerElementHandler(new XMLElement("filter"), FilterNode.class, "addServletFilter");
        this.registerElementHandler(new XMLElement("filter-mapping"), FilterMappingNode.class, "addServletFilterMapping");
        this.registerElementHandler(new XMLElement("listener"), ListenerNode.class, "addAppListenerDescriptor");
        this.registerElementHandler(new XMLElement("error-page"), ErrorPageNode.class, "addErrorPageDescriptor");
        this.registerElementHandler(new XMLElement("login-config"), LoginConfigNode.class);
        this.registerElementHandler(new XMLElement("taglib"), TagLibNode.class);
        this.registerElementHandler(new XMLElement("jsp-config"), JspConfigNode.class);
        this.registerElementHandler(new XMLElement("locale-encoding-mapping"), LocaleEncodingMappingNode.class, "addLocaleEncodingMappingDescriptor");
        this.registerElementHandler(new XMLElement("message-destination"), MessageDestinationNode.class, "addMessageDestination");
        this.registerElementHandler(new XMLElement("post-construct"), LifecycleCallbackNode.class, "addPostConstructDescriptor");
        this.registerElementHandler(new XMLElement("pre-destroy"), LifecycleCallbackNode.class, "addPreDestroyDescriptor");
        this.registerElementHandler(new XMLElement("data-source"), DataSourceDefinitionNode.class, "addResourceDescriptor");
        this.registerElementHandler(new XMLElement("connection-factory"), ConnectionFactoryDefinitionNode.class, "addResourceDescriptor");
        this.registerElementHandler(new XMLElement("jms-connection-factory"), JMSConnectionFactoryDefinitionNode.class, "addResourceDescriptor");
        this.registerElementHandler(new XMLElement("jms-destination"), JMSDestinationDefinitionNode.class, "addResourceDescriptor");
        this.registerElementHandler(new XMLElement("mail-session"), MailSessionNode.class, "addResourceDescriptor");
        this.registerElementHandler(new XMLElement("administered-object"), AdministeredObjectDefinitionNode.class, "addResourceDescriptor");
    }

    public void addDescriptor(Object newDescriptor) {
        Logger logger = DOLUtils.getDefaultLogger();
        if (newDescriptor instanceof EjbReference) {
            ((WebBundleDescriptorImpl)((Object)this.descriptor)).addEjbReferenceDescriptor((EjbReference)newDescriptor);
        } else if (newDescriptor instanceof EnvironmentProperty) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Adding env entry" + newDescriptor);
            }
            ((WebBundleDescriptorImpl)((Object)this.descriptor)).addEnvironmentProperty((EnvironmentProperty)newDescriptor);
        } else if (newDescriptor instanceof WebComponentDescriptor) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Adding web component" + newDescriptor);
            }
            ((WebBundleDescriptorImpl)((Object)this.descriptor)).addWebComponentDescriptor((WebComponentDescriptor)newDescriptor);
        } else if (newDescriptor instanceof TagLibConfigurationDescriptor) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Adding taglib component " + newDescriptor);
            }
            if (((WebBundleDescriptorImpl)((Object)this.descriptor)).getJspConfigDescriptor() == null) {
                ((WebBundleDescriptorImpl)((Object)this.descriptor)).setJspConfigDescriptor(new JspConfigDescriptorImpl());
            }
            ((WebBundleDescriptorImpl)((Object)this.descriptor)).getJspConfigDescriptor().addTagLib((TagLibConfigurationDescriptor)newDescriptor);
        } else if (newDescriptor instanceof JspConfigDescriptorImpl) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Adding JSP Config Descriptor" + newDescriptor);
            }
            if (((WebBundleDescriptorImpl)((Object)this.descriptor)).getJspConfigDescriptor() != null) {
                throw new RuntimeException("Has more than one jsp-config element!");
            }
            ((WebBundleDescriptorImpl)((Object)this.descriptor)).setJspConfigDescriptor((JspConfigDescriptorImpl)newDescriptor);
        } else if (newDescriptor instanceof LoginConfiguration) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Adding Login Config Descriptor" + newDescriptor);
            }
            if (((WebBundleDescriptorImpl)((Object)this.descriptor)).getLoginConfiguration() != null) {
                throw new RuntimeException("Has more than one login-config element!");
            }
            ((WebBundleDescriptorImpl)((Object)this.descriptor)).setLoginConfiguration((LoginConfiguration)newDescriptor);
        } else if (newDescriptor instanceof SessionConfig) {
            if (((WebBundleDescriptorImpl)((Object)this.descriptor)).getSessionConfig() != null) {
                throw new RuntimeException("Has more than one session-config element!");
            }
            ((WebBundleDescriptorImpl)((Object)this.descriptor)).setSessionConfig((SessionConfig)newDescriptor);
        } else {
            super.addDescriptor(newDescriptor);
        }
    }

    public void setElementValue(XMLElement element, String value) {
        if ("welcome-file".equals(element.getQName())) {
            ((WebBundleDescriptorImpl)((Object)this.descriptor)).addWelcomeFile(value);
        } else {
            super.setElementValue(element, value);
        }
    }

    void addServletMapping(String servletName, String urlPattern) {
        if (this.servletMappings == null) {
            this.servletMappings = new HashMap<String, Vector<String>>();
        }
        if (this.servletMappings.containsKey(servletName)) {
            this.servletMappings.get(servletName).add(urlPattern);
        } else {
            Vector<String> mappings = new Vector<String>();
            mappings.add(urlPattern);
            this.servletMappings.put(servletName, mappings);
        }
    }

    public boolean endElement(XMLElement element) {
        if ("distributable".equals(element.getQName())) {
            ((WebBundleDescriptorImpl)((Object)this.descriptor)).setDistributable(true);
            return false;
        }
        boolean allDone = super.endElement(element);
        if (allDone && this.servletMappings != null) {
            for (String servletName : this.servletMappings.keySet()) {
                Vector<String> mappings = this.servletMappings.get(servletName);
                WebComponentDescriptor servlet = ((WebBundleDescriptorImpl)((Object)this.descriptor)).getWebComponentByCanonicalName(servletName);
                if (servlet == null) {
                    servlet = new WebComponentDescriptorStub(servletName);
                    ((WebBundleDescriptorImpl)((Object)this.descriptor)).getWebComponentDescriptors().add(servlet);
                }
                Iterator<String> mapping = mappings.iterator();
                while (mapping.hasNext()) {
                    servlet.addUrlPattern(mapping.next());
                }
            }
        }
        return allDone;
    }

    public Node writeDescriptor(Node parent, T webBundleDesc) {
        Enumeration<SecurityRoleDescriptor> roles;
        LoginConfigurationImpl lci;
        Enumeration<SecurityConstraint> securityConstraints;
        JspConfigDescriptorImpl jspConf;
        Enumeration<ErrorPageDescriptor> errorPages;
        Set<WebComponentDescriptor> servlets;
        Node jarNode = super.writeDescriptor(parent, webBundleDesc);
        if (((WebBundleDescriptorImpl)((Object)webBundleDesc)).isDistributable()) {
            WebCommonNode.appendChild((Node)jarNode, (String)"distributable");
        }
        WebCommonNode.addInitParam(jarNode, "context-param", ((WebBundleDescriptorImpl)((Object)webBundleDesc)).getContextParametersSet());
        FilterNode filterNode = new FilterNode();
        Enumeration<ServletFilter> filters = ((WebBundleDescriptorImpl)((Object)webBundleDesc)).getServletFilters().elements();
        while (filters.hasMoreElements()) {
            filterNode.writeDescriptor(jarNode, "filter", (ServletFilterDescriptor)filters.nextElement());
        }
        FilterMappingNode filterMappingNode = new FilterMappingNode();
        Enumeration<ServletFilterMapping> mappings = ((WebBundleDescriptorImpl)((Object)webBundleDesc)).getServletFilterMappings().elements();
        while (mappings.hasMoreElements()) {
            filterMappingNode.writeDescriptor(jarNode, "filter-mapping", (ServletFilterMappingDescriptor)mappings.nextElement());
        }
        Vector<AppListenerDescriptor> appListeners = ((WebBundleDescriptorImpl)((Object)webBundleDesc)).getAppListenerDescriptors();
        if (!appListeners.isEmpty()) {
            ListenerNode listenerNode = new ListenerNode();
            Enumeration<AppListenerDescriptor> e = appListeners.elements();
            while (e.hasMoreElements()) {
                listenerNode.writeDescriptor(jarNode, "listener", (AppListenerDescriptorImpl)e.nextElement());
            }
        }
        if (!(servlets = ((WebBundleDescriptorImpl)((Object)webBundleDesc)).getWebComponentDescriptors()).isEmpty()) {
            ServletNode servletNode = new ServletNode();
            for (WebComponentDescriptor aServlet : servlets) {
                servletNode.writeDescriptor(jarNode, aServlet);
            }
            for (WebComponentDescriptor aServlet : servlets) {
                for (String pattern : aServlet.getUrlPatternsSet()) {
                    Element mappingNode = WebCommonNode.appendChild((Node)jarNode, (String)"servlet-mapping");
                    WebCommonNode.appendTextChild((Node)mappingNode, (String)"servlet-name", (String)aServlet.getCanonicalName());
                    if (webBundleDesc.getSpecVersion().equals("2.2") && !pattern.startsWith("/") && !pattern.startsWith("*.")) {
                        pattern = "/" + pattern;
                    }
                    WebCommonNode.appendTextChild((Node)mappingNode, (String)"url-pattern", (String)pattern);
                }
            }
        }
        MimeMappingNode mimeNode = new MimeMappingNode();
        Enumeration<MimeMapping> e = ((WebBundleDescriptorImpl)((Object)webBundleDesc)).getMimeMappings();
        while (e.hasMoreElements()) {
            MimeMappingDescriptor mimeMapping = (MimeMappingDescriptor)e.nextElement();
            mimeNode.writeDescriptor(jarNode, "mime-mapping", mimeMapping);
        }
        Enumeration<String> welcomeFiles = ((WebBundleDescriptorImpl)((Object)webBundleDesc)).getWelcomeFiles();
        if (welcomeFiles.hasMoreElements()) {
            Element welcomeList = WebCommonNode.appendChild((Node)jarNode, (String)"welcome-file-list");
            while (welcomeFiles.hasMoreElements()) {
                WebCommonNode.appendTextChild((Node)welcomeList, (String)"welcome-file", (String)welcomeFiles.nextElement());
            }
        }
        if ((errorPages = ((WebBundleDescriptorImpl)((Object)webBundleDesc)).getErrorPageDescriptors()).hasMoreElements()) {
            ErrorPageNode errorPageNode = new ErrorPageNode();
            while (errorPages.hasMoreElements()) {
                errorPageNode.writeDescriptor(jarNode, "error-page", errorPages.nextElement());
            }
        }
        if ((jspConf = ((WebBundleDescriptorImpl)((Object)webBundleDesc)).getJspConfigDescriptor()) != null) {
            JspConfigNode ln = new JspConfigNode();
            ln.writeDescriptor(jarNode, "jsp-config", jspConf);
        }
        if ((securityConstraints = ((WebBundleDescriptorImpl)((Object)webBundleDesc)).getSecurityConstraints()).hasMoreElements()) {
            SecurityConstraintNode scNode = new SecurityConstraintNode();
            while (securityConstraints.hasMoreElements()) {
                SecurityConstraintImpl sc = (SecurityConstraintImpl)securityConstraints.nextElement();
                scNode.writeDescriptor(jarNode, "security-constraint", sc);
            }
        }
        if ((lci = (LoginConfigurationImpl)((WebBundleDescriptorImpl)((Object)webBundleDesc)).getLoginConfiguration()) != null) {
            LoginConfigNode lcn = new LoginConfigNode();
            lcn.writeDescriptor(jarNode, "login-config", lci);
        }
        if ((roles = ((WebBundleDescriptorImpl)((Object)webBundleDesc)).getSecurityRoles()).hasMoreElements()) {
            SecurityRoleNode srNode = new SecurityRoleNode();
            while (roles.hasMoreElements()) {
                SecurityRoleDescriptor role = roles.nextElement();
                srNode.writeDescriptor(jarNode, "security-role", role);
            }
        }
        this.writeEnvEntryDescriptors(jarNode, ((WebBundleDescriptorImpl)((Object)webBundleDesc)).getEnvironmentProperties().iterator());
        this.writeEjbReferenceDescriptors(jarNode, ((WebBundleDescriptorImpl)((Object)webBundleDesc)).getEjbReferenceDescriptors().iterator());
        this.writeServiceReferenceDescriptors(jarNode, ((WebBundleDescriptorImpl)((Object)webBundleDesc)).getServiceReferenceDescriptors().iterator());
        this.writeResourceRefDescriptors(jarNode, ((WebBundleDescriptorImpl)((Object)webBundleDesc)).getResourceReferenceDescriptors().iterator());
        this.writeResourceEnvRefDescriptors(jarNode, ((WebBundleDescriptorImpl)((Object)webBundleDesc)).getResourceEnvReferenceDescriptors().iterator());
        this.writeMessageDestinationRefDescriptors(jarNode, ((WebBundleDescriptorImpl)((Object)webBundleDesc)).getMessageDestinationReferenceDescriptors().iterator());
        this.writeEntityManagerReferenceDescriptors(jarNode, ((WebBundleDescriptorImpl)((Object)webBundleDesc)).getEntityManagerReferenceDescriptors().iterator());
        this.writeEntityManagerFactoryReferenceDescriptors(jarNode, ((WebBundleDescriptorImpl)((Object)webBundleDesc)).getEntityManagerFactoryReferenceDescriptors().iterator());
        this.writeLifeCycleCallbackDescriptors(jarNode, "post-construct", ((WebBundleDescriptorImpl)((Object)webBundleDesc)).getPostConstructDescriptors());
        this.writeLifeCycleCallbackDescriptors(jarNode, "pre-destroy", ((WebBundleDescriptorImpl)((Object)webBundleDesc)).getPreDestroyDescriptors());
        this.writeResourceDescriptors(jarNode, webBundleDesc.getAllResourcesDescriptors().iterator());
        this.writeMessageDestinations(jarNode, webBundleDesc.getMessageDestinations().iterator());
        LocaleEncodingMappingListDescriptor lemListDesc = ((WebBundleDescriptorImpl)((Object)webBundleDesc)).getLocaleEncodingMappingListDescriptor();
        if (lemListDesc != null) {
            Element lemList = WebCommonNode.appendChild((Node)jarNode, (String)"locale-encoding-mapping-list");
            LocaleEncodingMappingNode lemNode = new LocaleEncodingMappingNode();
            for (LocaleEncodingMappingDescriptor lemDesc : lemListDesc.getLocaleEncodingMappingSet()) {
                lemNode.writeDescriptor((Node)lemList, "locale-encoding-mapping", lemDesc);
            }
        }
        if (((WebBundleDescriptorImpl)((Object)webBundleDesc)).getSessionConfig() != null) {
            SessionConfigNode scNode = new SessionConfigNode();
            scNode.writeDescriptor(jarNode, "session-config", (SessionConfigDescriptor)((WebBundleDescriptorImpl)((Object)webBundleDesc)).getSessionConfig());
        }
        return jarNode;
    }

    static void addInitParam(Node parentNode, String nodeName, Set initParams) {
        if (!initParams.isEmpty()) {
            InitParamNode initParamNode = new InitParamNode();
            for (EnvironmentProperty ep : initParams) {
                initParamNode.writeDescriptor(parentNode, nodeName, ep);
            }
        }
    }

    static void addInitParam(Node parentNode, String nodeName, Enumeration initParams) {
        InitParamNode initParamNode = new InitParamNode();
        while (initParams.hasMoreElements()) {
            EnvironmentProperty ep = (EnvironmentProperty)initParams.nextElement();
            initParamNode.writeDescriptor(parentNode, nodeName, ep);
        }
    }

    public String getSpecVersion() {
        return SPEC_VERSION;
    }
}

