/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.cdi.jsr107;

import fish.payara.cdi.jsr107.AbstractJSR107Interceptor;
import fish.payara.cdi.jsr107.implementation.PayaraCacheKeyInvocationContext;
import javax.annotation.Priority;
import javax.cache.Cache;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CacheRemove;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.CacheResolverFactory;
import javax.cache.annotation.GeneratedCacheKey;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

@CacheRemove
@Interceptor
@Priority(value=4000)
public class CacheRemoveInterceptor
extends AbstractJSR107Interceptor {
    @AroundInvoke
    public Object cacheRemove(InvocationContext ctx) throws Throwable {
        if (!this.isEnabled()) {
            return ctx.proceed();
        }
        CacheRemove annotation = ctx.getMethod().getAnnotation(CacheRemove.class);
        PayaraCacheKeyInvocationContext<CacheRemove> pctx = new PayaraCacheKeyInvocationContext<CacheRemove>(ctx, annotation);
        if (!annotation.afterInvocation()) {
            this.doRemove(pctx);
        }
        Object result = null;
        try {
            result = ctx.proceed();
        }
        catch (Throwable e) {
            if (annotation.afterInvocation() && this.shouldIEvict(annotation.evictFor(), annotation.noEvictFor(), e)) {
                this.doRemove(pctx);
            }
            throw e;
        }
        if (annotation.afterInvocation()) {
            this.doRemove(pctx);
        }
        return result;
    }

    private void doRemove(PayaraCacheKeyInvocationContext<CacheRemove> pctx) {
        CacheKeyGenerator generator = pctx.getGenerator();
        CacheResolverFactory resolverF = pctx.getFactory();
        CacheResolver cacheResolver = resolverF.getCacheResolver(pctx);
        Cache cache = cacheResolver.resolveCache(pctx);
        GeneratedCacheKey key = generator.generateCacheKey(pctx);
        cache.remove((Object)key);
    }
}

