/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics;

import org.eclipse.microprofile.metrics.Metadata;

public final class MetricUnitsUtils {
    private MetricUnitsUtils() {
        throw new UnsupportedOperationException("util");
    }

    public static String baseUnit(String unit) {
        switch (unit) {
            case "bits": 
            case "kilobits": 
            case "megabits": 
            case "gigabits": 
            case "kibibits": 
            case "mebibits": 
            case "gibibits": 
            case "bytes": 
            case "kilobytes": 
            case "megabytes": 
            case "gigabytes": {
                return "bytes";
            }
            case "nanoseconds": 
            case "microseconds": 
            case "milliseconds": 
            case "seconds": 
            case "minutes": 
            case "hours": 
            case "days": {
                return "seconds";
            }
        }
        return unit;
    }

    public static Number scaleToBaseUnit(Number value, Metadata metadata) {
        if (!metadata.getUnit().isPresent()) {
            return value;
        }
        String unit = metadata.getUnit().get();
        return MetricUnitsUtils.scaleToBaseUnit(value, unit);
    }

    public static Number scaleToBaseUnit(Number value, String unit) {
        if (unit == null || unit.isEmpty() || unit.equals("none")) {
            return value;
        }
        switch (unit) {
            case "bits": {
                return (double)value.longValue() / 8.0;
            }
            case "kilobits": {
                return value.doubleValue() * 1000.0 / 8.0;
            }
            case "megabits": {
                return value.doubleValue() * 1000.0 * 1000.0 / 8.0;
            }
            case "gigabits": {
                return value.doubleValue() * 1000.0 * 1000.0 * 1000.0 / 8.0;
            }
            case "kibibits": {
                return value.doubleValue() * 1024.0 / 8.0;
            }
            case "mebibits": {
                return value.doubleValue() * 1024.0 * 1024.0 / 8.0;
            }
            case "gibibits": {
                return value.doubleValue() * 1024.0 * 1024.0 * 1024.0 / 8.0;
            }
            case "bytes": {
                return value;
            }
            case "kilobytes": {
                return value.doubleValue() * 1000.0;
            }
            case "megabytes": {
                return value.doubleValue() * 1000.0 * 1000.0;
            }
            case "gigabytes": {
                return value.doubleValue() * 1000.0 * 1000.0 * 1000.0;
            }
            case "nanoseconds": {
                return (double)value.longValue() / 1000.0 / 1000.0 / 1000.0;
            }
            case "microseconds": {
                return (double)value.longValue() / 1000.0 / 1000.0;
            }
            case "milliseconds": {
                return (double)value.longValue() / 1000.0;
            }
            case "seconds": {
                return value;
            }
            case "minutes": {
                return value.doubleValue() * 60.0;
            }
            case "hours": {
                return value.doubleValue() * 60.0 * 60.0;
            }
            case "days": {
                return value.doubleValue() * 60.0 * 60.0 * 24.0;
            }
        }
        return value;
    }
}

