/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.rest;

import fish.payara.microprofile.metrics.MetricsService;
import fish.payara.microprofile.metrics.exception.NoSuchMetricException;
import fish.payara.microprofile.metrics.exception.NoSuchRegistryException;
import fish.payara.microprofile.metrics.writer.JsonExporter;
import fish.payara.microprofile.metrics.writer.MetricsWriter;
import fish.payara.microprofile.metrics.writer.MetricsWriterImpl;
import fish.payara.microprofile.metrics.writer.OpenMetricsExporter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.glassfish.internal.api.Globals;

public class MetricsResource
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger(MetricsResource.class.getName());
    private static final String APPLICATION_WILDCARD = "application/*";
    private static final Pattern PATTERN_Q_PART = Pattern.compile("\\s*q\\s*=\\s*(.+)");

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block9: {
            MetricsService metricsService = (MetricsService)Globals.getDefaultBaseServiceLocator().getService(MetricsService.class, new Annotation[0]);
            if (!metricsService.isEnabled().booleanValue()) {
                response.sendError(403, "MicroProfile Metrics Service is disabled");
                return;
            }
            metricsService.reregisterMetadataConfig();
            String pathInfo = request.getPathInfo() != null ? request.getPathInfo().substring(1) : "";
            String[] pathInfos = pathInfo.split("/");
            String registryName = pathInfos.length > 0 ? pathInfos[0] : null;
            String metricName = pathInfos.length > 1 ? pathInfos[1] : null;
            try {
                String contentType = MetricsResource.getContentType(request, response);
                if (contentType == null) break block9;
                response.setContentType(contentType);
                response.setCharacterEncoding(StandardCharsets.UTF_8.name());
                MetricsWriter outputWriter = MetricsResource.getOutputWriter(request, response, metricsService, contentType);
                if (outputWriter == null) break block9;
                if (registryName != null && !registryName.isEmpty()) {
                    MetricRegistry.Type scope;
                    try {
                        scope = MetricRegistry.Type.valueOf(registryName.toUpperCase());
                    }
                    catch (RuntimeException ex) {
                        throw new NoSuchRegistryException(registryName);
                    }
                    if (metricName != null && !metricName.isEmpty()) {
                        outputWriter.write(scope, metricName);
                    } else {
                        outputWriter.write(scope);
                    }
                    break block9;
                }
                outputWriter.write();
            }
            catch (NoSuchRegistryException ex) {
                response.sendError(404, String.format("[%s] registry not found", registryName));
            }
            catch (NoSuchMetricException ex) {
                response.sendError(404, String.format("[%s] metric not found", metricName));
            }
        }
    }

    private static MetricsWriter getOutputWriter(HttpServletRequest request, HttpServletResponse response, MetricsService service, String contentType) throws IOException {
        PrintWriter writer = response.getWriter();
        String method = request.getMethod();
        if ("GET".equalsIgnoreCase(method)) {
            if ("application/json".equals(contentType)) {
                return new MetricsWriterImpl(new JsonExporter(writer, JsonExporter.Mode.GET, true), service::getAllRegistryNames, service::getRegistry);
            }
            if ("text/plain".equals(contentType)) {
                return new MetricsWriterImpl(new OpenMetricsExporter(writer), service::getAllRegistryNames, service::getRegistry);
            }
        }
        if ("OPTIONS".equalsIgnoreCase(method) && "application/json".equals(contentType)) {
            return new MetricsWriterImpl(new JsonExporter(writer, JsonExporter.Mode.OPTIONS, true), service::getAllRegistryNames, service::getRegistry);
        }
        return null;
    }

    private static String getContentType(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String method = request.getMethod();
        String accept = request.getHeader("Accept");
        if (accept == null) {
            accept = "text/plain";
        }
        switch (method) {
            case "GET": {
                Optional<String> selectedFormat = MetricsResource.parseMetricsAcceptHeader(accept);
                if (selectedFormat.isPresent()) {
                    return selectedFormat.get();
                }
                response.sendError(406, String.format("[%s] not acceptable", accept));
                return null;
            }
            case "OPTIONS": {
                if (accept.contains("application/json") || accept.contains(APPLICATION_WILDCARD)) {
                    return "application/json";
                }
                response.sendError(406, String.format("[%s] not acceptable", accept));
                return null;
            }
        }
        response.sendError(405, String.format("HTTP method [%s] not allowed", method));
        return null;
    }

    static Optional<String> parseMetricsAcceptHeader(String accept) {
        String[] acceptFormats = accept.split(",");
        double qJsonValue = 0.0;
        double qTextFormat = 0.0;
        for (String format : acceptFormats) {
            if (format.contains("text/plain") || format.contains("*/*") || format.contains("text/*")) {
                qTextFormat = MetricsResource.parseQValue(format);
                continue;
            }
            if (!format.contains("application/json") && !format.contains(APPLICATION_WILDCARD)) continue;
            qJsonValue = MetricsResource.parseQValue(format);
        }
        if (qJsonValue == 0.0 && qTextFormat == 0.0) {
            return Optional.empty();
        }
        if (qJsonValue > qTextFormat) {
            return Optional.of("application/json");
        }
        return Optional.of("text/plain");
    }

    private static double parseQValue(String format) {
        return Stream.of(format.split(";")).skip(1L).map(PATTERN_Q_PART::matcher).filter(Matcher::find).mapToDouble(m -> MetricsResource.toDouble(m.group(1))).findFirst().orElse(1.0);
    }

    private static double toDouble(String text) {
        try {
            if (text.startsWith(".")) {
                return Double.parseDouble("0" + text);
            }
            return Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            LOG.warning(() -> "Invalid q value in Accept header: " + text);
            return 0.0;
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }
}

