/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.writer;

import fish.payara.microprofile.metrics.writer.MetricExporter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metered;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Sampling;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Snapshot;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

public class JsonExporter
implements MetricExporter {
    private final MetricRegistry.Type scope;
    private final JsonWriter out;
    private final Mode mode;
    private final JsonObjectBuilder documentObj;
    private final JsonObjectBuilder scopeObj;
    private JsonObjectBuilder groupObj;
    private JsonArrayBuilder tagsArray;
    private MetricID exportedBefore;
    private Metadata exportedBeforeMetadata;

    public JsonExporter(Writer out, Mode mode, boolean prettyPrint) {
        this(null, JsonExporter.writer(out, prettyPrint), mode, Json.createObjectBuilder(), null);
    }

    private static JsonWriter writer(Writer out, boolean prettyPrint) {
        return Json.createWriterFactory(Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", prettyPrint)).createWriter(out);
    }

    private JsonExporter(MetricRegistry.Type scope, JsonWriter out, Mode mode, JsonObjectBuilder documentObj, JsonObjectBuilder scopeObj) {
        this.scope = scope;
        this.out = out;
        this.mode = mode;
        this.documentObj = documentObj;
        this.scopeObj = scopeObj;
    }

    @Override
    public MetricExporter in(MetricRegistry.Type scope, boolean asNode) {
        this.completeScope();
        return new JsonExporter(scope, this.out, this.mode, this.documentObj, (JsonObjectBuilder)(asNode ? Json.createObjectBuilder() : null));
    }

    @Override
    public void export(MetricID metricID, Counter counter, Metadata metadata) {
        this.completeGroup(metricID, metadata);
        this.appendMember(metricID, counter.getCount());
    }

    @Override
    public void export(MetricID metricID, ConcurrentGauge gauge, Metadata metadata) {
        this.completeOrUpdateGroup(metricID, metadata);
        this.appendMember(metricID, "current", gauge.getCount());
        this.appendMember(metricID, "min", gauge.getMin());
        this.appendMember(metricID, "max", gauge.getMax());
    }

    @Override
    public void export(MetricID metricID, Gauge<?> gauge, Metadata metadata) {
        this.completeGroup(metricID, metadata);
        if (this.mode == Mode.OPTIONS) {
            return;
        }
        Object value = null;
        try {
            value = gauge.getValue();
        }
        catch (IllegalStateException ex) {
            return;
        }
        if (!(value instanceof Number)) {
            LOGGER.log(Level.FINER, "Skipping OpenMetrics output for Gauge: {0} of type {1}", new Object[]{metricID, value.getClass()});
            return;
        }
        this.appendMember(metricID, (Number)value);
    }

    @Override
    public void export(MetricID metricID, Histogram histogram, Metadata metadata) {
        this.completeOrUpdateGroup(metricID, metadata);
        this.appendMember(metricID, "count", histogram.getCount());
        this.exportSampling(metricID, histogram);
    }

    private void exportSampling(MetricID metricID, Sampling sampling) {
        Snapshot snapshot = sampling.getSnapshot();
        this.appendMember(metricID, "min", snapshot.getMin());
        this.appendMember(metricID, "max", snapshot.getMax());
        this.appendMember(metricID, "mean", snapshot.getMean());
        this.appendMember(metricID, "stddev", snapshot.getStdDev());
        this.appendMember(metricID, "p50", snapshot.getMedian());
        this.appendMember(metricID, "p75", snapshot.get75thPercentile());
        this.appendMember(metricID, "p95", snapshot.get95thPercentile());
        this.appendMember(metricID, "p98", snapshot.get98thPercentile());
        this.appendMember(metricID, "p99", snapshot.get99thPercentile());
        this.appendMember(metricID, "p999", snapshot.get999thPercentile());
    }

    @Override
    public void export(MetricID metricID, Meter meter, Metadata metadata) {
        this.completeOrUpdateGroup(metricID, metadata);
        this.exportMetered(metricID, meter);
    }

    private void exportMetered(MetricID metricID, Metered metered) {
        this.appendMember(metricID, "count", metered.getCount());
        this.appendMember(metricID, "meanRate", metered.getMeanRate());
        this.appendMember(metricID, "oneMinRate", metered.getOneMinuteRate());
        this.appendMember(metricID, "fiveMinRate", metered.getFiveMinuteRate());
        this.appendMember(metricID, "fifteenMinRate", metered.getFifteenMinuteRate());
    }

    @Override
    public void export(MetricID metricID, SimpleTimer timer, Metadata metadata) {
        this.completeOrUpdateGroup(metricID, metadata);
        this.appendMember(metricID, "count", timer.getCount());
        this.appendMember(metricID, "elapsedTime", timer.getElapsedTime().toMillis());
    }

    @Override
    public void export(MetricID metricID, Timer timer, Metadata metadata) {
        this.completeOrUpdateGroup(metricID, metadata);
        this.exportMetered(metricID, timer);
        this.exportSampling(metricID, timer);
    }

    @Override
    public void exportComplete() {
        this.completeGroup(null, null);
        this.completeScope();
        this.out.write((JsonStructure)this.documentObj.build());
    }

    private void exportMetadata() {
        String desc;
        if (this.exportedBefore == null) {
            return;
        }
        JsonObjectBuilder target = this.scopeObj != null ? this.scopeObj : this.documentObj;
        JsonObjectBuilder metadataObj = Json.createObjectBuilder();
        Metadata metadata = this.exportedBeforeMetadata;
        metadataObj.add("unit", metadata.getUnit().orElse("none"));
        metadataObj.add("type", metadata.getTypeRaw().toString());
        if (metadata.getDescription().isPresent() && !(desc = metadata.getDescription().get()).isEmpty()) {
            metadataObj.add("description", desc);
        }
        String displayName = metadata.getDisplayName();
        String name = this.exportedBefore.getName();
        if (!displayName.isEmpty() && !displayName.equals(name)) {
            metadataObj.add("displayName", displayName);
        }
        if (this.tagsArray != null) {
            metadataObj.add("tags", (JsonValue)this.tagsArray.build());
            this.tagsArray = null;
        }
        target.add(name, (JsonValue)metadataObj.build());
    }

    private void completeScope() {
        this.completeGroup(null, null);
        if (this.scopeObj != null) {
            this.documentObj.add(this.scope.getName(), (JsonValue)this.scopeObj.build());
        }
    }

    private void completeGroup(MetricID current, Metadata metadata) {
        if (this.mode == Mode.GET && this.groupObj != null) {
            JsonObjectBuilder target = this.scopeObj != null ? this.scopeObj : this.documentObj;
            target.add(this.exportedBefore.getName(), this.groupObj);
            this.groupObj = null;
        }
        if (this.mode == Mode.OPTIONS) {
            List<Tag> tags;
            if (this.isNameChange(current)) {
                this.exportMetadata();
            }
            if (!(tags = JsonExporter.tagsAlphabeticallySorted(current)).isEmpty()) {
                JsonArrayBuilder currentTags = Json.createArrayBuilder();
                for (Tag tag : tags) {
                    currentTags.add(JsonExporter.tagAsString(tag));
                }
                if (this.tagsArray == null) {
                    this.tagsArray = Json.createArrayBuilder();
                }
                this.tagsArray.add((JsonValue)currentTags.build());
            }
        }
        this.exportedBefore = current;
        this.exportedBeforeMetadata = metadata;
    }

    private void completeOrUpdateGroup(MetricID current, Metadata metadata) {
        if (this.mode == Mode.OPTIONS || this.isNameChange(current)) {
            this.completeGroup(current, metadata);
        }
        if (this.mode == Mode.GET && this.groupObj == null) {
            this.groupObj = Json.createObjectBuilder();
        }
    }

    private boolean isNameChange(MetricID current) {
        return current == null || this.exportedBefore == null || !this.exportedBefore.getName().equals(current.getName());
    }

    private void appendMember(MetricID metricID, Number value) {
        this.appendMember(metricID, null, value);
    }

    private void appendMember(MetricID metricID, String field, Number value) {
        if (this.mode == Mode.OPTIONS) {
            return;
        }
        JsonObjectBuilder target = this.groupObj != null ? this.groupObj : (this.scopeObj != null ? this.scopeObj : this.documentObj);
        String name = field != null ? field : metricID.getName();
        List<Tag> tags = JsonExporter.tagsAlphabeticallySorted(metricID);
        if (!tags.isEmpty()) {
            for (Tag tag : tags) {
                name = name + ';' + JsonExporter.tagAsString(tag);
            }
        }
        if (value instanceof Float || value instanceof Double) {
            target.add(name, value.doubleValue());
        } else if (value instanceof BigDecimal) {
            target.add(name, (BigDecimal)value);
        } else if (value instanceof BigInteger) {
            target.add(name, (BigInteger)value);
        } else {
            target.add(name, value.longValue());
        }
    }

    private static String tagAsString(Tag tag) {
        return tag.getTagName() + '=' + tag.getTagValue().replace(';', '_');
    }

    private static List<Tag> tagsAlphabeticallySorted(MetricID metricID) {
        if (metricID == null) {
            return Collections.emptyList();
        }
        Tag[] tags = metricID.getTagsAsArray();
        if (tags.length == 0) {
            return Collections.emptyList();
        }
        Arrays.sort(tags, (a, b) -> a.getTagName().compareTo(b.getTagName()));
        return Arrays.asList(tags);
    }

    public static enum Mode {
        GET,
        OPTIONS;

    }
}

