/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.cluster.windows.io;

import com.sun.enterprise.util.cluster.windows.SharedStrings;
import com.sun.enterprise.util.cluster.windows.process.WindowsCredentials;
import com.sun.enterprise.util.cluster.windows.process.WindowsException;
import java.net.InetAddress;
import jcifs.smb.NtlmPasswordAuthentication;

public class WindowsRemoteFileSystem {
    private final String host;
    private final NtlmPasswordAuthentication authorization;

    public WindowsRemoteFileSystem(WindowsCredentials cr) throws WindowsException {
        String hostName = cr.getHost();
        String domain = cr.getDomain();
        boolean useDomain = !domain.equals(hostName);
        this.host = this.getIP(hostName);
        try {
            this.authorization = useDomain ? new NtlmPasswordAuthentication(domain, cr.getUser(), cr.getPassword()) : new NtlmPasswordAuthentication(this.host, cr.getUser(), cr.getPassword());
        }
        catch (NoClassDefFoundError err) {
            throw new WindowsException(SharedStrings.get("missing_jinterop"));
        }
    }

    public WindowsRemoteFileSystem(String hostname, NtlmPasswordAuthentication auth) throws WindowsException {
        this.host = this.getIP(hostname);
        this.authorization = auth;
        if (auth == null) {
            throw new WindowsException(SharedStrings.get("missing_jinterop"));
        }
    }

    public WindowsRemoteFileSystem(String hostname, String username, String password) throws WindowsException {
        this.host = this.getIP(hostname);
        try {
            this.authorization = new NtlmPasswordAuthentication(this.host, username, password);
        }
        catch (NoClassDefFoundError err) {
            throw new WindowsException(SharedStrings.get("missing_jinterop"));
        }
    }

    public String getHost() {
        return this.host;
    }

    public NtlmPasswordAuthentication getAuthorization() {
        return this.authorization;
    }

    private String getIP(String hostname) {
        try {
            return InetAddress.getByName(hostname).getHostAddress();
        }
        catch (Exception e) {
            return hostname;
        }
    }
}

