/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.admin.rest.streams;

import fish.payara.admin.rest.streams.StreamWriter;
import java.io.IOException;
import java.io.OutputStream;
import javax.json.Json;
import javax.json.stream.JsonGenerationException;
import javax.json.stream.JsonGenerator;

public class JsonStreamWriter
implements StreamWriter {
    private final String prefix;
    private final String postfix;
    private final OutputStream os;
    private final JsonGenerator writer;
    private boolean inArray;

    public JsonStreamWriter(OutputStream os, String prefix, String postfix) {
        this.prefix = prefix;
        this.postfix = postfix;
        this.os = os;
        this.writer = Json.createGenerator((OutputStream)os);
    }

    public JsonStreamWriter(OutputStream os) {
        this(os, null, null);
    }

    @Override
    public String getPostfix() {
        return this.postfix;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void writeStartDocument() throws JsonGenerationException, IOException {
        if (this.prefix != null) {
            this.os.write(this.prefix.getBytes("UTF-8"));
        }
        this.writer.writeStartObject();
        this.inArray = false;
    }

    @Override
    public void writeEndDocument() throws JsonGenerationException, IOException {
        this.writer.writeEnd();
        if (this.postfix != null) {
            this.os.write(this.postfix.getBytes("UTF-8"));
        }
    }

    @Override
    public void writeStartObject(String element) throws JsonGenerationException {
        if (this.inArray) {
            this.writer.writeStartObject();
        } else {
            this.writer.writeStartObject(element);
        }
    }

    @Override
    public void writeEndObject() throws JsonGenerationException {
        this.writer.writeEnd();
    }

    @Override
    public void writeAttribute(String name, String value) throws JsonGenerationException {
        this.writer.write(name, value);
    }

    @Override
    public void writeAttribute(String name, Boolean value) throws JsonGenerationException {
        this.writer.write(name, value.booleanValue());
    }

    @Override
    public void close() throws JsonGenerationException {
        this.writer.close();
    }

    @Override
    public void writeStartArray(String element) throws Exception {
        this.writer.writeStartArray(element);
        this.inArray = true;
    }

    @Override
    public void writeEndArray() throws Exception {
        this.writer.writeEnd();
        this.inArray = false;
    }
}

