/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck;

import fish.payara.nucleus.healthcheck.HealthCheckExecutionOptions;
import fish.payara.nucleus.healthcheck.HealthCheckResult;
import fish.payara.nucleus.healthcheck.preliminary.BaseHealthCheck;
import java.util.logging.Level;

public class HealthCheckTask
implements Runnable {
    private final String name;
    private final BaseHealthCheck check;

    HealthCheckTask(String name, BaseHealthCheck check) {
        this.name = name;
        this.check = check;
    }

    public String getName() {
        return this.name;
    }

    public BaseHealthCheck getCheck() {
        return this.check;
    }

    @Override
    public void run() {
        HealthCheckResult checkResult;
        if (((HealthCheckExecutionOptions)this.check.getOptions()).isEnabled() && (checkResult = this.check.doCheck()) != null && checkResult.getCumulativeStatus() != null) {
            Level level;
            switch (checkResult.getCumulativeStatus()) {
                case CHECK_ERROR: {
                    level = Level.SEVERE;
                    break;
                }
                case CRITICAL: {
                    level = Level.SEVERE;
                    break;
                }
                case WARNING: {
                    level = Level.WARNING;
                    break;
                }
                case GOOD: {
                    level = Level.INFO;
                    break;
                }
                default: {
                    level = Level.OFF;
                    break;
                }
                case FINE: {
                    level = Level.FINE;
                }
            }
            this.check.sendNotification(this.name, checkResult, level);
        }
    }
}

