/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.nucleus.healthcheck.HealthCheckService;
import fish.payara.nucleus.healthcheck.configuration.Checker;
import fish.payara.nucleus.healthcheck.configuration.HealthCheckServiceConfiguration;
import fish.payara.nucleus.healthcheck.preliminary.BaseHealthCheck;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.validation.constraints.Min;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Deprecated
@Service(name="healthcheck-configure-service")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="healthcheck.configure.service")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=HealthCheckServiceConfiguration.class, opType=RestEndpoint.OpType.POST, path="healthcheck-configure-service", description="Enables/Disables Health Check Service Specified With Name")})
public class HealthCheckServiceConfigurer
implements AdminCommand {
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(HealthCheckServiceConfigurer.class);
    @Inject
    ServiceLocator habitat;
    @Inject
    protected Target targetUtil;
    @Inject
    protected Logger logger;
    @Inject
    HealthCheckService healthCheckService;
    @Param(name="enabled", optional=false)
    private Boolean enabled;
    @Param(name="time", optional=true)
    @Min(value=1L, message="Time period must be 1 or more")
    private @Min(value=1L, message="Time period must be 1 or more") String time;
    @Param(name="unit", optional=true, acceptableValues="DAYS,HOURS,MICROSECONDS,MILLISECONDS,MINUTES,NANOSECONDS,SECONDS")
    private String unit;
    @Param(name="serviceName", optional=false, acceptableValues="healthcheck-cpu,healthcheck-gc,healthcheck-cpool,healthcheck-heap,healthcheck-threads,healthcheck-machinemem,healthcheck-stuck,healthcheck-mp")
    private String serviceName;
    @Param(name="name", optional=true)
    @Deprecated
    private String name;
    @Param(name="checkerName", optional=true)
    private String checkerName;
    @Param(name="addToMicroProfileHealth", optional=true, defaultValue="false")
    private Boolean addToMicroProfileHealth;
    @Param(name="dynamic", optional=true, defaultValue="false")
    protected Boolean dynamic;
    @Param(name="target", optional=true, defaultValue="server-config")
    protected String target;
    @Inject
    ServerEnvironment server;

    public void execute(AdminCommandContext context) {
        final ActionReport actionReport = context.getActionReport();
        Properties extraProperties = actionReport.getExtraProperties();
        if (extraProperties == null) {
            extraProperties = new Properties();
            actionReport.setExtraProperties(extraProperties);
        }
        Config config = this.targetUtil.getConfig(this.target);
        final BaseHealthCheck service = (BaseHealthCheck)this.habitat.getService(BaseHealthCheck.class, this.serviceName, new Annotation[0]);
        if (service == null) {
            actionReport.appendMessage(strings.getLocalString("healthcheck.service.configure.status.error", "Service with name {0} could not be found.", new Object[]{this.serviceName}));
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.name != null) {
            actionReport.appendMessage("\n--name parameter is decremented, please begin using the --checkerName option\n");
        }
        HealthCheckServiceConfiguration healthCheckServiceConfiguration = (HealthCheckServiceConfiguration)config.getExtensionByType(HealthCheckServiceConfiguration.class);
        Object checker = healthCheckServiceConfiguration.getCheckerByType(service.getCheckerType());
        try {
            final Checker[] createdChecker = new Checker[]{null};
            if (checker == null) {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HealthCheckServiceConfiguration>(){

                    public Object run(HealthCheckServiceConfiguration healthCheckServiceConfigurationProxy) throws PropertyVetoException, TransactionFailure {
                        Checker checkerProxy = (Checker)healthCheckServiceConfigurationProxy.createChild(service.getCheckerType());
                        HealthCheckServiceConfigurer.this.applyValues(checkerProxy);
                        healthCheckServiceConfigurationProxy.getCheckerList().add(checkerProxy);
                        createdChecker[0] = checkerProxy;
                        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        return healthCheckServiceConfigurationProxy;
                    }
                }, (ConfigBeanProxy)healthCheckServiceConfiguration);
            } else {
                createdChecker[0] = checker;
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Checker>(){

                    public Object run(Checker checkerProxy) throws PropertyVetoException, TransactionFailure {
                        HealthCheckServiceConfigurer.this.applyValues(checkerProxy);
                        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        return checkerProxy;
                    }
                }, checker);
            }
            if (this.dynamic.booleanValue()) {
                if (this.server.isDas()) {
                    if (this.targetUtil.getConfig(this.target).isDas()) {
                        Object checkerByType = healthCheckServiceConfiguration.getCheckerByType(service.getCheckerType());
                        service.setOptions(service.constructOptions(checkerByType));
                        this.healthCheckService.registerCheck(checkerByType.getName(), service);
                        this.healthCheckService.reboot();
                    }
                } else {
                    Object checkerByType = healthCheckServiceConfiguration.getCheckerByType(service.getCheckerType());
                    service.setOptions(service.constructOptions(checkerByType));
                    this.healthCheckService.registerCheck(checkerByType.getName(), service);
                    this.healthCheckService.reboot();
                }
            }
        }
        catch (TransactionFailure ex) {
            this.logger.log(Level.WARNING, "Exception during command ", ex);
            actionReport.setMessage(ex.getCause().getMessage());
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    private void applyValues(Checker checkerProxy) throws PropertyVetoException {
        if (this.enabled != null) {
            checkerProxy.setEnabled(this.enabled.toString());
        }
        if (this.addToMicroProfileHealth != null) {
            checkerProxy.setAddToMicroProfileHealth(this.addToMicroProfileHealth.toString());
        }
        if (this.time != null) {
            checkerProxy.setTime(this.time);
        }
        if (this.unit != null) {
            checkerProxy.setUnit(this.unit);
        }
        if (this.name != null) {
            checkerProxy.setName(this.name);
        }
        if (this.checkerName != null) {
            checkerProxy.setName(this.checkerName);
        }
    }
}

