/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.preliminary;

import fish.payara.internal.notification.TimeUtil;
import fish.payara.monitoring.collect.MonitoringData;
import fish.payara.monitoring.collect.MonitoringDataCollector;
import fish.payara.monitoring.collect.MonitoringDataSource;
import fish.payara.monitoring.collect.MonitoringWatchCollector;
import fish.payara.monitoring.collect.MonitoringWatchSource;
import fish.payara.notification.healthcheck.HealthCheckResultEntry;
import fish.payara.notification.healthcheck.HealthCheckResultStatus;
import fish.payara.nucleus.healthcheck.HealthCheckHoggingThreadsExecutionOptions;
import fish.payara.nucleus.healthcheck.HealthCheckResult;
import fish.payara.nucleus.healthcheck.configuration.HoggingThreadsChecker;
import fish.payara.nucleus.healthcheck.preliminary.BaseHealthCheck;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service(name="healthcheck-threads")
@RunLevel(value=10)
public class HoggingThreadsHealthCheck
extends BaseHealthCheck<HealthCheckHoggingThreadsExecutionOptions, HoggingThreadsChecker>
implements MonitoringDataSource,
MonitoringWatchSource {
    private boolean supported;
    private final Map<Long, ThreadCpuTimeRecord> checkRecordsByThreadId = new ConcurrentHashMap<Long, ThreadCpuTimeRecord>();
    private final Map<Long, ThreadCpuTimeRecord> colletionRecordsByThreadId = new ConcurrentHashMap<Long, ThreadCpuTimeRecord>();

    @PostConstruct
    void postConstruct() {
        this.postConstruct(this, HoggingThreadsChecker.class);
        this.supported = ManagementFactory.getThreadMXBean().isCurrentThreadCpuTimeSupported();
    }

    @Override
    public HealthCheckHoggingThreadsExecutionOptions constructOptions(HoggingThreadsChecker checker) {
        return new HealthCheckHoggingThreadsExecutionOptions(Boolean.valueOf(checker.getEnabled()), Long.parseLong(checker.getTime()), this.asTimeUnit(checker.getUnit()), Boolean.valueOf(checker.getAddToMicroProfileHealth()), Long.parseLong(checker.getThresholdPercentage()), Integer.parseInt(checker.getRetryCount()));
    }

    @Override
    public String getDescription() {
        return "healthcheck.description.hoggingThreads";
    }

    @Override
    protected HealthCheckResult doCheckInternal() {
        HealthCheckResult result = new HealthCheckResult();
        if (!this.supported) {
            result.add(new HealthCheckResultEntry(HealthCheckResultStatus.CHECK_ERROR, "JVM implementation or OS does not support getting CPU times"));
            return result;
        }
        this.acceptHoggingThreads(this.checkRecordsByThreadId, (percentage, threshold, totalTimeHogging, initialMethod, info) -> result.add(new HealthCheckResultEntry(HealthCheckResultStatus.CRITICAL, "Thread with <id-name>: " + info.getThreadId() + "-" + info.getThreadName() + " is a hogging thread for the last " + TimeUtil.prettyPrintDuration((long)totalTimeHogging) + "\n" + this.prettyPrintStackTrace(info.getStackTrace()))));
        return result;
    }

    @MonitoringData(ns="health", intervalSeconds=4)
    public void collect(MonitoringDataCollector collector) {
        if (this.options == null || !((HealthCheckHoggingThreadsExecutionOptions)this.options).isEnabled() || !this.supported) {
            return;
        }
        AtomicInteger hoggingThreadCount = new AtomicInteger(0);
        AtomicLong hoggingThreadMaxDuration = new AtomicLong(0L);
        this.acceptHoggingThreads(this.colletionRecordsByThreadId, (percentage, threshold, totalTimeHogging, initialMethod, info) -> {
            String thread = info.getThreadName();
            if (thread == null || thread.isEmpty()) {
                thread = String.valueOf(info.getThreadId());
            }
            collector.annotate((CharSequence)"HoggingThreadDuration", totalTimeHogging, true, new String[]{"Thread", thread, "Usage%", String.valueOf(percentage), "Threshold%", String.valueOf(threshold), "Method", initialMethod, "Exited", String.valueOf(!initialMethod.equals(HoggingThreadsHealthCheck.getMethod(info)))});
            hoggingThreadCount.incrementAndGet();
            hoggingThreadMaxDuration.updateAndGet(value -> Math.max(value, totalTimeHogging));
        });
        collector.collect((CharSequence)"HoggingThreadCount", (Number)hoggingThreadCount).collect((CharSequence)"HoggingThreadDuration", (Number)hoggingThreadMaxDuration);
    }

    public void collect(MonitoringWatchCollector collector) {
        if (this.options == null || !((HealthCheckHoggingThreadsExecutionOptions)this.options).isEnabled() || !this.supported) {
            return;
        }
        collector.watch((CharSequence)"ns:health HoggingThreadCount", "Hogging Threads", "count").green(-1L, (Number)1, false, null, null, false).amber(0L, (Number)-2, false, null, null, false).red(1L, (Number)-2, false, null, null, false);
    }

    private void acceptHoggingThreads(Map<Long, ThreadCpuTimeRecord> recordsById, HoggingThreadConsumer consumer) {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        long now = System.currentTimeMillis();
        long currentThreadId = Thread.currentThread().getId();
        int retryCount = ((HealthCheckHoggingThreadsExecutionOptions)this.options).getRetryCount();
        int threshold = ((HealthCheckHoggingThreadsExecutionOptions)this.options).getThresholdPercentage().intValue();
        for (long threadId : bean.getAllThreadIds()) {
            long cpuTimeInNanos;
            if (threadId == currentThreadId || (cpuTimeInNanos = bean.getThreadCpuTime(threadId)) == -1L) continue;
            long cpuTime = TimeUnit.NANOSECONDS.toMillis(cpuTimeInNanos);
            ThreadCpuTimeRecord record = recordsById.get(threadId);
            if (record == null) {
                record = new ThreadCpuTimeRecord();
                recordsById.put(threadId, record);
            } else {
                HoggingThreadsHealthCheck.acceptHoggingThread(bean, now, retryCount, threshold, threadId, cpuTime, record, consumer);
            }
            record.startOfIntervalTimestamp = now;
            record.startOfIntervalCpuTime = cpuTime;
        }
    }

    private static void acceptHoggingThread(ThreadMXBean bean, long now, int retryCount, int threshold, long threadId, long cpuTime, ThreadCpuTimeRecord record, HoggingThreadConsumer consumer) {
        long intervalCpuTime = cpuTime - record.startOfIntervalCpuTime;
        long intervalLength = now - record.startOfIntervalTimestamp;
        int percentage = (int)(intervalCpuTime * 100L / intervalLength);
        if (percentage > threshold) {
            if (record.identifiedAsHoggingCount == 0) {
                record.startOfExceedingThresholdTimestamp = record.startOfIntervalTimestamp;
                record.identifiedAsHoggingMethod = HoggingThreadsHealthCheck.getMethod(bean.getThreadInfo(threadId, 1));
            }
            ++record.identifiedAsHoggingCount;
            if (record.identifiedAsHoggingCount > retryCount) {
                ThreadInfo info = bean.getThreadInfo(threadId, 1);
                long totalTimeHogging = now - record.startOfExceedingThresholdTimestamp;
                consumer.accept(percentage, threshold, totalTimeHogging, record.identifiedAsHoggingMethod, info);
            }
        } else {
            record.identifiedAsHoggingCount = 0;
        }
    }

    static String getMethod(ThreadInfo info) {
        if (info.getStackTrace().length == 0) {
            return "?";
        }
        StackTraceElement frame = info.getStackTrace()[0];
        return frame.getClassName() + "#" + frame.getMethodName() + ":" + frame.getLineNumber();
    }

    private static final class ThreadCpuTimeRecord {
        long startOfIntervalTimestamp;
        long startOfIntervalCpuTime;
        long startOfExceedingThresholdTimestamp;
        int identifiedAsHoggingCount;
        String identifiedAsHoggingMethod;

        ThreadCpuTimeRecord() {
        }
    }

    @FunctionalInterface
    private static interface HoggingThreadConsumer {
        public void accept(int var1, int var2, long var3, String var5, ThreadInfo var6);
    }
}

