/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.threadpool;

import com.sun.corba.ee.impl.threadpool.AbstractThreadPool;
import com.sun.corba.ee.impl.threadpool.Exceptions;
import com.sun.corba.ee.impl.threadpool.PayaraThreadPoolExecutor;
import com.sun.corba.ee.impl.threadpool.WorkQueueImpl;
import com.sun.corba.ee.spi.threadpool.NoSuchWorkQueueException;
import com.sun.corba.ee.spi.threadpool.ThreadPool;
import com.sun.corba.ee.spi.threadpool.ThreadStateValidator;
import com.sun.corba.ee.spi.threadpool.Work;
import com.sun.corba.ee.spi.threadpool.WorkQueue;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.gmbal.NameValue;

@ManagedObject
@Description(value="A ThreadPool API implementation used by the ORB")
public class ThreadPoolImpl
extends AbstractThreadPool
implements ThreadPool {
    private final ThreadPoolExecutor threadPool;
    private final WorkQueueImpl queue;
    private final String name;
    private final ThreadGroup tg;
    private final ClassLoader classLoader;
    private final Set<ExecutorService> longRunningTasks = new ConcurrentSkipListSet<ExecutorService>(new Comparator<ExecutorService>(){

        @Override
        public int compare(ExecutorService o1, ExecutorService o2) {
            return Integer.compare(System.identityHashCode(o1), System.identityHashCode(o2));
        }
    });
    private final AtomicLong totalTimeTaken = new AtomicLong(0L);
    public static final int DEFAULT_INACTIVITY_TIMEOUT = 120000;
    public static final int DEFAULT_MINIMUM_THREAD_POOL = 10;

    public ThreadPoolImpl(String threadpoolName) {
        this(Thread.currentThread().getThreadGroup(), threadpoolName);
    }

    public ThreadPoolImpl(ThreadGroup tg, String threadpoolName) {
        this(tg, threadpoolName, ThreadPoolImpl.getDefaultClassLoader());
    }

    public ThreadPoolImpl(ThreadGroup tg, String threadpoolName, ClassLoader defaultClassLoader) {
        this(0, Integer.MAX_VALUE, 120000L, threadpoolName, tg, defaultClassLoader);
    }

    public ThreadPoolImpl(int minSize, int maxSize, long timeout, String threadpoolName) {
        this(minSize, maxSize, timeout, threadpoolName, Thread.currentThread().getThreadGroup(), ThreadPoolImpl.getDefaultClassLoader());
    }

    public ThreadPoolImpl(int minSize, int maxSize, final long timeout, String threadpoolName, ThreadGroup tg, ClassLoader defaultClassLoader) {
        this.queue = new WorkQueueImpl(this);
        this.name = threadpoolName;
        this.tg = tg;
        this.classLoader = defaultClassLoader;
        final int _minSize = Math.max(minSize, 5);
        final int _maxSize = Math.max(10, maxSize);
        this.threadPool = System.getSecurityManager() == null ? this.createTPE(_minSize, _maxSize, timeout) : AccessController.doPrivileged(new PrivilegedAction<ThreadPoolExecutor>(){

            @Override
            public ThreadPoolExecutor run() {
                return ThreadPoolImpl.this.createTPE(_minSize, _maxSize, timeout);
            }
        });
    }

    private ThreadPoolExecutor createTPE(int minSize, int maxSize, long timeout) {
        return new PayaraThreadPoolExecutor(minSize, maxSize, timeout, TimeUnit.MILLISECONDS, new ORBThreadFactory(this.name, this.tg, this.classLoader, false));
    }

    @Override
    void submit(Work item, boolean isLongRunning) {
        ExecutorService task;
        if (isLongRunning) {
            task = Executors.newSingleThreadExecutor(new ORBThreadFactory(this.name, this.tg, this.classLoader, true));
            this.longRunningTasks.add(task);
        } else {
            task = this.threadPool;
        }
        task.submit(new TaskRunner(item, isLongRunning));
    }

    @Override
    BlockingQueue<Runnable> getQueue() {
        return this.threadPool.getQueue();
    }

    @Override
    public WorkQueue getAnyWorkQueue() {
        return this.queue;
    }

    @Override
    public WorkQueue getWorkQueue(int queueId) throws NoSuchWorkQueueException {
        if (queueId != 0) {
            throw new NoSuchWorkQueueException();
        }
        return this.queue;
    }

    @Override
    public int numberOfWorkQueues() {
        return 1;
    }

    @Override
    public int minimumNumberOfThreads() {
        return this.threadPool.getPoolSize();
    }

    @Override
    public int maximumNumberOfThreads() {
        return this.threadPool.getMaximumPoolSize();
    }

    @Override
    public long idleTimeoutForThreads() {
        return this.threadPool.getKeepAliveTime(TimeUnit.MILLISECONDS);
    }

    @Override
    @ManagedAttribute
    @Description(value="The current number of threads")
    public int currentNumberOfThreads() {
        return this.threadPool.getPoolSize();
    }

    @Override
    @ManagedAttribute
    @Description(value="The number of available threads in this ThreadPool")
    public int numberOfAvailableThreads() {
        return this.threadPool.getPoolSize() - this.threadPool.getActiveCount();
    }

    @Override
    @ManagedAttribute
    @Description(value="The number of threads busy processing work in this ThreadPool")
    public int numberOfBusyThreads() {
        return this.threadPool.getActiveCount();
    }

    @Override
    @ManagedAttribute
    @Description(value="The number of work items processed")
    public long currentProcessedCount() {
        return this.threadPool.getCompletedTaskCount();
    }

    @Override
    @ManagedAttribute
    @Description(value="The average time needed to complete a work item")
    public long averageWorkCompletionTime() {
        return this.totalTimeTaken.get() / (this.threadPool.getCompletedTaskCount() == 0L ? 1L : this.threadPool.getCompletedTaskCount());
    }

    @Override
    @NameValue
    public String getName() {
        return this.name;
    }

    @Override
    public void close() throws IOException {
        this.threadPool.shutdown();
        for (ExecutorService e : this.longRunningTasks) {
            e.shutdown();
        }
    }

    private static ClassLoader getDefaultClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        return cl;
    }

    ThreadPoolExecutor getPoolImpl() {
        return this.threadPool;
    }

    private class TaskRunner
    implements Runnable {
        private final Work item;
        private final boolean isLongRunning;

        public TaskRunner(Work item, boolean isLongRunning) {
            this.item = item;
            this.isLongRunning = isLongRunning;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long start = System.currentTimeMillis();
            try {
                if (!this.isLongRunning) {
                    ThreadPoolImpl.this.queue.incrDequeue(this.item);
                }
                this.item.doWork();
            }
            catch (Throwable t) {
                Exceptions.self.workerThreadThrowableFromRequestWork(t, ThreadPoolImpl.this, ThreadPoolImpl.this.queue.getName());
            }
            finally {
                ThreadStateValidator.checkValidators();
                if (!this.isLongRunning) {
                    long elapsedTime = System.currentTimeMillis() - start;
                    ThreadPoolImpl.this.totalTimeTaken.addAndGet(elapsedTime);
                }
            }
        }
    }

    static class ORBThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final String namePrefix;
        private final ClassLoader classLoader;

        ORBThreadFactory(String name, ThreadGroup group, ClassLoader classLoader, boolean isLongRunning) {
            this.group = group;
            this.classLoader = classLoader;
            this.namePrefix = String.format("orb-%s (pool #%d)%s: worker", name, poolNumber.getAndIncrement(), isLongRunning ? " - (long-running)" : "");
        }

        @Override
        public Thread newThread(final Runnable r) {
            if (System.getSecurityManager() == null) {
                return this.newThreadHelper(r, this.classLoader);
            }
            return AccessController.doPrivileged(new PrivilegedAction<Thread>(){

                @Override
                public Thread run() {
                    return ORBThreadFactory.this.newThreadHelper(r, ORBThreadFactory.this.classLoader);
                }
            });
        }

        private Thread newThreadHelper(Runnable r, ClassLoader cl) {
            Thread t = new Thread(this.group, r, String.format("%s-%d", this.namePrefix, this.threadNumber.getAndIncrement()), 0L);
            t.setContextClassLoader(cl);
            if (!this.group.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

