/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.jdbc.stats;

import com.sun.gjc.util.SQLTrace;
import com.sun.gjc.util.SQLTraceCache;
import fish.payara.jdbc.stats.SlowSqlTrace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SlowSqlTraceCache
extends SQLTraceCache {
    public SlowSqlTraceCache(String poolName, int maxNumberOfQueries, long timeToKeepQueries) {
        super(poolName, maxNumberOfQueries, timeToKeepQueries);
    }

    @Override
    public void checkAndUpdateCache(SQLTrace sqlTrace) {
        if (sqlTrace != null) {
            SlowSqlTrace slowSqlTrace = (SlowSqlTrace)sqlTrace;
            SlowSqlTrace storedSlowSqlTrace = (SlowSqlTrace)this.cache.get(slowSqlTrace.getQueryName());
            if (storedSlowSqlTrace != null) {
                storedSlowSqlTrace.setNumExecutions(storedSlowSqlTrace.getNumExecutions() + 1);
                storedSlowSqlTrace.setLastUsageTime(System.currentTimeMillis());
                long newExecutionTime = slowSqlTrace.getSlowestExecutionTime();
                if (storedSlowSqlTrace.getSlowestExecutionTime() < newExecutionTime) {
                    storedSlowSqlTrace.setSlowestExecutionTime(newExecutionTime);
                }
            } else {
                this.cache.put(slowSqlTrace.getQueryName(), slowSqlTrace);
            }
        }
    }

    @Override
    public void purgeEntries() {
        ArrayList slowSqlTraceList = new ArrayList(this.cache.values());
        Collections.sort(slowSqlTraceList, SlowSqlTrace.SlowSqlTraceSlowestExecutionComparator);
        for (int elementCount = slowSqlTraceList.size(); elementCount > this.numTopQueriesToReport; --elementCount) {
            SlowSqlTrace slowSqlTrace = (SlowSqlTrace)slowSqlTraceList.get(elementCount - 1);
            this.cache.remove(slowSqlTrace.getQueryName());
            slowSqlTraceList.remove(slowSqlTrace);
        }
    }

    public List<SlowSqlTrace> getSlowestSqlQueries() {
        this.purgeEntries();
        ArrayList<SlowSqlTrace> slowSqlTraceList = new ArrayList<SlowSqlTrace>(this.cache.values());
        Collections.sort(slowSqlTraceList, SlowSqlTrace.SlowSqlTraceSlowestExecutionComparator);
        return slowSqlTraceList;
    }
}

