/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.appserver.micro.services.data;

import fish.payara.appserver.micro.services.data.ApplicationDescriptorImpl;
import fish.payara.micro.data.ApplicationDescriptor;
import fish.payara.micro.data.InstanceDescriptor;
import fish.payara.micro.data.ModuleDescriptor;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import org.glassfish.internal.data.ApplicationInfo;

public class InstanceDescriptorImpl
implements InstanceDescriptor {
    private static final long serialVersionUID = 1L;
    private final String memberUUID;
    private String instanceName;
    private final List<Integer> httpPorts;
    private final List<Integer> httpsPorts;
    private InetAddress hostName = InetAddress.getLocalHost();
    private Map<String, ApplicationDescriptor> deployedApplications;
    private boolean liteMember;
    private String instanceType;
    private int hazelcastPort;
    private int adminPort;
    private String instanceGroup;
    private long heartBeatTS;

    public InstanceDescriptorImpl(String UUID) throws UnknownHostException {
        this.memberUUID = UUID;
        this.httpPorts = new ArrayList<Integer>();
        this.httpsPorts = new ArrayList<Integer>();
        this.heartBeatTS = System.currentTimeMillis();
    }

    public void addApplication(ApplicationInfo info) {
        if (this.deployedApplications == null) {
            this.deployedApplications = new HashMap<String, ApplicationDescriptor>(3);
        }
        ApplicationDescriptorImpl ad = new ApplicationDescriptorImpl(info);
        this.deployedApplications.put(ad.getName(), ad);
    }

    public void addApplication(ApplicationDescriptor descriptor) {
        if (this.deployedApplications == null) {
            this.deployedApplications = new HashMap<String, ApplicationDescriptor>(3);
        }
        this.deployedApplications.put(descriptor.getName(), descriptor);
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getMemberUUID() {
        return this.memberUUID;
    }

    public List<Integer> getHttpPorts() {
        return this.httpPorts;
    }

    public void addHttpPort(int httpPort) {
        this.httpPorts.add(httpPort);
    }

    public InetAddress getHostName() {
        return this.hostName;
    }

    public void setHostName(InetAddress hostName) {
        this.hostName = hostName;
    }

    public Collection<ApplicationDescriptor> getDeployedApplications() {
        if (this.deployedApplications == null) {
            return new HashSet<ApplicationDescriptor>();
        }
        return this.deployedApplications.values();
    }

    public List<Integer> getHttpsPorts() {
        return this.httpsPorts;
    }

    public void addHttpsPort(int httpsPort) {
        this.httpsPorts.add(httpsPort);
    }

    public void removeApplication(ApplicationDescriptor applicationInfo) {
        if (this.deployedApplications == null) {
            this.deployedApplications = new HashMap<String, ApplicationDescriptor>(3);
        }
        this.deployedApplications.remove(applicationInfo.getName());
    }

    public boolean equals(Object obj) {
        return obj instanceof InstanceDescriptorImpl && this.memberUUID.equals(((InstanceDescriptorImpl)obj).memberUUID);
    }

    public int hashCode() {
        return this.memberUUID.hashCode();
    }

    public boolean isLiteMember() {
        return this.liteMember;
    }

    public void setLiteMember(boolean isLiteMember) {
        this.liteMember = isLiteMember;
    }

    public boolean isMicroInstance() {
        return this.instanceType.equals("MICRO");
    }

    public boolean isPayaraInstance() {
        return this.instanceType.equals("DAS") || this.instanceType.equals("INSTANCE");
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public void setHazelcastPort(int hazelcastPort) {
        this.hazelcastPort = hazelcastPort;
    }

    public int getHazelcastPort() {
        return this.hazelcastPort;
    }

    public void setAdminPort(int adminPort) {
        this.adminPort = adminPort;
    }

    public int getAdminPort() {
        return this.adminPort;
    }

    public String toJsonString(boolean verbose) {
        StringWriter writer = new StringWriter();
        HashMap<String, Boolean> writerConfig = new HashMap<String, Boolean>();
        writerConfig.put("javax.json.stream.JsonGenerator.prettyPrinting", Boolean.TRUE);
        try (JsonWriter jsonWriter = Json.createWriterFactory(writerConfig).createWriter((Writer)writer);){
            jsonWriter.writeObject(this.toJsonObject(verbose));
            String string = writer.toString();
            return string;
        }
    }

    private JsonObject toJsonObject(boolean verbose) {
        JsonObjectBuilder configBuilder = Json.createObjectBuilder();
        configBuilder.add("Host", this.hostName.getCanonicalHostName());
        configBuilder.add("Http Port(s)", Arrays.toString(this.getHttpPorts().toArray()).replaceAll("[\\[\\]]", ""));
        configBuilder.add("Https Port(s)", Arrays.toString(this.getHttpsPorts().toArray()).replaceAll("[\\[\\]]", ""));
        configBuilder.add("Instance Name", this.instanceName);
        configBuilder.add("Instance Group", this.instanceGroup);
        if (this.memberUUID != null) {
            configBuilder.add("Hazelcast Member UUID", this.memberUUID);
        }
        JsonArrayBuilder deploymentBuilder = Json.createArrayBuilder();
        this.getDeployedApplications().forEach(app -> {
            JsonObjectBuilder appBuilder = Json.createObjectBuilder();
            appBuilder.add("Name", app.getName());
            if (app.getModuleDescriptors().size() == 1) {
                ModuleDescriptor module2 = (ModuleDescriptor)app.getModuleDescriptors().get(0);
                appBuilder.add("Type", module2.getType());
                appBuilder.add("Context Root", module2.getContextRoot() == null ? "N/A" : module2.getContextRoot());
                if (verbose) {
                    JsonObjectBuilder servletMappings = Json.createObjectBuilder();
                    module2.getServletMappings().forEach((key, value) -> servletMappings.add(key, value));
                    appBuilder.add("Mappings", (JsonValue)servletMappings.build());
                }
            } else {
                JsonArrayBuilder modules = Json.createArrayBuilder();
                app.getModuleDescriptors().forEach(module -> {
                    JsonObjectBuilder moduleBuilder = Json.createObjectBuilder();
                    moduleBuilder.add("Name", module.getName());
                    moduleBuilder.add("Type", module.getType());
                    moduleBuilder.add("Context Root", module.getContextRoot() == null ? "***" : module.getContextRoot());
                    if (verbose) {
                        JsonObjectBuilder servletMappings = Json.createObjectBuilder();
                        module.getServletMappings().forEach((key, value) -> servletMappings.add(key, value));
                        moduleBuilder.add("Mappings", (JsonValue)servletMappings.build());
                    }
                    modules.add((JsonValue)moduleBuilder.build());
                });
                appBuilder.add("Modules", (JsonValue)modules.build());
            }
            deploymentBuilder.add((JsonValue)appBuilder.build());
        });
        configBuilder.add("Deployed", (JsonValue)deploymentBuilder.build());
        return Json.createObjectBuilder().add("Instance Configuration", (JsonValue)configBuilder.build()).build();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nInstance Configuration\n");
        sb.append("Host: ").append(this.hostName.getCanonicalHostName()).append('\n');
        sb.append("HTTP Port(s): ");
        for (Integer port : this.getHttpPorts()) {
            sb.append(port).append(' ');
        }
        sb.append('\n');
        sb.append("HTTPS Port(s): ");
        for (Integer port : this.getHttpsPorts()) {
            sb.append(port).append(' ');
        }
        sb.append('\n');
        sb.append("Instance Name: ").append(this.instanceName).append('\n');
        sb.append("Instance Group: ").append(this.instanceGroup).append('\n');
        if (this.memberUUID != null) {
            sb.append("Hazelcast Member UUID ").append(this.memberUUID).append('\n');
        }
        for (ApplicationDescriptor applicationDescriptor : this.getDeployedApplications()) {
            sb.append("Deployed: ");
            sb.append(applicationDescriptor.getName()).append(" ( ");
            for (ModuleDescriptor moduleDescriptor : applicationDescriptor.getModuleDescriptors()) {
                sb.append(moduleDescriptor.getName()).append(' ').append(moduleDescriptor.getType()).append(' ');
                if (moduleDescriptor.getContextRoot() != null) {
                    sb.append(moduleDescriptor.getContextRoot());
                } else {
                    sb.append("***");
                }
                sb.append(" [ ");
                for (Map.Entry servletMapping : moduleDescriptor.getServletMappings().entrySet()) {
                    sb.append("< ").append((String)servletMapping.getValue()).append(' ').append((String)servletMapping.getKey()).append(" >");
                }
                sb.append(" ] ");
            }
            sb.append(")\n");
            String libraries = applicationDescriptor.getLibraries();
            if (libraries == null) continue;
            sb.append(' ').append(applicationDescriptor.getLibraries());
        }
        sb.append('\n');
        return sb.toString();
    }

    public List<URL> getApplicationURLS() {
        LinkedList<URL> result = new LinkedList<URL>();
        if (this.deployedApplications != null) {
            for (Map.Entry<String, ApplicationDescriptor> ai : this.deployedApplications.entrySet()) {
                for (ModuleDescriptor moduleDescriptor : ai.getValue().getModuleDescriptors()) {
                    String contextRoot = moduleDescriptor.getContextRoot();
                    if (contextRoot == null) continue;
                    for (Integer httpPort : this.httpPorts) {
                        try {
                            result.add(new URL("http", this.hostName.getCanonicalHostName(), httpPort, contextRoot));
                        }
                        catch (MalformedURLException malformedURLException) {}
                    }
                    for (Integer httpsPort : this.httpsPorts) {
                        try {
                            result.add(new URL("https", this.hostName.getCanonicalHostName(), httpsPort, contextRoot));
                        }
                        catch (MalformedURLException malformedURLException) {}
                    }
                }
            }
        }
        return result;
    }

    public String getInstanceGroup() {
        return this.instanceGroup;
    }

    public void setInstanceGroup(String instanceGroup) {
        this.instanceGroup = instanceGroup;
    }

    public void setLastHeartBeat(long val) {
        this.heartBeatTS = val;
    }

    public long getLastHearbeat() {
        return this.heartBeatTS;
    }
}

