/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.admin.servermgmt.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.servermgmt.KeystoreManager;
import com.sun.enterprise.security.auth.realm.certificate.OID;
import java.io.File;
import java.security.KeyStore;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAKey;
import java.security.interfaces.RSAKey;
import java.util.Collection;
import java.util.concurrent.Callable;
import javax.security.auth.x500.X500Principal;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="print-certificate")
@PerLookup
public class PrintCertificateCommand
extends CLICommand {
    @Param(name="file", primary=true)
    String file;
    @Param(name="certificatealias", optional=true, defaultValue="")
    String certificateAlias;
    @Param(name="providerclass", optional=true)
    String providerClass;
    private Provider provider;
    private File derFile;
    private File keystoreFile;
    private char[] keystorePassword;

    protected void validate() throws CommandException, CommandValidationException {
        super.validate();
        if (!PrintCertificateCommand.ok((String)this.file)) {
            throw new CommandValidationException("The file with the certificate must be specified.");
        }
        File sourceFile = new File(this.file);
        if (!sourceFile.canRead()) {
            throw new CommandValidationException("The file '" + this.file + "' with the certificate must exist and must be readable.");
        }
        if (PrintCertificateCommand.ok((String)this.providerClass)) {
            try {
                this.provider = (Provider)Class.forName(this.providerClass).newInstance();
            }
            catch (ReflectiveOperationException e) {
                throw new CommandValidationException("The provider class was not found on classpath.", (Throwable)e);
            }
        }
        if (this.isDerEncodedFile()) {
            this.derFile = sourceFile;
        } else if (this.isKeystoreFile()) {
            this.keystoreFile = sourceFile;
            if (!PrintCertificateCommand.ok((String)this.certificateAlias)) {
                throw new CommandValidationException("The certificate alias is mandatory for the keystore type.");
            }
            this.keystorePassword = this.getPassword("keystorePassword", "Keystore Password", null, false);
        } else {
            throw new CommandValidationException("The file type is not supported by this command.");
        }
    }

    protected int executeCommand() throws CommandException {
        if (this.provider != null) {
            Security.insertProviderAt(this.provider, 1);
        }
        X509Certificate certificate = this.getCertificate();
        System.out.println("Found Certificate:\n" + this.toPayaraFormattedString(certificate));
        return 0;
    }

    private String toPayaraFormattedString(X509Certificate certificate) {
        StringBuilder output = new StringBuilder(1024);
        output.append("Subject:    ").append(this.toString(certificate.getSubjectX500Principal()));
        output.append("\nValidity:   ").append(certificate.getNotBefore()).append(" - ").append(certificate.getNotAfter());
        output.append("\nS/N:        ").append(certificate.getSerialNumber());
        output.append("\nVersion:    ").append(certificate.getVersion());
        output.append("\nIssuer:     ").append(this.toString(certificate.getIssuerX500Principal()));
        output.append("\nPublic Key: ").append(this.toString(certificate.getPublicKey()));
        output.append("\nSign. Alg.: ").append(certificate.getSigAlgName()).append(" (OID: ").append(certificate.getSigAlgOID()).append(')');
        return output.toString();
    }

    private String toString(X500Principal principal) {
        return principal.getName("RFC2253", OID.getOIDMap());
    }

    private String toString(PublicKey key) {
        DSAKey dsaKey;
        if (key instanceof RSAKey) {
            RSAKey rsaKey = (RSAKey)((Object)key);
            return key.getAlgorithm() + ", " + rsaKey.getModulus().bitLength() + " bits";
        }
        if (key instanceof DSAKey && (dsaKey = (DSAKey)((Object)key)).getParams() != null) {
            return key.getAlgorithm() + ", " + dsaKey.getParams().getP().bitLength() + " bits";
        }
        return key.getAlgorithm() + ", unresolved bit length.";
    }

    private boolean isDerEncodedFile() {
        return this.file.trim().matches(".*\\.(cer|cert|crt|der|pem)");
    }

    private boolean isKeystoreFile() {
        return this.file.trim().matches(".*\\.(jks|jceks|pkcs12|pfx|p12)");
    }

    private String getKeystoreType() {
        String ksFilename = this.keystoreFile.getName().toLowerCase();
        if (ksFilename.endsWith("jks")) {
            return "JKS";
        }
        if (ksFilename.endsWith("jceks")) {
            return "JCEKS";
        }
        if (ksFilename.endsWith("p12") || ksFilename.endsWith("pfx") || ksFilename.endsWith("pkcs12")) {
            return "PKCS12";
        }
        throw new IllegalStateException("Reached unreachable code, validation is incomplete!");
    }

    private X509Certificate getCertificate() throws CommandException {
        if (this.derFile != null) {
            return this.getCertificateFromDerFile();
        }
        if (this.keystoreFile != null) {
            return this.getCertificateFromKeystore();
        }
        throw new CommandException("Could not read the certificate from the provided file.");
    }

    private X509Certificate getCertificateFromDerFile() throws CommandException {
        try {
            Callable<Certificate> supplier = () -> {
                KeystoreManager manager = new KeystoreManager();
                Collection<? extends Certificate> chain = manager.readPemCertificateChain(this.derFile);
                if (chain.isEmpty()) {
                    return null;
                }
                return chain.iterator().next();
            };
            return PrintCertificateCommand.getX509Certificate(supplier);
        }
        catch (Exception e) {
            throw new CommandException("Could not read the certificate from the provided file.", (Throwable)e);
        }
    }

    private X509Certificate getCertificateFromKeystore() throws CommandException {
        try {
            Callable<Certificate> supplier = () -> {
                KeystoreManager manager = new KeystoreManager();
                String ksType = this.getKeystoreType();
                KeyStore keystore = manager.openKeyStore(this.keystoreFile, ksType, this.keystorePassword);
                return keystore.getCertificate(this.certificateAlias);
            };
            return PrintCertificateCommand.getX509Certificate(supplier);
        }
        catch (Exception e) {
            throw new CommandException("Could not read the certificate from the provided keystore.", (Throwable)e);
        }
    }

    private static X509Certificate getX509Certificate(Callable<Certificate> supplier) throws Exception {
        Certificate certificate = supplier.call();
        if (certificate instanceof X509Certificate) {
            return (X509Certificate)certificate;
        }
        throw new IllegalStateException("The certificate was found but it is not supported X509 certificate.");
    }
}

