/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.stats;

import com.sun.ejb.base.stats.StatefulSessionStoreStatsImpl;
import com.sun.ejb.spi.stats.MonitorableSFSBStoreManager;
import com.sun.enterprise.admin.monitor.stats.AverageRangeStatistic;
import com.sun.enterprise.admin.monitor.stats.BoundedRangeStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.HAStatefulSessionStoreStats;
import com.sun.enterprise.admin.monitor.stats.MutableAverageRangeStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import javax.management.j2ee.statistics.BoundedRangeStatistic;
import javax.management.j2ee.statistics.CountStatistic;

public class HAStatefulSessionStoreStatsImpl
extends StatefulSessionStoreStatsImpl
implements HAStatefulSessionStoreStats {
    private MutableCountStatisticImpl checkpointCount;
    private MutableCountStatisticImpl checkpointSuccessCount;
    private MutableCountStatisticImpl checkpointErrorCount;
    private MutableAverageRangeStatisticImpl checkpointSize;
    private MutableAverageRangeStatisticImpl checkpointTime;
    private Object checkpointCountLock = new Object();
    private Object checkpointSizeLock = new Object();
    private Object checkpointTimeLock = new Object();
    private long checkpointCountVal;
    private long checkpointSuccessCountVal;
    private long checkpointErrorCountVal;

    public HAStatefulSessionStoreStatsImpl(MonitorableSFSBStoreManager provider) {
        super(provider, "com.sun.enterprise.admin.monitor.stats.HAStatefulSessionStoreStats");
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialize() {
        super.initialize();
        Object object = this.checkpointCountLock;
        synchronized (object) {
            this.checkpointCount = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("CheckpointCount"));
            this.checkpointSuccessCount = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("CheckpointSuccessCount"));
            this.checkpointErrorCount = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("CheckpointErrorCount"));
        }
        object = this.checkpointTimeLock;
        synchronized (object) {
            this.checkpointTime = new MutableAverageRangeStatisticImpl((BoundedRangeStatistic)new BoundedRangeStatisticImpl(0L, 0L, 0L, 0L, 0L, "CheckpointTime", "millis", "Time spent on checkpointing", 0L, 0L));
        }
        object = this.checkpointSizeLock;
        synchronized (object) {
            this.checkpointSize = new MutableAverageRangeStatisticImpl((BoundedRangeStatistic)new BoundedRangeStatisticImpl(0L, 0L, 0L, 0L, 0L, "CheckpointSize", "millis", "Number of bytes checkpointed", 0L, 0L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountStatistic getCheckpointCount() {
        Object object = this.checkpointCountLock;
        synchronized (object) {
            this.checkpointCount.setCount(this.checkpointCountVal);
            return (CountStatistic)this.checkpointCount.unmodifiableView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountStatistic getCheckpointSuccessCount() {
        Object object = this.checkpointCountLock;
        synchronized (object) {
            this.checkpointSuccessCount.setCount(this.checkpointSuccessCountVal);
            return (CountStatistic)this.checkpointSuccessCount.unmodifiableView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountStatistic getCheckpointErrorCount() {
        Object object = this.checkpointCountLock;
        synchronized (object) {
            this.checkpointErrorCount.setCount(this.checkpointErrorCountVal);
            return (CountStatistic)this.checkpointErrorCount.unmodifiableView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AverageRangeStatistic getCheckpointedBeanSize() {
        Object object = this.checkpointTimeLock;
        synchronized (object) {
            return (AverageRangeStatistic)this.checkpointSize.unmodifiableView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AverageRangeStatistic getCheckpointTime() {
        Object object = this.checkpointTimeLock;
        synchronized (object) {
            return (AverageRangeStatistic)this.checkpointTime.unmodifiableView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementCheckpointCount(boolean success) {
        Object object = this.checkpointCountLock;
        synchronized (object) {
            ++this.checkpointCountVal;
            if (success) {
                ++this.checkpointSuccessCountVal;
            } else {
                ++this.checkpointErrorCountVal;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCheckpointSize(long val) {
        Object object = this.checkpointSizeLock;
        synchronized (object) {
            this.checkpointSize.setCount(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCheckpointTime(long val) {
        Object object = this.checkpointTimeLock;
        synchronized (object) {
            this.checkpointTime.setCount(val);
        }
    }

    @Override
    protected void appendStats(StringBuilder sbuf) {
        super.appendStats(sbuf);
        sbuf.append("CheckpointCount: ").append(this.checkpointCountVal).append("; ").append("CheckpointSuccessCount: ").append(this.checkpointSuccessCountVal).append("; ").append("CheckpointErrorCount: ").append(this.checkpointErrorCountVal).append("; ");
        HAStatefulSessionStoreStatsImpl.appendTimeStatistic(sbuf, "CheckpointTime", this.checkpointTime);
    }
}

