/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.interceptors;

import com.sun.ejb.containers.interceptors.InterceptorManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.ejb.EJBException;

class AroundInvokeInterceptor {
    protected int index;
    protected Method method;

    AroundInvokeInterceptor(int index, Method method) {
        this.index = index;
        this.method = method;
        try {
            Method finalM = method;
            if (System.getSecurityManager() == null) {
                if (!finalM.isAccessible()) {
                    finalM.setAccessible(true);
                }
            } else {
                PrivilegedExceptionAction<Void> action = () -> {
                    if (!finalM.isAccessible()) {
                        finalM.setAccessible(true);
                    }
                    return null;
                };
                AccessController.doPrivileged(action);
            }
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    Object intercept(InterceptorManager.AroundInvokeContext invCtx) throws Throwable {
        try {
            Object[] interceptors = invCtx.getInterceptorInstances();
            if (System.getSecurityManager() != null) {
                PrivilegedExceptionAction<Object> action = () -> this.method.invoke(interceptors[this.index], invCtx);
                return AccessController.doPrivileged(action);
            }
            return this.method.invoke(interceptors[this.index], invCtx);
        }
        catch (InvocationTargetException invEx) {
            throw invEx.getCause();
        }
        catch (PrivilegedActionException paEx) {
            Throwable th = paEx.getCause();
            if (th.getCause() != null) {
                throw th.getCause();
            }
            throw th;
        }
    }

    public String toString() {
        return "[" + this.index + "]: " + this.method;
    }
}

