/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid;

import fish.payara.security.annotations.OpenIdAuthenticationDefinition;
import fish.payara.security.openid.OpenIdCredential;
import fish.payara.security.openid.api.OpenIdState;
import fish.payara.security.openid.api.RefreshToken;
import fish.payara.security.openid.controller.AuthenticationController;
import fish.payara.security.openid.controller.ConfigurationController;
import fish.payara.security.openid.controller.OriginalRequestController;
import fish.payara.security.openid.controller.StateController;
import fish.payara.security.openid.controller.TokenController;
import fish.payara.security.openid.domain.LogoutConfiguration;
import fish.payara.security.openid.domain.OpenIdConfiguration;
import fish.payara.security.openid.domain.OpenIdContextImpl;
import fish.payara.security.openid.domain.RefreshTokenImpl;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.enterprise.AuthenticationException;
import javax.security.enterprise.AuthenticationStatus;
import javax.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import javax.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import javax.security.enterprise.credential.Credential;
import javax.security.enterprise.identitystore.CredentialValidationResult;
import javax.security.enterprise.identitystore.IdentityStoreHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Response;
import org.glassfish.common.util.StringHelper;

@Typed(value={OpenIdAuthenticationMechanism.class})
public class OpenIdAuthenticationMechanism
implements HttpAuthenticationMechanism {
    private OpenIdConfiguration configuration;
    @Inject
    private OpenIdContextImpl context;
    @Inject
    private IdentityStoreHandler identityStoreHandler;
    @Inject
    private ConfigurationController configurationController;
    @Inject
    private AuthenticationController authenticationController;
    @Inject
    private TokenController tokenController;
    @Inject
    private StateController stateController;
    @Inject
    private OriginalRequestController originalRequestController;
    private static final Logger LOGGER = Logger.getLogger(OpenIdAuthenticationMechanism.class.getName());
    private static final String SESSION_LOCK_NAME = OpenIdAuthenticationMechanism.class.getName();

    public OpenIdAuthenticationMechanism() {
    }

    public OpenIdAuthenticationMechanism(OpenIdAuthenticationDefinition definition) {
        this();
        this.setConfiguration(definition);
    }

    public OpenIdAuthenticationMechanism setConfiguration(OpenIdAuthenticationDefinition definition) {
        this.configuration = this.configurationController.buildConfig(definition);
        return this;
    }

    public AuthenticationStatus validateRequest(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpContext) throws AuthenticationException {
        if (Objects.isNull(request.getUserPrincipal())) {
            LOGGER.fine("UserPrincipal is not set, authenticate user using OpenId Connect protocol.");
            return this.authenticate(request, response, httpContext);
        }
        try {
            httpContext.getHandler().handle(new Callback[]{new CallerPrincipalCallback(httpContext.getClientSubject(), request.getUserPrincipal())});
        }
        catch (IOException | UnsupportedCallbackException ex) {
            throw new AuthenticationException("Failed to register CallerPrincipalCallback.", (Throwable)ex);
        }
        LogoutConfiguration logout = this.configuration.getLogoutConfiguration();
        boolean accessTokenExpired = this.context.getAccessToken().isExpired();
        boolean identityTokenExpired = this.context.getIdentityToken().isExpired();
        if (logout.isIdentityTokenExpiry()) {
            LOGGER.log(Level.FINE, "UserPrincipal is set, check if Identity Token is valid.");
        }
        if (logout.isAccessTokenExpiry()) {
            LOGGER.log(Level.FINE, "UserPrincipal is set, check if Access Token is valid.");
        }
        if ((accessTokenExpired || identityTokenExpired) && this.configuration.isTokenAutoRefresh()) {
            if (accessTokenExpired) {
                LOGGER.fine("Access Token is expired. Request new Access Token with Refresh Token.");
            }
            if (identityTokenExpired) {
                LOGGER.fine("Identity Token is expired. Request new Identity Token with Refresh Token.");
            }
            return this.reAuthenticate(httpContext);
        }
        if (logout.isAccessTokenExpiry() && accessTokenExpired || logout.isIdentityTokenExpiry() && identityTokenExpired) {
            this.context.logout(request, response);
            return AuthenticationStatus.SEND_FAILURE;
        }
        return AuthenticationStatus.SUCCESS;
    }

    private AuthenticationStatus authenticate(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpContext) throws AuthenticationException {
        if (httpContext.isProtected() && Objects.isNull(request.getUserPrincipal())) {
            this.originalRequestController.store(this.configuration, request, response);
            return this.authenticationController.authenticateUser(this.configuration, request, response);
        }
        Optional receivedState = OpenIdState.from((String)request.getParameter("state"));
        String redirectURI = this.configuration.buildRedirectURI(request);
        if (receivedState.isPresent()) {
            if (!request.getRequestURL().toString().equals(redirectURI)) {
                LOGGER.log(Level.INFO, "OpenID Redirect URL {0} not matched with request URL {1}", new Object[]{redirectURI, request.getRequestURL().toString()});
                return httpContext.notifyContainerAboutLogin(CredentialValidationResult.NOT_VALIDATED_RESULT);
            }
            Optional<OpenIdState> expectedState = this.stateController.get(this.configuration, request, response);
            if (!expectedState.isPresent()) {
                LOGGER.fine("Expected state not found");
                return httpContext.notifyContainerAboutLogin(CredentialValidationResult.NOT_VALIDATED_RESULT);
            }
            if (!expectedState.equals(receivedState)) {
                LOGGER.fine("Inconsistent received state, value not matched");
                return httpContext.notifyContainerAboutLogin(CredentialValidationResult.INVALID_RESULT);
            }
            return this.validateAuthorizationCode(httpContext);
        }
        return httpContext.doNothing();
    }

    private AuthenticationStatus validateAuthorizationCode(HttpMessageContext httpContext) {
        HttpServletRequest request = httpContext.getRequest();
        HttpServletResponse response = httpContext.getResponse();
        String error = request.getParameter("error");
        String errorDescription = request.getParameter("error_description");
        if (!StringHelper.isEmpty(error)) {
            LOGGER.log(Level.WARNING, "Error occurred in receiving Authorization Code : {0} caused by {1}", new Object[]{error, errorDescription});
            return httpContext.notifyContainerAboutLogin(CredentialValidationResult.INVALID_RESULT);
        }
        this.stateController.remove(this.configuration, request, response);
        LOGGER.finer("Authorization Code received, now fetching Access token & Id token");
        Response tokenResponse = this.tokenController.getTokens(this.configuration, request);
        JsonObject tokensObject = this.readJsonObject((String)tokenResponse.readEntity(String.class));
        if (tokenResponse.getStatus() == Response.Status.OK.getStatusCode()) {
            this.updateContext(tokensObject);
            OpenIdCredential credential = new OpenIdCredential(tokensObject, httpContext, this.configuration);
            CredentialValidationResult validationResult = this.identityStoreHandler.validate((Credential)credential);
            httpContext.setRegisterSession(validationResult.getCallerPrincipal().getName(), validationResult.getCallerGroups());
            return httpContext.notifyContainerAboutLogin(validationResult);
        }
        error = tokensObject.getString("error", "Unknown Error");
        errorDescription = tokensObject.getString("error_description", "Unknown");
        LOGGER.log(Level.WARNING, "Error occurred in validating Authorization Code : {0} caused by {1}", new Object[]{error, errorDescription});
        return httpContext.notifyContainerAboutLogin(CredentialValidationResult.INVALID_RESULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthenticationStatus reAuthenticate(HttpMessageContext httpContext) throws AuthenticationException {
        HttpServletRequest request = httpContext.getRequest();
        HttpServletResponse response = httpContext.getResponse();
        Object object = this.getSessionLock(httpContext.getRequest());
        synchronized (object) {
            boolean accessTokenExpired = this.context.getAccessToken().isExpired();
            boolean identityTokenExpired = this.context.getIdentityToken().isExpired();
            if (accessTokenExpired || identityTokenExpired) {
                AuthenticationStatus refreshStatus;
                if (accessTokenExpired) {
                    LOGGER.fine("Access Token is expired. Request new Access Token with Refresh Token.");
                }
                if (identityTokenExpired) {
                    LOGGER.fine("Identity Token is expired. Request new Identity Token with Refresh Token.");
                }
                if ((refreshStatus = this.context.getRefreshToken().map(rt -> this.refreshTokens(httpContext, (RefreshToken)rt)).orElse(AuthenticationStatus.SEND_FAILURE)) != AuthenticationStatus.SUCCESS) {
                    LOGGER.log(Level.FINE, "Failed to refresh token (Refresh Token might be invalid).");
                    this.context.logout(request, response);
                }
                return refreshStatus;
            }
        }
        return AuthenticationStatus.SUCCESS;
    }

    private AuthenticationStatus refreshTokens(HttpMessageContext httpContext, RefreshToken refreshToken) {
        Response response = this.tokenController.refreshTokens(this.configuration, refreshToken);
        JsonObject tokensObject = this.readJsonObject((String)response.readEntity(String.class));
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            this.updateContext(tokensObject);
            OpenIdCredential credential = new OpenIdCredential(tokensObject, httpContext, this.configuration);
            CredentialValidationResult validationResult = this.identityStoreHandler.validate((Credential)credential);
            return httpContext.notifyContainerAboutLogin(validationResult);
        }
        String error = tokensObject.getString("error", "Unknown Error");
        String errorDescription = tokensObject.getString("error_description", "Unknown");
        LOGGER.log(Level.FINE, "Error occurred in refreshing Access Token and Refresh Token : {0} caused by {1}", new Object[]{error, errorDescription});
        return AuthenticationStatus.SEND_FAILURE;
    }

    private JsonObject readJsonObject(String tokensBody) {
        try (JsonReader reader = Json.createReader((Reader)new StringReader(tokensBody));){
            JsonObject jsonObject = reader.readObject();
            return jsonObject;
        }
    }

    private void updateContext(JsonObject tokensObject) {
        JsonNumber expiresIn;
        this.context.setOpenIdConfiguration(this.configuration);
        this.context.setTokenType(tokensObject.getString("token_type", null));
        String refreshToken = tokensObject.getString("refresh_token", null);
        if (Objects.nonNull(refreshToken)) {
            this.context.setRefreshToken(new RefreshTokenImpl(refreshToken));
        }
        if (Objects.nonNull(expiresIn = tokensObject.getJsonNumber("expires_in"))) {
            this.context.setExpiresIn(expiresIn.longValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getSessionLock(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Object lock = session.getAttribute(SESSION_LOCK_NAME);
        if (!Objects.isNull(lock)) return lock;
        Class<OpenIdAuthenticationMechanism> clazz = OpenIdAuthenticationMechanism.class;
        synchronized (OpenIdAuthenticationMechanism.class) {
            lock = session.getAttribute(SESSION_LOCK_NAME);
            if (!Objects.isNull(lock)) return lock;
            lock = new Lock();
            session.setAttribute(SESSION_LOCK_NAME, lock);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return lock;
        }
    }

    private static class Lock
    implements Serializable {
        private Lock() {
        }
    }
}

