/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid.controller;

import fish.payara.security.openid.OpenIdUtil;
import fish.payara.security.openid.api.OpenIdState;
import fish.payara.security.openid.domain.OpenIdConfiguration;
import fish.payara.security.openid.http.HttpStorageController;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.common.util.StringHelper;

@ApplicationScoped
public class StateController {
    private static final String STATE_KEY = "oidc.state";

    public void store(OpenIdState state, OpenIdConfiguration configuration, HttpServletRequest request, HttpServletResponse response) {
        HttpStorageController.getInstance(configuration, request, response).store(STATE_KEY, state.getValue(), null);
    }

    public Optional<OpenIdState> get(OpenIdConfiguration configuration, HttpServletRequest request, HttpServletResponse response) {
        return HttpStorageController.getInstance(configuration, request, response).getAsString(STATE_KEY).filter(OpenIdUtil.not(StringHelper::isEmpty)).map(OpenIdState::new);
    }

    public void remove(OpenIdConfiguration configuration, HttpServletRequest request, HttpServletResponse response) {
        HttpStorageController.getInstance(configuration, request, response).remove(STATE_KEY);
    }
}

