/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid.domain;

import fish.payara.security.openid.api.AccessToken;
import fish.payara.security.openid.api.IdentityToken;
import fish.payara.security.openid.api.OpenIdClaims;
import fish.payara.security.openid.api.OpenIdContext;
import fish.payara.security.openid.api.RefreshToken;
import fish.payara.security.openid.controller.AuthenticationController;
import fish.payara.security.openid.domain.LogoutConfiguration;
import fish.payara.security.openid.domain.OpenIdConfiguration;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonObject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.common.util.StringHelper;

@SessionScoped
public class OpenIdContextImpl
implements OpenIdContext {
    private String callerName;
    private Set<String> callerGroups;
    private String tokenType;
    private AccessToken accessToken;
    private IdentityToken identityToken;
    private RefreshToken refreshToken;
    private Long expiresIn;
    private JsonObject claims;
    private OpenIdConfiguration configuration;
    @Inject
    private AuthenticationController authenticationController;
    private static final Logger LOGGER = Logger.getLogger(OpenIdContextImpl.class.getName());

    public String getCallerName() {
        return this.callerName;
    }

    public void setCallerName(String callerName) {
        this.callerName = callerName;
    }

    public Set<String> getCallerGroups() {
        return this.callerGroups;
    }

    public void setCallerGroups(Set<String> callerGroups) {
        this.callerGroups = callerGroups;
    }

    public String getSubject() {
        return (String)this.getIdentityToken().getClaim("sub");
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(AccessToken token) {
        this.accessToken = token;
    }

    public IdentityToken getIdentityToken() {
        return this.identityToken;
    }

    public void setIdentityToken(IdentityToken identityToken) {
        this.identityToken = identityToken;
    }

    public Optional<RefreshToken> getRefreshToken() {
        return Optional.ofNullable(this.refreshToken);
    }

    public void setRefreshToken(RefreshToken refreshToken) {
        this.refreshToken = refreshToken;
    }

    public Optional<Long> getExpiresIn() {
        return Optional.ofNullable(this.expiresIn);
    }

    public void setExpiresIn(Long expiresIn) {
        this.expiresIn = expiresIn;
    }

    public JsonObject getClaimsJson() {
        if (this.claims == null) {
            return Json.createObjectBuilder().build();
        }
        return this.claims;
    }

    public OpenIdClaims getClaims() {
        return new OpenIdClaims(this.getClaimsJson());
    }

    public void setClaims(JsonObject claims) {
        this.claims = claims;
    }

    public JsonObject getProviderMetadata() {
        return this.configuration.getProviderMetadata().getDocument();
    }

    public void setOpenIdConfiguration(OpenIdConfiguration configuration) {
        this.configuration = configuration;
    }

    public void logout(HttpServletRequest request, HttpServletResponse response) {
        LogoutConfiguration logout = this.configuration.getLogoutConfiguration();
        try {
            request.logout();
        }
        catch (ServletException ex) {
            LOGGER.log(Level.WARNING, "Failed to logout the user.", ex);
        }
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        if (logout.isNotifyProvider() && !StringHelper.isEmpty(this.configuration.getProviderMetadata().getEndSessionEndpoint())) {
            UriBuilder logoutURI = UriBuilder.fromUri((String)this.configuration.getProviderMetadata().getEndSessionEndpoint()).queryParam("id_token_hint", new Object[]{this.getIdentityToken().getToken()});
            if (!StringHelper.isEmpty(logout.getRedirectURI())) {
                logoutURI.queryParam("post_logout_redirect_uri", new Object[]{logout.buildRedirectURI(request)});
            }
            try {
                response.sendRedirect(logoutURI.toString());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        } else if (!StringHelper.isEmpty(logout.getRedirectURI())) {
            try {
                response.sendRedirect(logout.buildRedirectURI(request));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        } else {
            this.authenticationController.authenticateUser(this.configuration, request, response);
        }
    }
}

