/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.config.extensions.dynamodb.admin;

import com.sun.enterprise.util.StringUtils;
import fish.payara.microprofile.config.extensions.dynamodb.DynamoDBConfigSourceConfiguration;
import fish.payara.nucleus.microprofile.config.source.extension.BaseSetConfigSourceConfigurationCommand;
import fish.payara.nucleus.microprofile.config.spi.ConfigSourceConfiguration;
import fish.payara.nucleus.microprofile.config.spi.MicroprofileConfigConfiguration;
import java.beans.PropertyVetoException;
import javax.validation.constraints.Min;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="set-dynamodb-config-source-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=MicroprofileConfigConfiguration.class, opType=RestEndpoint.OpType.POST, path="set-dynamodb-config-source-configuration", description="Configures DynamoDB Config Source")})
public class SetDynamoDBConfigSourceConfigurationCommand
extends BaseSetConfigSourceConfigurationCommand<DynamoDBConfigSourceConfiguration> {
    @Param(optional=true, name="region-name", alias="regionName")
    protected String regionName;
    @Param(optional=true, name="table-name", alias="tableName")
    protected String tableName;
    @Param(optional=true, name="key-column-name", alias="keyColumnName")
    protected String keyColumnName;
    @Param(optional=true, name="value-column-name", alias="valueColumnName")
    protected String valueColumnName;
    @Param(optional=true, defaultValue="100")
    @Min(value=1L, message="Limit value must be 1 or more")
    protected @Min(value=1L, message="Limit value must be 1 or more") String limit;

    protected void applyValues(DynamoDBConfigSourceConfiguration configuration) throws PropertyVetoException {
        super.applyValues((ConfigSourceConfiguration)configuration);
        if (StringUtils.ok((String)this.regionName)) {
            configuration.setRegionName(this.regionName);
        }
        if (StringUtils.ok((String)this.tableName)) {
            configuration.setTableName(this.tableName);
        }
        if (StringUtils.ok((String)this.keyColumnName)) {
            configuration.setKeyColumnName(this.keyColumnName);
        }
        if (StringUtils.ok((String)this.valueColumnName)) {
            configuration.setValueColumnName(this.valueColumnName);
        }
        configuration.setLimit(this.limit);
    }
}

