/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl.util;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.sun.enterprise.container.common.spi.ClusteredSingletonLookup;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicReference;
import org.glassfish.internal.api.Globals;

public abstract class ClusteredSingletonLookupImplBase
implements ClusteredSingletonLookup {
    private final HazelcastCore hzCore = (HazelcastCore)Globals.getDefaultHabitat().getService(HazelcastCore.class, new Annotation[0]);
    private final String componentId;
    private final ClusteredSingletonLookup.SingletonType singletonType;
    private final String keyPrefix;
    private final String mapKey;
    private final AtomicReference<String> sessionHzKey = new AtomicReference();
    private final AtomicReference<String> lockKey = new AtomicReference();

    public ClusteredSingletonLookupImplBase(String componentId, ClusteredSingletonLookup.SingletonType singletonType) {
        this.componentId = componentId;
        this.singletonType = singletonType;
        this.keyPrefix = this.makeKeyPrefix();
        this.mapKey = this.makeMapKey();
    }

    protected final String getKeyPrefix() {
        return this.keyPrefix;
    }

    protected final String getMapKey() {
        return this.mapKey;
    }

    protected final String getLockKey() {
        return this.lockKey.updateAndGet(v -> v != null ? v : this.makeLockKey());
    }

    public final String getSessionHzKey() {
        return this.sessionHzKey.updateAndGet(v -> v != null ? v : this.makeSessionHzKey());
    }

    protected final void invalidateKeys() {
        this.sessionHzKey.set(null);
        this.lockKey.set(null);
    }

    @Override
    public ILock getDistributedLock() {
        return this.getHazelcastInstance().getLock(this.getLockKey());
    }

    @Override
    public IMap<String, Object> getClusteredSingletonMap() {
        return this.getHazelcastInstance().getMap(this.getMapKey());
    }

    @Override
    public IAtomicLong getClusteredUsageCount() {
        return this.getHazelcastInstance().getAtomicLong(this.getSessionHzKey() + "/count");
    }

    private HazelcastInstance getHazelcastInstance() {
        if (!this.hzCore.isEnabled()) {
            throw new IllegalStateException("ClusteredSingleton.getHazelcastInstance() - Hazelcast is Disabled");
        }
        return this.hzCore.getInstance();
    }

    @Override
    public boolean isClusteredEnabled() {
        return this.hzCore.isEnabled();
    }

    @Override
    public boolean isDistributedLockEnabled() {
        return this.isClusteredEnabled();
    }

    @Override
    public HazelcastCore getHazelcastCore() {
        return this.hzCore;
    }

    private String makeKeyPrefix() {
        return String.format("Payara/%s/singleton/", this.singletonType.name().toLowerCase());
    }

    private String makeMapKey() {
        return this.getKeyPrefix() + this.componentId;
    }

    private String makeLockKey() {
        return this.getSessionHzKey() + "/lock";
    }

    private String makeSessionHzKey() {
        return this.getKeyPrefix() + this.componentId + "/" + this.getClusteredSessionKey();
    }
}

