/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.monitoring.adapt;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

public class GroupData {
    private final transient GroupData parent;
    private final Map<String, Serializable> fields = new LinkedHashMap<String, Serializable>();
    private final Map<String, GroupData> children = new LinkedHashMap<String, GroupData>();

    public GroupData() {
        this(null);
    }

    private GroupData(GroupData parent) {
        this.parent = parent;
    }

    public Map<String, Serializable> getFields() {
        return this.fields;
    }

    public Map<String, GroupData> getChildren() {
        return this.children;
    }

    public GroupData parent() {
        return this.parent;
    }

    public GroupData addField(String name, Number value) {
        return this.addFieldInternal(name, value);
    }

    public GroupData addField(String name, String value) {
        return this.addFieldInternal(name, (Serializable)((Object)value));
    }

    public GroupData addField(String name, Boolean value) {
        return this.addFieldInternal(name, value);
    }

    public GroupData addField(String name, UUID value) {
        return this.addFieldInternal(name, value);
    }

    public GroupData addChild(String name) {
        GroupData child = new GroupData(this);
        this.children.put(name, child);
        return child;
    }

    private GroupData addFieldInternal(String name, Serializable value) {
        if (value != null) {
            this.fields.put(name, value);
        }
        return this;
    }

    public <T extends Serializable> T getField(String name, Class<T> type) {
        return (T)((Serializable)type.cast(this.fields.get(name)));
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        GroupData.toString(this, str);
        return str.toString();
    }

    private static void toString(GroupData obj, StringBuilder str) {
        str.append("{\n");
        int i = 0;
        for (Map.Entry<String, Serializable> entry : obj.fields.entrySet()) {
            if (i > 0) {
                str.append(", ");
            }
            str.append('\"').append(entry.getKey()).append('\"').append(':');
            Serializable value = entry.getValue();
            if (value == null) {
                str.append("null");
            } else if (value instanceof Boolean || value instanceof Number) {
                str.append(value.toString());
            } else {
                str.append('\"').append(value.toString()).append('\"');
            }
            str.append('\n');
            ++i;
        }
        i = 0;
        for (Map.Entry<String, Object> entry : obj.children.entrySet()) {
            if (i > 0) {
                str.append(", ");
            }
            str.append('\"').append(entry.getKey()).append('\"').append(':');
            GroupData.toString((GroupData)entry.getValue(), str);
            str.append('\n');
            ++i;
        }
        str.append('}');
    }
}

