/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.monitoring.alert;

import fish.payara.monitoring.alert.Watch;
import fish.payara.monitoring.model.Series;
import fish.payara.monitoring.model.SeriesDataset;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public final class Alert
implements Iterable<Frame> {
    static final int MAX_FRAMES = 20;
    private static final AtomicInteger NEXT_SERIAL = new AtomicInteger();
    private static final AtomicInteger CHANGE_COUNT = new AtomicInteger();
    public final int serial;
    public final Watch initiator;
    private final List<Frame> frames = new CopyOnWriteArrayList<Frame>();
    private Level level = Level.WHITE;
    private boolean acknowledged;
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ISO_TIME;

    public static int getChangeCount() {
        return CHANGE_COUNT.get();
    }

    public Alert(Watch initiator) {
        this.initiator = initiator;
        this.serial = NEXT_SERIAL.incrementAndGet();
    }

    @Override
    public Iterator<Frame> iterator() {
        return this.frames.iterator();
    }

    public Alert addTransition(Level to, SeriesDataset cause, List<SeriesDataset> captured) {
        Alert.assertRedOrAmberLevel(to);
        if (!this.isStopped()) {
            if (!this.frames.isEmpty()) {
                Frame recent = this.getEndFrame();
                Alert.assertSameSeriesAndInstance(cause, recent.cause);
                recent.end = cause.lastTime();
                this.acknowledged = this.acknowledged && to.isLessSevereThan(recent.level);
            } else {
                this.assertMatchesWachtedSeries(cause);
                this.acknowledged = false;
            }
            this.frames.add(new Frame(to, cause, captured));
            CHANGE_COUNT.incrementAndGet();
            this.level = to;
            if (this.frames.size() > 20) {
                this.compactFrames();
            }
        }
        return this;
    }

    private void compactFrames() {
        this.frames.get((int)0).end = this.frames.get((int)2).end;
        this.frames.remove(1);
        this.frames.remove(1);
    }

    public boolean isStarted() {
        return !this.frames.isEmpty();
    }

    public boolean isAcknowledged() {
        return this.acknowledged;
    }

    public void acknowledge() {
        if (!this.isAcknowledged()) {
            this.acknowledged = true;
            CHANGE_COUNT.incrementAndGet();
        }
    }

    public boolean isStopped() {
        return this.level.isLessSevereThan(Level.AMBER) && !this.frames.isEmpty();
    }

    public void stop(Level to, long now) {
        if (!this.isStopped()) {
            Alert.assertGreenOrWhiteLevel(to);
            this.level = to;
            this.getEndFrame().end = now;
            CHANGE_COUNT.incrementAndGet();
        }
    }

    public Level getLevel() {
        return this.level;
    }

    public long getStartTime() {
        return this.frames.isEmpty() ? -1L : this.frames.get((int)0).start;
    }

    public long getEndTime() {
        return this.frames.isEmpty() ? -1L : this.getEndFrame().end;
    }

    public Series getSeries() {
        return this.getEndFrame().cause.getSeries();
    }

    public String getInstance() {
        return this.getEndFrame().cause.getInstance();
    }

    public Frame getEndFrame() {
        return this.frames.get(this.frames.size() - 1);
    }

    public int getFrameCount() {
        return this.frames.size();
    }

    public int hashCode() {
        return this.serial;
    }

    public boolean equals(Object obj) {
        return obj instanceof Alert && this.equalTo((Alert)obj);
    }

    public boolean equalTo(Alert other) {
        return this.serial == other.serial;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append('(').append(this.serial).append(") ").append(this.initiator.name);
        long startTime = this.getStartTime();
        str.append('[');
        if (startTime >= 0L) {
            str.append(Alert.formatTime(startTime));
        }
        str.append('-');
        long endTime = this.getEndTime();
        if (endTime >= 0L) {
            str.append(Alert.formatTime(endTime));
        }
        if (this.isAcknowledged()) {
            str.append(" ACK");
        }
        str.append(']');
        str.append(' ');
        for (int i = 0; i < this.frames.size(); ++i) {
            if (i > 0) {
                str.append(" => ");
            }
            str.append((Object)this.frames.get((int)i).level);
        }
        return str.toString();
    }

    private static String formatTime(long epochMillis) {
        return TIME_FORMATTER.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMillis), ZoneId.systemDefault()));
    }

    private static void assertRedOrAmberLevel(Level to) {
        if (to != Level.RED && to != Level.AMBER) {
            throw new IllegalArgumentException("Alerts only transtion between RED and AMBER levels but got: " + (Object)((Object)to));
        }
    }

    private void assertMatchesWachtedSeries(SeriesDataset cause) {
        if (!this.initiator.watched.series.matches(cause.getSeries())) {
            throw new IllegalArgumentException("Cause did not match with watched series: " + cause.getSeries());
        }
    }

    private static void assertSameSeriesAndInstance(SeriesDataset a, SeriesDataset b) {
        if (!b.getSeries().equalTo(a.getSeries()) || !b.getInstance().equals(a.getInstance())) {
            throw new IllegalArgumentException("All transitions for an alert must refer to same cause series and instance but got: " + a);
        }
    }

    private static void assertGreenOrWhiteLevel(Level to) {
        if (to != Level.GREEN && to != Level.WHITE) {
            throw new IllegalArgumentException("Alerts only end on GREEN or WHITE levels but got: " + (Object)((Object)to));
        }
    }

    public static final class Frame
    implements Iterable<SeriesDataset> {
        public final Level level;
        public final SeriesDataset cause;
        public final long start;
        private final List<SeriesDataset> captured;
        long end;

        public Frame(Level level, SeriesDataset cause, List<SeriesDataset> captured) {
            this.level = level;
            this.cause = cause;
            this.captured = captured;
            this.start = cause.lastTime();
        }

        @Override
        public Iterator<SeriesDataset> iterator() {
            return this.captured.iterator();
        }

        public long getEnd() {
            return this.end;
        }
    }

    public static enum Level {
        RED,
        AMBER,
        GREEN,
        WHITE;


        public boolean isLessSevereThan(Level other) {
            return this.ordinal() > other.ordinal();
        }

        public static Level parse(String level) {
            return Level.valueOf(level.toUpperCase());
        }
    }
}

