/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.monitoring.alert;

import fish.payara.monitoring.alert.Alert;
import fish.payara.monitoring.alert.Watch;
import fish.payara.monitoring.model.Series;
import java.util.Collection;
import java.util.function.Predicate;

public interface AlertService {
    public AlertStatistics getAlertStatistics();

    public Collection<Alert> alertsMatching(Predicate<Alert> var1);

    default public Alert alertBySerial(int serial) {
        Collection<Alert> matches = this.alertsMatching(alert -> alert.serial == serial);
        return matches.isEmpty() ? null : matches.iterator().next();
    }

    default public Collection<Alert> alertsFor(Series series) {
        return this.alertsMatching(alert -> alert.getSeries().equalTo(series));
    }

    default public Collection<Alert> alerts() {
        return this.alertsMatching(alert -> true);
    }

    public Watch watchByName(String var1);

    public void addWatch(Watch var1);

    public void removeWatch(Watch var1);

    public boolean toggleWatch(String var1, boolean var2);

    public Collection<Watch> watches();

    public Collection<Watch> wachtesFor(Series var1);

    public static class AlertStatistics {
        public int changeCount;
        public int unacknowledgedRedAlerts;
        public int acknowledgedRedAlerts;
        public int unacknowledgedAmberAlerts;
        public int acknowledgedAmberAlerts;
        public int watches;
    }
}

