/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.monitoring.internal.alert;

import fish.payara.monitoring.adapt.MonitoringConsoleRuntime;
import fish.payara.monitoring.adapt.MonitoringConsoleWatchConfig;
import fish.payara.monitoring.alert.Alert;
import fish.payara.monitoring.alert.AlertService;
import fish.payara.monitoring.alert.Watch;
import fish.payara.monitoring.collect.MonitoringWatchCollector;
import fish.payara.monitoring.collect.MonitoringWatchSource;
import fish.payara.monitoring.data.SeriesRepository;
import fish.payara.monitoring.internal.util.JobHandle;
import fish.payara.monitoring.model.Metric;
import fish.payara.monitoring.model.Series;
import fish.payara.monitoring.model.Unit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InMemoryAlarmService
implements AlertService {
    private static final Logger LOGGER = Logger.getLogger("monitoring-console-core");
    private static final int MAX_ALERTS_PER_SERIES = 10;
    private final SeriesRepository monitoringData;
    private final String instance;
    private final boolean isDAS;
    private final JobHandle checker = new JobHandle("watch checker");
    private final Map<String, Watch> watchesByName = new ConcurrentHashMap<String, Watch>();
    private final Map<Series, Map<String, Watch>> simpleWatches = new ConcurrentHashMap<Series, Map<String, Watch>>();
    private final Map<Series, Map<String, Watch>> patternWatches = new ConcurrentHashMap<Series, Map<String, Watch>>();
    private final Map<Series, Deque<Alert>> alerts = new ConcurrentHashMap<Series, Deque<Alert>>();
    private final AtomicReference<AlertService.AlertStatistics> statistics = new AtomicReference<AlertService.AlertStatistics>(new AlertService.AlertStatistics());
    private final AtomicLong evalLoopTime = new AtomicLong();
    private final Map<String, Map<String, Watch>> collectedWatchesByInstance = new ConcurrentHashMap<String, Map<String, Watch>>();
    private final Supplier<? extends List<MonitoringWatchSource>> sources;
    private final MonitoringConsoleRuntime runtime;
    private final MonitoringConsoleWatchConfig watchConfig;

    public InMemoryAlarmService(String instance, boolean isDAS, MonitoringConsoleRuntime runtime, Supplier<? extends List<MonitoringWatchSource>> sources, SeriesRepository monitoringData) {
        this.instance = instance;
        this.isDAS = isDAS;
        this.runtime = runtime;
        this.sources = sources;
        this.watchConfig = runtime.getWatchConfig();
        this.monitoringData = monitoringData;
        if (isDAS) {
            this.addWatch(new Watch("Metric Collection Duration", new Metric(new Series("ns:monitoring CollectionDuration"), Unit.MILLIS)).programmatic().red(800L, 2, true, 800L, 3, false).amber(600L, 2, true, 600L, 3, false).green(-400L, 1, false, null, null, false));
            this.addWatch(new Watch("Watch Loop Duration", new Metric(new Series("ns:monitoring WatchLoopDuration"), Unit.MILLIS)).programmatic().red(800L, 2, true, 800L, 3, false).amber(600L, 3, true, 600L, 3, false).green(-400L, 1, false, null, null, false));
            this.addWatchesFromConfiguration();
        }
    }

    private void addWatchesFromConfiguration() {
        if (this.watchConfig != null) {
            for (String watch : this.watchConfig.list()) {
                this.addWatch(Watch.fromJSON(watch));
            }
        }
    }

    public void addRemoteWatches(WatchesSnapshot msg) {
        if (!this.isDAS) {
            return;
        }
        Map collectedBefore = this.collectedWatchesByInstance.computeIfAbsent(msg.instance, key -> new ConcurrentHashMap());
        HashSet notYetCollectedWatches = new HashSet(collectedBefore.keySet());
        for (Watch w : msg.watches) {
            Watch watch = Watch.fromRemote(w);
            Watch existing = (Watch)collectedBefore.get(watch.name);
            if (existing == null || !watch.equalsFunctionally(existing)) {
                this.addWatch(watch);
                collectedBefore.put(watch.name, watch);
            }
            notYetCollectedWatches.remove(watch.name);
        }
        for (String name : notYetCollectedWatches) {
            Watch removed = (Watch)collectedBefore.remove(name);
            if (removed == null || this.isCollectedByAnyInstance(name)) continue;
            this.removeWatch(removed);
        }
    }

    private boolean isCollectedByAnyInstance(String name) {
        for (Map<String, Watch> collectedByInstance : this.collectedWatchesByInstance.values()) {
            if (!collectedByInstance.containsKey(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean toggleWatch(String name, boolean disabled) {
        Watch watch = this.watchByName(name);
        if (watch == null) {
            return false;
        }
        if (disabled) {
            watch.disable();
            this.watchConfig.disable(watch.name);
        } else {
            watch.enable();
            this.watchConfig.enable(watch.name);
        }
        return true;
    }

    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.checker.stop();
        } else {
            LOGGER.info("Starting monitoring watch collection for " + this.instance);
            this.checker.start(this.runtime, 1, TimeUnit.SECONDS, this::checkWatches);
        }
    }

    public long getEvaluationLoopTime() {
        return this.evalLoopTime.get();
    }

    @Override
    public AlertService.AlertStatistics getAlertStatistics() {
        return this.statistics.get();
    }

    @Override
    public Collection<Alert> alertsMatching(Predicate<Alert> filter) {
        ArrayList<Alert> matches = new ArrayList<Alert>();
        for (Queue queue : this.alerts.values()) {
            for (Alert a : queue) {
                if (!filter.test(a)) continue;
                matches.add(a);
            }
        }
        return matches;
    }

    @Override
    public Collection<Alert> alerts() {
        ArrayList<Alert> all = new ArrayList<Alert>();
        for (Queue queue : this.alerts.values()) {
            all.addAll(queue);
        }
        return all;
    }

    @Override
    public Collection<Alert> alertsFor(Series series) {
        if (!series.isPattern()) {
            Deque<Alert> alertsForSeries = this.alerts.get(series);
            return alertsForSeries == null ? Collections.emptyList() : Collections.unmodifiableCollection(alertsForSeries);
        }
        if (series.equalTo(Series.ANY)) {
            return this.alerts();
        }
        ArrayList matches = null;
        for (Map.Entry<Series, Deque<Alert>> e : this.alerts.entrySet()) {
            if (!series.matches(e.getKey())) continue;
            if (matches == null) {
                matches = (ArrayList)((Object)e.getValue());
                continue;
            }
            if (!(matches instanceof ArrayList)) {
                matches = new ArrayList(matches);
            }
            matches.addAll(e.getValue());
        }
        return matches == null ? Collections.emptyList() : Collections.unmodifiableCollection(matches);
    }

    @Override
    public Watch watchByName(String name) {
        return this.watchesByName.get(name);
    }

    @Override
    public void addWatch(Watch watch) {
        Series series;
        Watch existing;
        if (this.watchConfig.isDisabled(watch.name)) {
            watch.disable();
        }
        if ((existing = this.watchesByName.put(watch.name, watch)) != null) {
            this.removeWatch(existing);
        }
        Map<Series, Map<String, Watch>> target = (series = watch.watched.series).isPattern() ? this.patternWatches : this.simpleWatches;
        target.computeIfAbsent(series, key -> new ConcurrentHashMap()).put(watch.name, watch);
        if (!watch.isProgrammatic()) {
            this.watchConfig.add(watch.name, watch.toJSON().toString());
        }
    }

    @Override
    public void removeWatch(Watch watch) {
        watch.stop();
        String name = watch.name;
        if (this.watchesByName.get(name) == watch) {
            this.watchesByName.remove(name);
            Map<String, Watch> collectedByInstance = this.collectedWatchesByInstance.get(this.instance);
            if (collectedByInstance != null) {
                collectedByInstance.remove(name);
            }
            InMemoryAlarmService.removeWatch(watch, this.simpleWatches);
            InMemoryAlarmService.removeWatch(watch, this.patternWatches);
            if (!watch.isProgrammatic()) {
                this.watchConfig.remove(watch.name);
            }
        }
    }

    private static void removeWatch(Watch watch, Map<Series, Map<String, Watch>> map) {
        String name = watch.name;
        Iterator<Map.Entry<Series, Map<String, Watch>>> iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Series, Map<String, Watch>> entry = iter.next();
            Map<String, Watch> watches = entry.getValue();
            if (watches.get(name) != watch) continue;
            watches.remove(name);
            if (watches.isEmpty()) {
                iter.remove();
            }
            return;
        }
    }

    @Override
    public Collection<Watch> watches() {
        ArrayList<Watch> all = new ArrayList<Watch>();
        for (Map<String, Watch> watches : this.simpleWatches.values()) {
            all.addAll(watches.values());
        }
        for (Map<String, Watch> watches : this.patternWatches.values()) {
            all.addAll(watches.values());
        }
        return all;
    }

    @Override
    public Collection<Watch> wachtesFor(Series series) {
        if (!series.isPattern()) {
            Map<String, Watch> watches = this.simpleWatches.get(series);
            return watches == null ? Collections.emptyList() : Collections.unmodifiableCollection(watches.values());
        }
        if (series.equalTo(Series.ANY)) {
            return this.watches();
        }
        Map<String, Watch> seriesWatches = this.patternWatches.get(series);
        Collection<Object> watches = seriesWatches == null ? Collections.emptyList() : seriesWatches.values();
        for (Map<String, Watch> simple : this.simpleWatches.values()) {
            for (Watch w : simple.values()) {
                if (!series.matches(w.watched.series)) continue;
                if (!(watches instanceof ArrayList)) {
                    watches = new ArrayList<Object>(watches);
                }
                watches.add(w);
            }
        }
        return Collections.unmodifiableCollection(watches);
    }

    private void checkWatches() {
        long start = System.currentTimeMillis();
        try {
            this.collectWatches();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to collect watches", ex);
        }
        if (this.isDAS) {
            try {
                this.checkWatches(this.simpleWatches.values());
                this.checkWatches(this.patternWatches.values());
                this.statistics.set(this.computeStatistics());
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Failed to check watches", ex);
            }
        } else {
            Map<String, Watch> instanceWachtes = this.collectedWatchesByInstance.get(this.instance);
            this.sendMessage(new WatchesSnapshot(this.instance, (Watch[])instanceWachtes.values().stream().toArray(Watch[]::new)));
        }
        this.evalLoopTime.set(System.currentTimeMillis() - start);
    }

    private void sendMessage(WatchesSnapshot msg) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(bos);){
            oos.writeObject(msg);
            oos.flush();
            this.runtime.send(bos.toByteArray());
        }
        catch (IOException ex) {
            LOGGER.log(Level.FINE, "Failed to send collected watches message", ex);
        }
    }

    private void collectWatches() {
        List<MonitoringWatchSource> sources = this.sources.get();
        final Map collectedBefore = this.collectedWatchesByInstance.computeIfAbsent(this.instance, key -> new ConcurrentHashMap());
        if (sources.isEmpty() && collectedBefore.isEmpty()) {
            return;
        }
        final HashSet notYetCollectedWatches = new HashSet(collectedBefore.keySet());
        MonitoringWatchCollector collector = new MonitoringWatchCollector(){

            public MonitoringWatchCollector.WatchBuilder watch(final CharSequence series, final String name, final String unit) {
                return new MonitoringWatchCollector.WatchBuilder(){

                    public MonitoringWatchCollector.WatchBuilder with(String level, long startThreshold, Number startForLast, boolean startOnAverage, Long stopTheshold, Number stopForLast, boolean stopOnAverage) {
                        Watch updated;
                        notYetCollectedWatches.remove(name);
                        Watch watch = (Watch)collectedBefore.get(name);
                        if (watch == null) {
                            Metric watched = new Metric(new Series(series.toString()), Unit.fromShortName(unit));
                            watch = new Watch(name, watched).programmatic();
                        }
                        if ((updated = watch.with(level, startThreshold, startForLast, startOnAverage, stopTheshold, stopForLast, stopOnAverage)) != watch) {
                            InMemoryAlarmService.this.addWatch(updated);
                            collectedBefore.put(name, updated);
                        }
                        return this;
                    }
                };
            }
        };
        for (MonitoringWatchSource source : sources) {
            try {
                source.collect(collector);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Failed to collect watch source " + source.getClass().getSimpleName(), ex);
            }
        }
        if (!notYetCollectedWatches.isEmpty()) {
            for (String name : notYetCollectedWatches) {
                this.removeWatch((Watch)collectedBefore.get(name));
                collectedBefore.remove(name);
            }
        }
    }

    private AlertService.AlertStatistics computeStatistics() {
        AlertService.AlertStatistics stats = new AlertService.AlertStatistics();
        stats.changeCount = Alert.getChangeCount();
        stats.watches = this.watchesByName.size();
        if (this.alerts.isEmpty()) {
            return stats;
        }
        for (Deque<Alert> seriesAlerts : this.alerts.values()) {
            for (Alert a : seriesAlerts) {
                if (a.getLevel() == Alert.Level.RED) {
                    if (a.isAcknowledged()) {
                        ++stats.acknowledgedRedAlerts;
                        continue;
                    }
                    ++stats.unacknowledgedRedAlerts;
                    continue;
                }
                if (a.getLevel() != Alert.Level.AMBER) continue;
                if (a.isAcknowledged()) {
                    ++stats.acknowledgedAmberAlerts;
                    continue;
                }
                ++stats.unacknowledgedAmberAlerts;
            }
        }
        return stats;
    }

    private void checkWatches(Collection<? extends Map<?, Watch>> watches) {
        for (Map<?, Watch> group : watches) {
            for (Watch watch : group.values()) {
                if (watch.isStopped()) {
                    this.removeWatch(watch);
                    continue;
                }
                try {
                    this.checkWatch(watch);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "Failed to check watch : " + watch, ex);
                }
            }
        }
    }

    private void checkWatch(Watch watch) {
        if (watch.isDisabled()) {
            return;
        }
        for (Alert newlyRaised : watch.check(this.monitoringData)) {
            Deque seriesAlerts = this.alerts.computeIfAbsent(newlyRaised.getSeries(), key -> new ConcurrentLinkedDeque());
            seriesAlerts.add(newlyRaised);
            InMemoryAlarmService.limitQueueSize(seriesAlerts);
        }
    }

    private static void limitQueueSize(Deque<Alert> seriesAlerts) {
        if (!(seriesAlerts.size() <= 10 || InMemoryAlarmService.removeFirst(seriesAlerts, alert -> alert.getLevel().isLessSevereThan(Alert.Level.AMBER)) || InMemoryAlarmService.removeFirst(seriesAlerts, Alert::isAcknowledged) || InMemoryAlarmService.removeFirst(seriesAlerts, alert -> alert.getLevel() == Alert.Level.AMBER))) {
            seriesAlerts.removeFirst();
        }
    }

    private static boolean removeFirst(Deque<Alert> alerts, Predicate<Alert> test) {
        Iterator<Alert> iter = alerts.iterator();
        while (iter.hasNext()) {
            Alert a = iter.next();
            if (!test.test(a)) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    public static final class WatchesSnapshot
    implements Serializable {
        final String instance;
        final Watch[] watches;

        WatchesSnapshot(String instance, Watch[] watches) {
            this.instance = instance;
            this.watches = watches;
        }
    }
}

