/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jmq.jmsservice.JMSServiceException;
import com.sun.messaging.jmq.jmsservice.JMSServiceReply;
import com.sun.messaging.jmq.util.XidImpl;
import com.sun.messaging.jms.ra.DirectConnection;
import com.sun.messaging.jms.ra.api.JMSRAResourceAdapter;
import com.sun.messaging.jms.ra.util.DirectXAResourceMap;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class DirectXAResource
implements XAResource {
    private JMSService jmsservice;
    private DirectConnection dc;
    private long connectionId;
    private long mTransactionId = 0L;
    private XidImpl mXid = null;
    private int id = 0;
    private boolean isEnlisted = false;
    private boolean usedByMDB = false;
    private HashMap<String, Long> transactionIds = null;
    private static final transient String _className = "com.sun.messaging.jms.ra.DirectXAResource";
    private static final transient String _lgrNameOutboundConnection = "javax.resourceadapter.mqjmsra.outbound.connection";
    private static final transient String _lgrNameJMSXAResource = "javax.resourceadapter.mqjmsra.xa";
    private static final transient Logger _loggerOC = Logger.getLogger("javax.resourceadapter.mqjmsra.outbound.connection");
    private static final transient Logger _loggerJX = Logger.getLogger("javax.resourceadapter.mqjmsra.xa");
    private static final transient String _lgrName = "com.sun.messaging.jms.ra.DirectXAResource";
    private static final transient Logger _logger = Logger.getLogger("com.sun.messaging.jms.ra.DirectXAResource");
    private static final transient String _lgrMIDPrefix = "MQJMSRA_DXA";
    private static final transient String _lgrMID_EET = "MQJMSRA_DXA1001: ";
    private static final transient String _lgrMID_INF = "MQJMSRA_DXA1101: ";
    private static final transient String _lgrMID_WRN = "MQJMSRA_DXA2001: ";
    private static final transient String _lgrMID_ERR = "MQJMSRA_DXA3001: ";
    private static final transient String _lgrMID_EXC = "MQJMSRA_DXA4001: ";
    private static int idCounter = 0;
    protected static final int _logLevel;
    protected static final boolean _logFINE;
    public static final int CREATED = 0;
    public static final int STARTED = 1;
    public static final int FAILED = 2;
    public static final int INCOMPLETE = 3;
    public static final int COMPLETE = 4;
    public static final int PREPARED = 5;
    private volatile int resourceState = 0;

    public DirectXAResource(DirectConnection dc, JMSService jmsservice, long connectionId) {
        Object[] params = new Object[]{dc, jmsservice, connectionId};
        _loggerOC.entering("com.sun.messaging.jms.ra.DirectXAResource", "constructor()", params);
        this.dc = dc;
        this.jmsservice = jmsservice;
        this.connectionId = dc.getConnectionId();
        this.isEnlisted = false;
        this.id = DirectXAResource.incrementIdCounter();
    }

    private static synchronized int incrementIdCounter() {
        return ++idCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void commit(Xid foreignXid, boolean onePhase) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("MQJMSRA_DXA1101: DirectXAResource (" + this.hashCode() + ") Commit  " + this.printXid(foreignXid) + " (onePhase=" + onePhase + "), connectionId=" + this.connectionId);
        }
        String methodName = "commit()";
        if (_logFINE) {
            _loggerJX.fine(_lgrMID_INF + methodName + ":onePhase=" + onePhase + ":transactionId=" + this.mTransactionId);
        }
        boolean rbrollback = false;
        JMSServiceException rbrollbackex = null;
        try {
            this.jmsservice.commitTransaction(this.connectionId, this.mTransactionId, foreignXid, onePhase ? 0x40000000 : 0);
            this.setEnlisted(false);
            if (_logFINE) {
                _loggerJX.fine(_lgrMID_INF + methodName + ":connectionId=" + this.connectionId + ":committed transactionId=" + this.mTransactionId);
            }
        }
        catch (JMSServiceException jse) {
            JMSServiceReply.Status status = jse.getJMSServiceReply().getStatus();
            String failure_cause = this.getFailureCauseAsString(status, jse);
            String exerrmsg = "commitTransaction (XA) on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + " and onePhase:" + onePhase + " due to " + failure_cause;
            _loggerOC.severe(exerrmsg);
            if (onePhase) {
                rbrollback = true;
                rbrollbackex = jse;
            }
            if (!rbrollback) {
                XAException xae = new XAException(-7);
                xae.initCause(jse);
                throw xae;
            }
        }
        finally {
            if (!rbrollback) {
                boolean throwExceptionIfNotFound = false;
                XidImpl savedXid = this.mXid;
                DirectXAResource[] resources = DirectXAResourceMap.getXAResources(this.mXid, throwExceptionIfNotFound);
                for (int i = 0; i < resources.length; ++i) {
                    DirectXAResource xari = resources[i];
                    try {
                        xari.clearTransactionInfo();
                        continue;
                    }
                    catch (JMSException jmse) {
                        _loggerJX.log(Level.SEVERE, "MQRA:DXAR:commit:XAException-Exception=" + jmse.getMessage(), jmse);
                        Debug.printStackTrace(jmse);
                        XAException xae = new XAException(-7);
                        xae.initCause(jmse);
                        throw xae;
                    }
                }
                DirectXAResourceMap.unregister(savedXid);
            }
        }
        if (rbrollback) {
            XAException xae;
            try {
                this.rollback(foreignXid, DirectXAResourceMap.MAXROLLBACKS, DirectXAResourceMap.DMQ_ON_MAXROLLBACKS);
                xae = new XAException(100);
                xae.initCause(rbrollbackex);
            }
            catch (Exception e) {
                _loggerJX.log(Level.SEVERE, "Exception on rollback transaction " + foreignXid + "[" + this.mTransactionId + "] after 1-phase-commit failure", e);
                xae = new XAException(-7);
                xae.initCause(rbrollbackex);
            }
            throw xae;
        }
    }

    private String getFailureCauseAsString(JMSServiceReply.Status status, JMSServiceException jse) {
        String failure_cause = jse.getCause() == null ? jse.toString() : jse.getCause().toString();
        switch (status) {
            case CONFLICT: {
                failure_cause = "CONFLICT: " + failure_cause;
                break;
            }
            default: {
                failure_cause = "Unknown JMSService server error " + status + ": " + failure_cause;
            }
        }
        return failure_cause;
    }

    public synchronized void clearTransactionInfo() throws JMSException {
        this.dc.deleteTemporaryDestinationsIfClosed();
        this.resourceState = 0;
        this.mTransactionId = 0L;
        this.mXid = null;
    }

    @Override
    public synchronized void end(Xid foreignXid, int flags) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("MQJMSRA_DXA1101: DirectXAResource (" + this.hashCode() + ") End     " + this.printXid(foreignXid) + this.printFlags(flags) + ", connectionId=" + this.connectionId);
        }
        String methodName = "end()";
        if (_logFINE) {
            _loggerJX.fine(_lgrMID_INF + methodName + ":flags=" + flags + ":transactionId=" + this.mTransactionId);
        }
        this.resourceState = this.isFail(flags) ? 2 : (this.isSuspend(flags) ? 3 : 4);
        if (JMSRAResourceAdapter.isRevert6882044()) {
            this.sendEndToBroker(foreignXid, flags);
        } else if (this.resourceState == 4) {
            boolean allComplete = true;
            DirectXAResource[] resources = DirectXAResourceMap.getXAResources(this.mXid, true);
            for (int i = 0; i < resources.length; ++i) {
                DirectXAResource xari = resources[i];
                if (xari.getResourceState() == 4) continue;
                allComplete = false;
            }
            if (allComplete) {
                this.sendEndToBroker(foreignXid, flags);
            }
        } else if (this.resourceState == 2) {
            this.sendEndToBroker(foreignXid, flags);
        }
        if (_logFINE) {
            _loggerJX.fine(_lgrMID_INF + methodName + ":connectionId=" + this.connectionId + ":ended transactionId=" + this.mTransactionId);
        }
    }

    public synchronized void sendEndToBroker(Xid foreignXid, int flags) throws XAException {
        String methodName = "endToBroker()";
        if (_logFINE) {
            _loggerJX.fine(_lgrMID_INF + methodName + ":flags=" + flags + ":transactionId=" + this.mTransactionId);
        }
        try {
            this.jmsservice.endTransaction(this.connectionId, this.mTransactionId, foreignXid, flags);
            if (_logFINE) {
                _loggerJX.fine(_lgrMID_INF + methodName + ":connectionId=" + this.connectionId + ":ended transactionId=" + this.mTransactionId);
            }
        }
        catch (JMSServiceException jse) {
            JMSServiceReply.Status status = jse.getJMSServiceReply().getStatus();
            String failure_cause = this.getFailureCauseAsString(status, jse);
            String exerrmsg = "endTransaction (XA) on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + " and flags=" + flags + " due to " + failure_cause;
            _loggerOC.severe(exerrmsg);
            XAException xae = new XAException(-3);
            xae.initCause(jse);
            throw xae;
        }
    }

    @Override
    public synchronized void forget(Xid foreignXid) throws XAException {
        if (_logFINE) {
            _loggerJX.warning("MQJMSRA_DXA1101: forget()UNSUPPORTED:Xid=" + foreignXid.toString() + ", connectionId=" + this.connectionId);
        }
        XidImpl xidToForget = new XidImpl(foreignXid);
        DirectXAResourceMap.unregister(xidToForget);
        if (this.mXid != null && this.mXid.equals(xidToForget)) {
            try {
                this.clearTransactionInfo();
            }
            catch (JMSException jmse) {
                _loggerJX.log(Level.SEVERE, "MQRA:DXAR:forget:XAException-Exception=" + jmse.getMessage(), jmse);
                Debug.printStackTrace(jmse);
                XAException xae = new XAException(-7);
                xae.initCause(jmse);
                throw xae;
            }
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        if (_logFINE) {
            _loggerJX.fine("MQJMSRA_DXA1101: getTransactionTimeout() = 0");
        }
        return 0;
    }

    private int getResourceState() {
        return this.resourceState;
    }

    @Override
    public boolean isSameRM(XAResource foreignXaRes) throws XAException {
        boolean result = JMSRAResourceAdapter.isSameRMAllowed() && foreignXaRes instanceof DirectXAResource;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("MQJMSRA_DXA1101: DirectXAResource (" + this.hashCode() + ") comparing with (" + foreignXaRes.hashCode() + ") result=" + result + ", connectionId=" + this.connectionId);
        }
        return result;
    }

    @Override
    public synchronized int prepare(Xid foreignXid) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("MQJMSRA_DXA1101: DirectXAResource (" + this.hashCode() + ") Prepare     " + this.printXid(foreignXid) + ", connectionId=" + this.connectionId);
        }
        String methodName = "prepare()";
        if (_logFINE) {
            _loggerJX.fine(_lgrMID_INF + methodName + ":transactionId=" + this.mTransactionId);
        }
        int result = 0;
        try {
            this.jmsservice.prepareTransaction(this.connectionId, this.mTransactionId, foreignXid);
            if (_logFINE) {
                _loggerJX.fine(_lgrMID_INF + methodName + ":connectionId=" + this.connectionId + ":prepared transactionId=" + this.mTransactionId);
            }
        }
        catch (JMSServiceException jse) {
            JMSServiceReply.Status status = jse.getJMSServiceReply().getStatus();
            String failure_cause = this.getFailureCauseAsString(status, jse);
            String exerrmsg = "prepareTransaction (XA) on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + " due to " + failure_cause;
            _loggerOC.severe(exerrmsg);
            XAException xae = new XAException(-3);
            xae.initCause(jse);
            throw xae;
        }
        this.resourceState = 5;
        return result;
    }

    @Override
    public Xid[] recover(int flags) throws XAException {
        if (_logFINE) {
            _loggerJX.fine("MQJMSRA_DXA1101: recover():flags=" + flags + ", connectionId=" + this.connectionId);
        }
        Xid[] result = null;
        try {
            result = this.jmsservice.recoverXATransactions(this.connectionId, flags);
        }
        catch (JMSServiceException jse) {
            JMSServiceReply.Status status = jse.getJMSServiceReply().getStatus();
            String failure_cause = this.getFailureCauseAsString(status, jse);
            String exerrmsg = "recoverXATransactions (XA) on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + " due to " + failure_cause;
            _loggerOC.severe(exerrmsg);
            XAException xae = new XAException(-3);
            xae.initCause(jse);
            throw xae;
        }
        return result;
    }

    @Override
    public synchronized void rollback(Xid foreignXid) throws XAException {
        this.rollback(foreignXid, -1, false);
    }

    private synchronized void rollback(Xid foreignXid, int maxRollbacks, boolean dmqOnMaxRollbacks) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("MQJMSRA_DXA1101: DirectXAResource (" + this.hashCode() + ") Rollback  " + this.printXid(foreignXid) + "), connectionId=" + this.connectionId);
        }
        String methodName = "rollback()";
        if (_logFINE) {
            _loggerJX.fine(_lgrMID_INF + methodName + ":transactionId=" + this.mTransactionId);
        }
        try {
            this.jmsservice.rollbackTransaction(this.connectionId, this.mTransactionId, foreignXid, true, true, maxRollbacks, dmqOnMaxRollbacks);
            this.setEnlisted(false);
            if (_logFINE) {
                _loggerJX.fine(_lgrMID_INF + methodName + ":connectionId=" + this.connectionId + ":rolled back transactionId=" + this.mTransactionId);
            }
        }
        catch (JMSServiceException jse) {
            JMSServiceReply.Status status = jse.getJMSServiceReply().getStatus();
            String failure_cause = this.getFailureCauseAsString(status, jse);
            String exerrmsg = "rollbackTransaction (XA) on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + ":transactionId=" + this.mTransactionId + " due to " + failure_cause;
            _loggerOC.severe(exerrmsg);
            XAException xae = new XAException(-3);
            xae.initCause(jse);
            throw xae;
        }
        finally {
            boolean throwExceptionIfNotFound = false;
            DirectXAResource[] resources = DirectXAResourceMap.getXAResources(this.mXid, throwExceptionIfNotFound);
            XidImpl savedXid = this.mXid;
            for (int i = 0; i < resources.length; ++i) {
                DirectXAResource xari = resources[i];
                try {
                    xari.clearTransactionInfo();
                    continue;
                }
                catch (JMSException jmse) {
                    _loggerJX.log(Level.SEVERE, "MQRA:DXAR:rollback:XAException-Exception=" + jmse.getMessage(), jmse);
                    Debug.printStackTrace(jmse);
                    XAException xae = new XAException(-7);
                    xae.initCause(jmse);
                    throw xae;
                }
            }
            DirectXAResourceMap.unregister(savedXid);
        }
    }

    @Override
    public boolean setTransactionTimeout(int transactionTimeout) throws XAException {
        if (_logFINE) {
            _loggerJX.fine("MQJMSRA_DXA1101: setTransactionTimeout()=" + transactionTimeout + ":returning false.");
        }
        return false;
    }

    @Override
    public synchronized void start(Xid foreignXid, int flags) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("MQJMSRA_DXA1101: DirectXAResource (" + this.hashCode() + ") Start   " + this.printXid(foreignXid) + this.printFlags(flags) + ", connectionId=" + this.connectionId);
        }
        String methodName = "start()";
        if (_logFINE) {
            _loggerJX.fine(_lgrMID_INF + methodName + ":flags=" + flags + ":connectioId=" + this.connectionId);
        }
        if (!this.isResume(flags) || JMSRAResourceAdapter.isRevert6882044()) {
            long transactionId = this.sendStartToBroker(foreignXid, flags);
            this.validateAndSaveXidTransactionID(foreignXid, transactionId);
            DirectXAResourceMap.register(this.mXid, this, this.isJoin(flags));
        }
        this.setEnlisted(true);
        if (_logFINE) {
            _loggerJX.fine(_lgrMID_INF + methodName + ":connectionId=" + this.connectionId + ":started transactionId=" + this.mTransactionId);
        }
    }

    private long sendStartToBroker(Xid foreignXid, int flags) throws XAException {
        long transactionId;
        try {
            JMSServiceReply reply = this.jmsservice.startTransaction(this.connectionId, 0L, foreignXid, flags, JMSService.TransactionAutoRollback.UNSPECIFIED, 0L);
            try {
                transactionId = reply.getJMQTransactionID();
            }
            catch (NoSuchFieldException nsfe) {
                String exerrmsg = "MQJMSRA_DXA4001: JMSServiceException:Missing JMQTransactionID";
                XAException xae = new XAException(-7);
                xae.initCause(nsfe);
                _loggerOC.severe(exerrmsg);
                throw xae;
            }
        }
        catch (JMSServiceException jse) {
            JMSServiceReply.Status status = jse.getJMSServiceReply().getStatus();
            String failure_cause = status == JMSServiceReply.Status.NOT_IMPLEMENTED ? "TransactionAutoRollback not implemented." : this.getFailureCauseAsString(status, jse);
            String exerrmsg = "startTransaction (XA) on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + " due to " + failure_cause;
            _loggerOC.severe(exerrmsg);
            XAException xae = new XAException(-7);
            xae.initCause(jse);
            throw xae;
        }
        return transactionId;
    }

    private synchronized void validateAndSaveXidTransactionID(Xid foreignXid, long transactionId) {
        assert (transactionId != 0L);
        if (this.mTransactionId == 0L && this.mXid == null) {
            this.mTransactionId = transactionId;
            this.mXid = new XidImpl(foreignXid);
        } else if (this.mXid.equals(foreignXid)) {
            if (this.mTransactionId != transactionId) {
                _loggerJX.log(Level.INFO, "DXAR:start():Warning: XAResource with state " + this.getStateAsString() + " received diff txId for same Xid:switching transactionId:\nDXAR TXid=" + this.mTransactionId + "\ngot  TXid=" + transactionId + "\nFor   Xid=" + this.printXid(this.mXid));
                this.mTransactionId = transactionId;
            }
        } else {
            _loggerJX.log(Level.INFO, "DXAR:start():Warning: XAResource with state " + this.getStateAsString() + " received diff Xid for open txnId:switching transactionId:\nDXAR  Xid=" + this.printXid(this.mXid) + "\nDXAR TXid=" + this.mTransactionId + "\ngot   Xid=" + this.printXid(foreignXid) + "\ngot  TXid=" + transactionId);
            this.mTransactionId = transactionId;
            this.mXid = new XidImpl(foreignXid);
        }
    }

    public synchronized void setEnlisted(boolean value) {
        this.isEnlisted = value;
        if (!this.usedByMDB && this.dc != null) {
            this.dc.setEnlisted(value);
        }
    }

    protected void _setUsedByMDB(boolean value) {
        this.usedByMDB = value;
    }

    public synchronized boolean isEnlisted() {
        return this.isEnlisted;
    }

    public synchronized void setRollback(boolean state, Throwable cause) {
    }

    public int _getId() {
        return this.id;
    }

    public long _getTransactionId() {
        return this.mTransactionId;
    }

    private String printXid(Xid foreignXid) {
        return "(GlobalTransactionID=" + foreignXid.getGlobalTransactionId() + ", BranchQualifier=" + foreignXid.getBranchQualifier() + ") ";
    }

    private boolean isJoin(int flags) {
        return (flags & 0x200000) == 0x200000;
    }

    private boolean isResume(int flags) {
        return (flags & 0x8000000) == 0x8000000;
    }

    private boolean isNoFlags(int flags) {
        return (flags & 0) == 0;
    }

    private boolean isFail(int flags) {
        return (flags & 0x20000000) == 0x20000000;
    }

    private boolean isOnePhase(int flags) {
        return (flags & 0x40000000) == 0x40000000;
    }

    private boolean isSuccess(int flags) {
        return (flags & 0x4000000) == 0x4000000;
    }

    private boolean isSuspend(int flags) {
        return (flags & 0x2000000) == 0x2000000;
    }

    private boolean isTMENDRSCAN(int flags) {
        return (flags & 0x800000) == 0x800000;
    }

    private boolean TMSTARTRSCAN(int flags) {
        return (flags & 0x1000000) == 0x1000000;
    }

    private String printFlags(int flags) {
        String result = "(Flags: ";
        if (this.isJoin(flags)) {
            result = result + "JOIN ";
        }
        if (this.isNoFlags(flags)) {
            result = result + "TMNOFLAGS ";
        }
        if (this.isFail(flags)) {
            result = result + "TMFAIL ";
        }
        if (this.isOnePhase(flags)) {
            result = result + "TMONEPHASE ";
        }
        if (this.isResume(flags)) {
            result = result + "TMRESUME ";
        }
        if (this.isSuccess(flags)) {
            result = result + "TMSUCCESS ";
        }
        if (this.isSuspend(flags)) {
            result = result + "TMSUSPEND ";
        }
        if (this.isTMENDRSCAN(flags)) {
            result = result + "TMENDRSCAN ";
        }
        if (this.TMSTARTRSCAN(flags)) {
            result = result + "TMSTARTRSCAN ";
        }
        result = result + ")";
        return result;
    }

    private String getStateAsString() {
        switch (this.getResourceState()) {
            case 0: {
                return "CREATED";
            }
            case 1: {
                return "STARTED";
            }
            case 2: {
                return "FAILED";
            }
            case 3: {
                return "INCOMPLETE";
            }
            case 4: {
                return "COMPLETE";
            }
            case 5: {
                return "PREPARED";
            }
        }
        return Integer.toString(this.getResourceState());
    }

    static {
        Level _level = _loggerJX.getLevel();
        int tmplevel = Level.INFO.intValue();
        boolean tmplogfine = false;
        if (_level != null && (tmplevel = _level.intValue()) <= Level.FINE.intValue()) {
            tmplogfine = true;
        }
        _logLevel = tmplevel;
        _logFINE = tmplogfine;
    }
}

