/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.full.admingui.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import org.glassfish.admingui.common.util.GuiUtil;

public class BatchHandlers {
    private static final int DEFAULT_OFFSET_INCREMENT = 20;
    private static final String OFFSET = "offset";
    private static final String NUMBER_FORMAT_EXCEPTION_MESSAGE = "Value isn't a valid integer ";
    private static final String RESULT = "result";

    public static void addToOffSetValue(HandlerContext handlerCtx) {
        String offsetValue = (String)handlerCtx.getInputValue(OFFSET);
        int result = 0;
        try {
            result = Integer.parseInt(offsetValue) + 20;
        }
        catch (NumberFormatException ex) {
            GuiUtil.getLogger().info(NUMBER_FORMAT_EXCEPTION_MESSAGE + ex);
        }
        handlerCtx.setOutputValue(RESULT, (Object)result);
    }

    public static void subtractFromOffSetValue(HandlerContext handlerCtx) {
        String offsetValue = (String)handlerCtx.getInputValue(OFFSET);
        int result = 0;
        try {
            result = Integer.parseInt(offsetValue);
            result = result >= 20 ? (result -= 20) : 0;
        }
        catch (NumberFormatException ex) {
            GuiUtil.getLogger().info(NUMBER_FORMAT_EXCEPTION_MESSAGE + ex);
        }
        handlerCtx.setOutputValue(RESULT, (Object)result);
    }

    public static void getPageNumber(HandlerContext handlerCtx) {
        String offsetValue = (String)handlerCtx.getInputValue(OFFSET);
        int result = 0;
        try {
            int offSet = Integer.parseInt(offsetValue);
            result = (offSet + 20) / 20;
        }
        catch (NumberFormatException ex) {
            GuiUtil.getLogger().info(NUMBER_FORMAT_EXCEPTION_MESSAGE + ex);
        }
        handlerCtx.setOutputValue(RESULT, (Object)result);
    }

    public static void getSpecifiedPageNumber(HandlerContext handlerCtx) {
        String pageNumberValue = (String)handlerCtx.getInputValue("pageNumber");
        int result = 0;
        try {
            int pageNumber = Integer.parseInt(pageNumberValue);
            if (pageNumber > 0) {
                result = pageNumber * 20 - 20;
            }
        }
        catch (NumberFormatException ex) {
            GuiUtil.getLogger().info(NUMBER_FORMAT_EXCEPTION_MESSAGE + ex);
        }
        handlerCtx.setOutputValue(RESULT, (Object)result);
    }

    public static void getPageCount(HandlerContext handlerCtx) {
        String jobCountValue = (String)handlerCtx.getInputValue("jobCount");
        int result = 1;
        try {
            int jobCount = Integer.parseInt(jobCountValue);
            if (jobCount > 0) {
                result = (jobCount + 20 - 1) / 20;
            }
        }
        catch (NumberFormatException ex) {
            GuiUtil.getLogger().info(NUMBER_FORMAT_EXCEPTION_MESSAGE + ex);
        }
        handlerCtx.setOutputValue(RESULT, (Object)result);
    }
}

