/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.invocation;

import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.api.invocation.ApplicationEnvironment;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.ComponentInvocationHandler;
import org.glassfish.api.invocation.InvocationException;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.invocation.RegisteredComponentInvocationHandler;
import org.glassfish.hk2.api.IterableProvider;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class InvocationManagerImpl
implements InvocationManager {
    private static final Logger LOGGER = Logger.getLogger(InvocationManagerImpl.class.getName());
    private final InheritableThreadLocal<InvocationFrames> framesByThread;
    private final ThreadLocal<Deque<ApplicationEnvironment>> appEnvironments = ThreadLocal.withInitial(ArrayDeque::new);
    private final ThreadLocal<Deque<Method>> webServiceMethods = ThreadLocal.withInitial(ArrayDeque::new);
    private final ConcurrentMap<ComponentInvocation.ComponentInvocationType, ListComponentInvocationHandler> typeHandlers = new ConcurrentHashMap<ComponentInvocation.ComponentInvocationType, ListComponentInvocationHandler>();
    private final ComponentInvocationHandler allTypesHandler;

    public InvocationManagerImpl() {
        this(new ComponentInvocationHandler[]{null});
    }

    public InvocationManagerImpl(ComponentInvocationHandler ... handlers) {
        this(Arrays.asList(handlers));
    }

    @Inject
    private InvocationManagerImpl(@Optional IterableProvider<ComponentInvocationHandler> handlers) {
        this((Iterable<ComponentInvocationHandler>)handlers);
    }

    private InvocationManagerImpl(Iterable<ComponentInvocationHandler> handlers) {
        this.allTypesHandler = InvocationManagerImpl.initInvocationHandlers(handlers);
        this.framesByThread = new InheritableThreadLocal<InvocationFrames>(){

            @Override
            protected InvocationFrames initialValue() {
                return new InvocationFrames();
            }

            @Override
            protected InvocationFrames childValue(InvocationFrames parentValue) {
                return InvocationManagerImpl.computeChildTheadInvocation(parentValue);
            }
        };
    }

    private static ComponentInvocationHandler initInvocationHandlers(Iterable<ComponentInvocationHandler> handlers) {
        if (handlers == null) {
            return null;
        }
        ArrayList<ComponentInvocationHandler> hs = new ArrayList<ComponentInvocationHandler>();
        handlers.forEach(hs::add);
        if (hs.isEmpty()) {
            return null;
        }
        if (hs.size() == 1) {
            return (ComponentInvocationHandler)hs.get(0);
        }
        return new ListComponentInvocationHandler(hs);
    }

    @Override
    public void setThreadInheritableInvocation(List<? extends ComponentInvocation> parentValue) {
        this.framesByThread.set(InvocationManagerImpl.computeChildTheadInvocation(InvocationFrames.valueOf(parentValue)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ComponentInvocation> void preInvoke(T invocation) throws InvocationException {
        InvocationFrames frames = (InvocationFrames)this.framesByThread.get();
        if (invocation.getInvocationType() == ComponentInvocation.ComponentInvocationType.SERVICE_STARTUP) {
            frames.setState(ComponentInvocation.ComponentInvocationType.SERVICE_STARTUP);
            return;
        }
        ComponentInvocation prev = (ComponentInvocation)frames.peekLast();
        ComponentInvocation.ComponentInvocationType type = invocation.getInvocationType();
        ComponentInvocationHandler typeHandler = (ComponentInvocationHandler)this.typeHandlers.get((Object)type);
        try {
            if (this.allTypesHandler != null) {
                this.allTypesHandler.beforePreInvoke(type, prev, invocation);
            }
            if (typeHandler != null) {
                typeHandler.beforePreInvoke(type, prev, invocation);
            }
        }
        finally {
            frames.addLast(invocation);
            if (this.allTypesHandler != null) {
                this.allTypesHandler.afterPreInvoke(type, prev, invocation);
            }
            if (typeHandler != null) {
                typeHandler.afterPreInvoke(type, prev, invocation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ComponentInvocation> void postInvoke(T invocation) throws InvocationException {
        InvocationFrames frames = (InvocationFrames)this.framesByThread.get();
        if (invocation.getInvocationType() == ComponentInvocation.ComponentInvocationType.SERVICE_STARTUP) {
            frames.setState(ComponentInvocation.ComponentInvocationType.UN_INITIALIZED);
            return;
        }
        Iterator iter = frames.descendingIterator();
        if (!iter.hasNext()) {
            throw new InvocationException("No invocation on invocation stack. Expected invocation: " + invocation);
        }
        ComponentInvocation current = (ComponentInvocation)iter.next();
        if (InvocationManagerImpl.isInconsistentUse(invocation, current)) {
            LOGGER.log(Level.WARNING, "postInvoke not called with top of the invocation stack. Expected:\n{0}\nbut was:\n{1}", new Object[]{current, invocation});
            LOGGER.log(Level.FINE, "Stacktrace: ", new IllegalStateException("This exception is not thrown, it is only to trace the invocation"));
        }
        ComponentInvocation prev = iter.hasNext() ? (ComponentInvocation)iter.next() : null;
        ComponentInvocation.ComponentInvocationType type = invocation.getInvocationType();
        ComponentInvocationHandler typeHandler = (ComponentInvocationHandler)this.typeHandlers.get((Object)type);
        try {
            if (this.allTypesHandler != null) {
                this.allTypesHandler.beforePostInvoke(type, prev, current);
            }
            if (typeHandler != null) {
                typeHandler.beforePostInvoke(type, prev, current);
            }
        }
        finally {
            frames.removeLast();
            if (this.allTypesHandler != null) {
                this.allTypesHandler.afterPostInvoke(type, prev, current);
            }
            if (typeHandler != null) {
                typeHandler.afterPostInvoke(type, prev, current);
            }
        }
    }

    private static boolean isInconsistentUse(ComponentInvocation a, ComponentInvocation b) {
        if (a == null || b == null) {
            return a != b;
        }
        if (a.getClass() != b.getClass()) {
            return true;
        }
        return a != b && !a.getClass().getSimpleName().equals("WebComponentInvocation");
    }

    @Override
    public boolean isInvocationStackEmpty() {
        InvocationFrames invocations = (InvocationFrames)this.framesByThread.get();
        return invocations == null || invocations.isEmpty();
    }

    @Override
    public <T extends ComponentInvocation> T getCurrentInvocation() {
        return (T)((ComponentInvocation)((InvocationFrames)this.framesByThread.get()).peekLast());
    }

    @Override
    public <T extends ComponentInvocation> T getPreviousInvocation() throws InvocationException {
        Iterator iter = ((InvocationFrames)this.framesByThread.get()).descendingIterator();
        if (!iter.hasNext()) {
            return null;
        }
        iter.next();
        if (!iter.hasNext()) {
            return null;
        }
        return (T)((ComponentInvocation)iter.next());
    }

    @Override
    public List<? extends ComponentInvocation> getAllInvocations() {
        InvocationFrames frames = (InvocationFrames)this.framesByThread.get();
        return frames == null ? Collections.emptyList() : new ArrayList<ComponentInvocation>(frames);
    }

    @Override
    public List<? extends ComponentInvocation> popAllInvocations() {
        List<? extends ComponentInvocation> result = this.getAllInvocations();
        this.framesByThread.set(null);
        return result;
    }

    @Override
    public void putAllInvocations(List<? extends ComponentInvocation> invocations) {
        this.framesByThread.set(InvocationFrames.valueOf(invocations));
    }

    static InvocationFrames computeChildTheadInvocation(InvocationFrames parent) {
        InvocationFrames childFrames = new InvocationFrames();
        InvocationFrames parentFrames = parent;
        if (parentFrames != null && !parentFrames.isEmpty() && !parentFrames.isStartup()) {
            ComponentInvocation parentFrame = (ComponentInvocation)parentFrames.getLast();
            ComponentInvocation.ComponentInvocationType parentType = parentFrame.getInvocationType();
            if (parentType == ComponentInvocation.ComponentInvocationType.SERVLET_INVOCATION) {
                ComponentInvocation invocation = new ComponentInvocation();
                invocation.setComponentInvocationType(parentType);
                invocation.setComponentId(parentFrame.getComponentId());
                invocation.setAppName(parentFrame.getAppName());
                invocation.setModuleName(parentFrame.getModuleName());
                invocation.setContainer(parentFrame.getContainer());
                invocation.setJndiEnvironment(parentFrame.getJndiEnvironment());
                childFrames.add(invocation);
            } else if (parentType != ComponentInvocation.ComponentInvocationType.EJB_INVOCATION) {
                childFrames.add(new ComponentInvocation(parentFrame.getComponentId(), parentType, parentFrame.getInstance(), parentFrame.getContainerContext(), parentFrame.getTransaction()));
            }
        }
        return childFrames;
    }

    @Override
    public void registerComponentInvocationHandler(ComponentInvocation.ComponentInvocationType type, RegisteredComponentInvocationHandler handler) {
        this.typeHandlers.computeIfAbsent(type, key -> new ListComponentInvocationHandler(new CopyOnWriteArrayList<ComponentInvocationHandler>())).add(handler.getComponentInvocationHandler());
    }

    @Override
    public void pushAppEnvironment(ApplicationEnvironment env) {
        this.appEnvironments.get().addLast(env);
    }

    @Override
    public ApplicationEnvironment peekAppEnvironment() {
        return this.appEnvironments.get().peekLast();
    }

    @Override
    public void popAppEnvironment() {
        this.appEnvironments.get().pollLast();
    }

    @Override
    public void pushWebServiceMethod(Method method) {
        this.webServiceMethods.get().addLast(method);
    }

    @Override
    public Method peekWebServiceMethod() {
        return this.webServiceMethods.get().peekLast();
    }

    @Override
    public void popWebServiceMethod() {
        this.webServiceMethods.get().pollLast();
    }

    private static final class ListComponentInvocationHandler
    implements ComponentInvocationHandler {
        private final List<ComponentInvocationHandler> handlers;

        ListComponentInvocationHandler(List<ComponentInvocationHandler> handlers) {
            this.handlers = handlers;
        }

        void add(ComponentInvocationHandler handler) {
            this.handlers.add(handler);
        }

        @Override
        public void beforePreInvoke(ComponentInvocation.ComponentInvocationType type, ComponentInvocation prev, ComponentInvocation cur) throws InvocationException {
            this.handlers.forEach(handler -> handler.beforePreInvoke(type, prev, cur));
        }

        @Override
        public void afterPreInvoke(ComponentInvocation.ComponentInvocationType type, ComponentInvocation prev, ComponentInvocation cur) throws InvocationException {
            this.handlers.forEach(handler -> handler.afterPreInvoke(type, prev, cur));
        }

        @Override
        public void beforePostInvoke(ComponentInvocation.ComponentInvocationType type, ComponentInvocation prev, ComponentInvocation cur) throws InvocationException {
            this.handlers.forEach(handler -> handler.beforePostInvoke(type, prev, cur));
        }

        @Override
        public void afterPostInvoke(ComponentInvocation.ComponentInvocationType type, ComponentInvocation prev, ComponentInvocation cur) throws InvocationException {
            this.handlers.forEach(handler -> handler.afterPostInvoke(type, prev, cur));
        }
    }

    static final class InvocationFrames
    extends ArrayDeque<ComponentInvocation> {
        private static final long serialVersionUID = 1L;
        private ComponentInvocation.ComponentInvocationType state;

        static InvocationFrames valueOf(Collection<? extends ComponentInvocation> invocations) {
            return invocations instanceof InvocationFrames ? (InvocationFrames)invocations : new InvocationFrames((Collection<? extends ComponentInvocation>)(invocations == null ? Collections.emptyList() : invocations));
        }

        private InvocationFrames(Collection<? extends ComponentInvocation> invocations) {
            super(invocations);
        }

        InvocationFrames() {
        }

        void setState(ComponentInvocation.ComponentInvocationType state) {
            this.state = state;
        }

        boolean isStartup() {
            return this.state == ComponentInvocation.ComponentInvocationType.SERVICE_STARTUP;
        }
    }
}

