/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.loader;

import com.sun.appserv.server.util.PreprocessorUtil;
import com.sun.enterprise.loader.CurrentBeforeParentClassLoader;
import com.sun.enterprise.loader.DirWatcher;
import com.sun.enterprise.loader.JasperAdapter;
import com.sun.enterprise.security.integration.DDPermissionsLoader;
import com.sun.enterprise.security.integration.PermsHolder;
import com.sun.enterprise.util.CULoggerInfo;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.glassfish.api.deployment.InstrumentableClassLoader;
import org.glassfish.hk2.api.PreDestroy;

public class ASURLClassLoader
extends CurrentBeforeParentClassLoader
implements JasperAdapter,
InstrumentableClassLoader,
PreDestroy,
DDPermissionsLoader {
    private static final Logger _logger = CULoggerInfo.getLogger();
    private final Set<URLEntry> urlSet = Collections.synchronizedSet(new LinkedHashSet());
    private final Map<String, String> notFoundResources = new ConcurrentHashMap<String, String>();
    private final Map<String, String> notFoundClasses = new ConcurrentHashMap<String, String>();
    private volatile boolean doneCalled = false;
    private volatile String doneSnapshot;
    private final List<SentinelInputStream> streams = new CopyOnWriteArrayList<SentinelInputStream>();
    private final ArrayList<ClassFileTransformer> transformers = new ArrayList(1);
    private static final StringManager sm = StringManager.getManager(ASURLClassLoader.class);
    private final PermsHolder permissionsHolder = new PermsHolder();
    private boolean warnedOnce = false;

    public ASURLClassLoader() {
        super(new URL[0]);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "ClassLoader: {0} is getting created.", this);
        }
    }

    public ASURLClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    public boolean isDone() {
        return this.doneCalled;
    }

    public void preDestroy() {
        this.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        if (this.doneCalled) {
            return;
        }
        ASURLClassLoader aSURLClassLoader = this;
        synchronized (aSURLClassLoader) {
            if (this.doneCalled) {
                return;
            }
            this.doneSnapshot = "ASURLClassLoader.done() called ON " + this.toString() + "\n AT " + new Date() + " \n BY :" + Arrays.toString(Thread.currentThread().getStackTrace());
            this.doneCalled = true;
            for (URLEntry u : this.urlSet) {
                u.close();
            }
            this.closeOpenStreams();
            this.urlSet.clear();
            this.notFoundResources.clear();
            this.notFoundClasses.clear();
        }
    }

    public void appendURL(File file) throws IOException {
        try {
            this.appendURL(file.toURI().toURL());
        }
        catch (MalformedURLException mue) {
            _logger.log(Level.SEVERE, CULoggerInfo.getString("NCLS-COMUTIL-00011", file.toURI()), mue);
            throw new IOException(mue);
        }
    }

    @Override
    public void addURL(URL url) {
        this.appendURL(url);
    }

    public synchronized void appendURL(URL url) {
        try {
            if (url == null) {
                _logger.log(Level.INFO, "NCLS-COMUTIL-00012");
                return;
            }
            URLEntry entry = new URLEntry(url);
            if (!this.urlSet.contains(entry)) {
                this.urlSet.add(entry);
                if (entry.isJar) {
                    this.checkManifest(entry.zip, entry.file);
                }
            } else {
                _logger.log(Level.FINE, "[ASURLClassLoader] Ignoring duplicate URL: {0}", url);
                if (entry.zip != null) {
                    try {
                        entry.zip.reallyClose();
                    }
                    catch (IOException ioe) {
                        _logger.log(Level.INFO, CULoggerInfo.getString("NCLS-COMUTIL-00013", url), ioe);
                    }
                }
            }
            this.clearNotFoundCaches();
        }
        catch (IOException ioe) {
            _logger.log(Level.SEVERE, CULoggerInfo.getString("NCLS-COMUTIL-00011", url), ioe);
        }
    }

    @Override
    public synchronized URL[] getURLs() {
        return (URL[])this.urlSet.stream().map(u -> u.source).toArray(URL[]::new);
    }

    public String getClasspath() {
        List files;
        URL[] urls = this.getURLs();
        if (urls != null && !(files = Arrays.stream(urls).filter(url -> url.getProtocol().equals("file")).map(URL::getFile).collect(Collectors.toList())).isEmpty()) {
            return String.join((CharSequence)File.pathSeparator, files);
        }
        return null;
    }

    public synchronized void refresh() {
        this.clearNotFoundCaches();
    }

    public void addTransformer(ClassFileTransformer transformer) {
        this.transformers.add(transformer);
    }

    public ClassLoader copy() {
        ASURLClassLoader copyFrom = this;
        return AccessController.doPrivileged(() -> new DelegatingClassLoader(copyFrom));
    }

    private void clearNotFoundCaches() {
        this.notFoundResources.clear();
        this.notFoundClasses.clear();
    }

    private URL findResource0(URLEntry res, String name) {
        return AccessController.doPrivileged(() -> {
            if (res.isJar) {
                try {
                    JarEntry jarEntry = res.zip.getJarEntry(name);
                    if (jarEntry != null) {
                        InternalURLStreamHandler handler = new InternalURLStreamHandler(res, name);
                        URL ret = new URL("jar", null, -1, res.source + "!/" + name, handler);
                        handler.tieUrl(ret);
                        return ret;
                    }
                }
                catch (Throwable thr) {
                    _logger.log(Level.INFO, "NCLS-COMUTIL-00014", thr);
                }
            } else {
                try {
                    File resourceFile = new File(res.file.getCanonicalPath() + File.separator + name);
                    if (resourceFile.exists()) {
                        return resourceFile.toURI().toURL();
                    }
                }
                catch (IOException e) {
                    _logger.log(Level.INFO, "NCLS-COMUTIL-00014", e);
                }
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL findResource(String name) {
        if (this.doneCalled) {
            _logger.log(Level.WARNING, CULoggerInfo.getString("NCLS-COMUTIL-00015", name, this.toString()), new Throwable());
            return null;
        }
        String nf = this.notFoundResources.get(name);
        if (nf != null && nf.equals(name)) {
            return null;
        }
        ASURLClassLoader aSURLClassLoader = this;
        synchronized (aSURLClassLoader) {
            for (URLEntry u : this.urlSet) {
                URL url;
                if (!u.hasItem(name) || (url = this.findResource0(u, name)) == null) continue;
                return url;
            }
        }
        this.notFoundResources.put(name, name);
        return null;
    }

    @Override
    public synchronized Enumeration<URL> findResources(String name) {
        if (this.doneCalled) {
            if (this.warnedOnce) {
                _logger.log(Level.FINE, "NCLS-COMUTIL-00016", new Object[]{name, this.doneSnapshot});
            } else {
                _logger.log(Level.WARNING, "NCLS-COMUTIL-00016", new Object[]{name, this.doneSnapshot});
                this.warnedOnce = true;
            }
            return Collections.emptyEnumeration();
        }
        ArrayList<URL> resourcesList = new ArrayList<URL>();
        String nf = this.notFoundResources.get(name);
        if (nf != null && nf.equals(name)) {
            return Collections.enumeration(resourcesList);
        }
        for (URLEntry urlEntry : this.urlSet) {
            URL url = this.findResource0(urlEntry, name);
            if (url == null) continue;
            resourcesList.add(url);
        }
        if (resourcesList.isEmpty()) {
            this.notFoundResources.put(name, name);
        }
        return Collections.enumeration(resourcesList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkManifest(JarFile jar, File file) throws IOException {
        if (jar == null || file == null) {
            return;
        }
        Manifest man = jar.getManifest();
        if (man == null) {
            return;
        }
        ASURLClassLoader aSURLClassLoader = this;
        synchronized (aSURLClassLoader) {
            String cp = man.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            if (cp == null) {
                return;
            }
            StringTokenizer st = new StringTokenizer(cp, " ");
            while (st.hasMoreTokens()) {
                String entry = st.nextToken();
                File newFile = new File(file.getParentFile(), entry);
                try {
                    if (!newFile.exists()) continue;
                    this.appendURL(newFile);
                }
                catch (MalformedURLException ex) {
                    _logger.log(Level.SEVERE, "NCLS-COMUTIL-00014", ex);
                }
            }
        }
    }

    private byte[] loadClassData0(URLEntry res, String entryName) {
        return AccessController.doPrivileged(() -> {
            try {
                if (res.isJar) {
                    ProtectedJarFile zip = res.zip;
                    JarEntry entry = zip.getJarEntry(entryName);
                    if (entry == null) return null;
                    InputStream classStream2 = zip.getInputStream(entry);
                    byte[] classData = this.getClassData(classStream2);
                    res.setProtectionDomain(this, entry.getCertificates());
                    return classData;
                }
                File classFile = new File(res.file, entryName.replace('/', File.separatorChar));
                if (!classFile.exists()) return null;
                try (FileInputStream classStream = new FileInputStream(classFile);){
                    byte[] classData = this.getClassData(classStream);
                    res.setProtectionDomain(this, null);
                    byte[] byArray = classData;
                    return byArray;
                }
            }
            catch (IOException ioe) {
                _logger.log(Level.INFO, "NCLS-COMUTIL-00014", ioe);
            }
            return null;
        });
    }

    @Override
    public void addEEPermissions(PermissionCollection eePc) throws SecurityException {
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkSecurityAccess("createPolicy.eepermissions");
            this.permissionsHolder.setEEPermissions(eePc);
        }
    }

    @Override
    public void addDeclaredPermissions(PermissionCollection declaredPc) throws SecurityException {
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkSecurityAccess("createPolicy.eepermissions");
            this.permissionsHolder.setDeclaredPermissions(declaredPc);
        }
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection cachedPc = this.permissionsHolder.getCachedPerms(codeSource);
        if (cachedPc != null) {
            return cachedPc;
        }
        return this.permissionsHolder.getPermissions(codeSource, super.getPermissions(codeSource));
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        String packageName;
        int lastPackageSep;
        ClassData classData = this.findClassData(name);
        if (PreprocessorUtil.isPreprocessorEnabled()) {
            String entryName = name.replace('.', '/') + ".class";
            classData.setClassBytes(PreprocessorUtil.processClass(entryName, classData.getClassBytes()));
        }
        if ((lastPackageSep = name.lastIndexOf(46)) != -1 && this.getPackage(packageName = name.substring(0, lastPackageSep)) == null) {
            try {
                this.definePackage(packageName, null, null, null, null, null, null, null);
            }
            catch (IllegalArgumentException iae) {
                _logger.log(Level.FINE, "duplicate package definition attempt for " + packageName, iae);
            }
        }
        try {
            ArrayList xformers = (ArrayList)this.transformers.clone();
            for (ClassFileTransformer transformer : xformers) {
                String internalClassName;
                byte[] transformedBytes = transformer.transform(this, internalClassName = name.replace('.', '/'), null, classData.pd, classData.getClassBytes());
                if (transformedBytes == null) continue;
                _logger.log(Level.INFO, "NCLS-COMUTIL-00017", name);
                classData.setClassBytes(transformedBytes);
            }
        }
        catch (IllegalClassFormatException icfEx) {
            throw new ClassNotFoundException(icfEx.toString(), icfEx);
        }
        try {
            byte[] bytes = classData.getClassBytes();
            return this.defineClass(name, bytes, 0, bytes.length, classData.pd);
        }
        catch (UnsupportedClassVersionError ucve) {
            throw new UnsupportedClassVersionError(sm.getString("ejbClassLoader.unsupportedVersion", name, System.getProperty("java.version")));
        }
    }

    protected synchronized ClassData findClassData(String name) throws ClassNotFoundException {
        if (this.doneCalled) {
            _logger.log(Level.WARNING, CULoggerInfo.getString("NCLS-COMUTIL-00018", name, this.toString()), new Throwable());
            throw new ClassNotFoundException(name);
        }
        String nf = this.notFoundClasses.get(name);
        if (nf != null && nf.equals(name)) {
            throw new ClassNotFoundException(name);
        }
        String entryName = name.replace('.', '/') + ".class";
        for (URLEntry u : this.urlSet) {
            byte[] result;
            if (!u.hasItem(entryName) || (result = this.loadClassData0(u, entryName)) == null) continue;
            if (System.getSecurityManager() == null) {
                return new ClassData(result, u.pd);
            }
            CodeSource cs = u.pd.getCodeSource();
            PermissionCollection pc = this.getPermissions(cs);
            ProtectionDomain pdWithPemissions = new ProtectionDomain(u.pd.getCodeSource(), pc, u.pd.getClassLoader(), u.pd.getPrincipals());
            return new ClassData(result, pdWithPemissions);
        }
        this.notFoundClasses.put(name, name);
        throw new ClassNotFoundException(name);
    }

    private byte[] getClassData(InputStream istream) throws IOException {
        byte[] buf = new byte[4096];
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (BufferedInputStream bstream = new BufferedInputStream(istream);){
            int num;
            while ((num = bstream.read(buf)) != -1) {
                bout.write(buf, 0, num);
            }
        }
        return bout.toByteArray();
    }

    protected String getClassLoaderName() {
        return "ASURLClassLoader";
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClassLoaderName()).append(" : \n");
        if (this.doneCalled) {
            buffer.append("doneCalled = true\n");
            String snapshot = this.doneSnapshot;
            if (snapshot != null) {
                buffer.append("doneSnapshot = ").append(snapshot);
            }
        } else {
            buffer.append("urlSet = ").append(this.urlSet).append("\n");
            buffer.append("doneCalled = false \n");
        }
        buffer.append(" Parent -> ").append(this.getParent()).append("\n");
        return buffer.toString();
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream stream = super.getResourceAsStream(name);
        if (stream != null && !(stream instanceof SentinelInputStream)) {
            stream = new SentinelInputStream(stream);
        }
        return stream;
    }

    private synchronized void closeOpenStreams() {
        SentinelInputStream[] toClose;
        for (SentinelInputStream s : toClose = this.streams.toArray(new SentinelInputStream[0])) {
            try {
                s.closeWithWarning();
            }
            catch (IOException ioe) {
                _logger.log(Level.WARNING, "NCLS-COMUTIL-00022", ioe);
            }
        }
        this.streams.clear();
    }

    private static final class DelegatingClassLoader
    extends SecureClassLoader {
        private final ASURLClassLoader delegate;

        DelegatingClassLoader(ASURLClassLoader applicationCL) {
            super(applicationCL.getParent());
            this.delegate = applicationCL;
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            String packageName;
            ClassData classData = this.delegate.findClassData(name);
            int lastPackageSep = name.lastIndexOf(46);
            if (lastPackageSep != -1 && this.getPackage(packageName = name.substring(0, lastPackageSep)) == null) {
                try {
                    this.definePackage(packageName, null, null, null, null, null, null, null);
                }
                catch (IllegalArgumentException iae) {
                    _logger.log(Level.FINE, "duplicate package definition attempt for " + packageName, iae);
                }
            }
            Class<?> clazz = null;
            try {
                byte[] bytes = classData.getClassBytes();
                clazz = this.defineClass(name, bytes, 0, bytes.length, classData.pd);
                return clazz;
            }
            catch (UnsupportedClassVersionError ucve) {
                throw new UnsupportedClassVersionError(sm.getString("ejbClassLoader.unsupportedVersion", name, System.getProperty("java.version")));
            }
        }

        @Override
        protected URL findResource(String name) {
            return this.delegate.findResource(name);
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            return this.delegate.findResources(name);
        }
    }

    private static final class ClassData {
        private byte[] classBytes;
        private final ProtectionDomain pd;

        ClassData(byte[] classBytes, ProtectionDomain pd) {
            this.classBytes = classBytes;
            this.pd = pd;
        }

        private synchronized byte[] getClassBytes() {
            return this.classBytes;
        }

        private synchronized void setClassBytes(byte[] newBytes) {
            this.classBytes = newBytes;
        }
    }

    private class InternalURLStreamHandler
    extends URLStreamHandler {
        private volatile URL mURL;
        private final URLEntry mRes;

        public InternalURLStreamHandler(URLEntry res, String name) {
            this.mRes = res;
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            String path = u.getPath();
            int separator = path.lastIndexOf(33);
            assert (separator != -1);
            try {
                URI jarFileURI = new URI(path.substring(0, separator));
                if (!jarFileURI.equals(this.mRes.file.toURI())) {
                    throw new IOException("Cannot open a foreign URL; this.url=" + this.mURL + "; foreign.url=" + u);
                }
                String entryName = path.substring(separator + 1);
                if (entryName != null) {
                    assert (entryName.startsWith("/"));
                    entryName = entryName.substring(1);
                }
                return new InternalJarURLConnection(u, this.mRes, entryName);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }

        public void tieUrl(URL url) {
            if (this.mURL != null) {
                throw new IllegalStateException("Setting the URL more than once not allowed");
            }
            this.mURL = url;
        }
    }

    private class InternalJarURLConnection
    extends JarURLConnection {
        private final URLEntry mRes;
        private final String mName;

        public InternalJarURLConnection(URL url, URLEntry res, String name) throws MalformedURLException {
            super(url);
            this.mRes = res;
            this.mName = name;
        }

        @Override
        public JarFile getJarFile() throws IOException {
            return this.mRes.zip;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if ("".equals(this.mName)) {
                throw new IOException("no entry name specified");
            }
            ZipEntry entry = this.mRes.zip.getEntry(this.mName);
            if (entry == null) {
                throw new IOException("no entry called " + this.mName + " found in " + this.mRes.source);
            }
            return new SentinelInputStream(this.mRes.zip.getInputStream(entry));
        }
    }

    protected final class SentinelInputStream
    extends FilterInputStream {
        private volatile boolean closed;
        private final Throwable throwable;

        protected SentinelInputStream(InputStream in) {
            super(in);
            this.closed = false;
            this.throwable = new Throwable();
            this.getStreams().add(this);
        }

        @Override
        public void close() throws IOException {
            this._close();
        }

        protected void finalize() throws Throwable {
            if (!this.closed && this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.report();
            }
            super.finalize();
        }

        private List<SentinelInputStream> getStreams() {
            return ASURLClassLoader.this.streams;
        }

        private synchronized void _close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.getStreams().remove(this);
            super.close();
        }

        private void closeWithWarning() throws IOException {
            this._close();
            this.report();
        }

        private void report() {
            _logger.log(Level.WARNING, "NCLS-COMUTIL-00023", this.throwable);
        }
    }

    protected static final class URLEntry {
        final URL source;
        volatile File file = null;
        volatile ProtectedJarFile zip = null;
        volatile boolean isJar = false;
        private Predicate<String> presenceCheck;
        volatile ProtectionDomain pd = null;

        URLEntry(URL url) throws IOException {
            this.source = url;
            this.init();
        }

        void init() throws IOException {
            try {
                this.file = new File(this.source.toURI());
                this.isJar = this.file.isFile();
                if (this.isJar) {
                    this.zip = new ProtectedJarFile(this.file);
                    this.presenceCheck = any -> true;
                } else {
                    Path path = this.file.toPath();
                    this.presenceCheck = item -> DirWatcher.hasItem(path, item);
                    DirWatcher.register(path);
                }
            }
            catch (URISyntaxException use) {
                throw new IOException(use);
            }
        }

        boolean hasItem(String item) {
            return this.presenceCheck.test(item);
        }

        public void setProtectionDomain(ClassLoader ejbClassLoader, Certificate[] signers) throws MalformedURLException {
            if (this.pd == null) {
                this.pd = new ProtectionDomain(new CodeSource(this.file.toURI().toURL(), signers), null, ejbClassLoader, null);
            }
        }

        public String toString() {
            return "URLEntry : " + this.source.toString();
        }

        public boolean equals(Object obj) {
            boolean tf = false;
            if (obj instanceof URLEntry) {
                URLEntry e = (URLEntry)obj;
                try {
                    if (this.source.toURI().equals(e.source.toURI())) {
                        tf = true;
                    }
                }
                catch (URISyntaxException e1) {
                    assert (false);
                    throw new RuntimeException(e1);
                }
            }
            return tf;
        }

        public int hashCode() {
            try {
                return this.source.toURI().hashCode();
            }
            catch (URISyntaxException e) {
                assert (false);
                throw new RuntimeException(e);
            }
        }

        public void close() {
            if (this.zip != null) {
                try {
                    this.zip.reallyClose();
                }
                catch (IOException ioe) {
                    _logger.log(Level.INFO, CULoggerInfo.getString("NCLS-COMUTIL-00010", this.source), ioe);
                }
            }
            if (!this.isJar) {
                DirWatcher.unregister(this.file.toPath());
            }
        }
    }

    private static final class ProtectedJarFile
    extends JarFile {
        public ProtectedJarFile(File file) throws IOException {
            super(file);
        }

        @Override
        public void close() {
        }

        public void reallyClose() throws IOException {
            super.close();
        }

        protected void finalize() throws IOException {
            this.reallyClose();
            try {
                super.finalize();
            }
            catch (Throwable t) {
                throw new IOException(t);
            }
        }
    }
}

