/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.loader;

import com.sun.enterprise.util.CULoggerInfo;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchService;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.logging.Level;
import java.util.logging.Logger;

class WatchProcessor {
    protected static final Logger LOGGER = CULoggerInfo.getLogger();
    protected final Path root;
    protected final WatchService watchService;
    protected boolean registered;
    protected boolean overflowed;
    protected boolean cancelled;
    private int subscribers = 1;

    public WatchProcessor(Path root, WatchService watchService) {
        this.root = root;
        this.watchService = watchService;
    }

    protected boolean overflowed() {
        this.overflowed = true;
        return false;
    }

    protected void register() {
        if (!this.registered) {
            this.registered = this.registerFilesystemWatch();
        }
    }

    protected boolean registerFilesystemWatch() {
        try {
            AccessController.doPrivileged(() -> this.root.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE));
            return true;
        }
        catch (PrivilegedActionException e) {
            LOGGER.log(Level.WARNING, e, () -> "Failed to register watcher for " + this.root);
            return false;
        }
    }

    protected boolean created(Path filename) {
        return true;
    }

    protected boolean deleted(Path filename) {
        return true;
    }

    protected void cancelled() {
        this.cancelled = true;
    }

    protected boolean isCancelled() {
        return this.cancelled;
    }

    WatchProcessor subscribe() {
        ++this.subscribers;
        return this;
    }

    boolean unsubscribe() {
        return --this.subscribers == 0;
    }
}

