/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.opentracing.cdi;

import fish.payara.microprofile.opentracing.cdi.OpenTracingCdiUtils;
import fish.payara.opentracing.OpenTracingService;
import fish.payara.requesttracing.jaxrs.client.PayaraTracingServices;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import org.eclipse.microprofile.opentracing.Traced;
import org.glassfish.api.invocation.InvocationManager;

@Interceptor
@Traced
@Priority(value=4000)
public class TracedInterceptor
implements Serializable {
    private static final long serialVersionUID = -7772038254542420659L;
    private static final Logger LOG = Logger.getLogger(TracedInterceptor.class.getName());
    private static final Class[] HTTP_METHODS = new Class[]{GET.class, POST.class, DELETE.class, PUT.class, HEAD.class, PATCH.class, OPTIONS.class};
    @Inject
    private BeanManager beanManager;

    @AroundInvoke
    public Object traceCdiCall(InvocationContext invocationContext) throws Exception {
        LOG.fine(() -> "traceCdiCall(" + invocationContext + ")");
        PayaraTracingServices payaraTracingServices = new PayaraTracingServices();
        OpenTracingService openTracing = payaraTracingServices.getOpenTracingService();
        InvocationManager invocationManager = payaraTracingServices.getInvocationManager();
        if (openTracing == null || !openTracing.isEnabled() || this.isJaxRsMethod(invocationContext) || this.isWebServiceMethod(invocationContext, invocationManager)) {
            LOG.finest("The call is already monitored by some different component, proceeding the invocation.");
            return invocationContext.proceed();
        }
        Traced traced = OpenTracingCdiUtils.getAnnotation(this.beanManager, Traced.class, invocationContext);
        boolean tracingEnabled = OpenTracingCdiUtils.getConfigOverrideValue(Traced.class, "value", invocationContext, Boolean.TYPE).orElse(traced.value());
        if (!tracingEnabled) {
            LOG.finest("Tracing is not enabled, nothing to do.");
            return invocationContext.proceed();
        }
        String applicationName = openTracing.getApplicationName(invocationManager, invocationContext);
        Tracer tracer = openTracing.getTracer(applicationName);
        String operationName = this.getOperationName(invocationContext, traced);
        Span parentSpan = tracer.activeSpan();
        Span span = tracer.buildSpan(operationName).start();
        Throwable throwable = null;
        try (Scope scope = tracer.scopeManager().activate(span, true);){
            Object object = invocationContext.proceed();
            return object;
        }
        catch (Exception ex) {
            try {
                LOG.log(Level.FINEST, "Setting the error to the active span ...", ex);
                span.setTag(Tags.ERROR.getKey(), true);
                HashMap<String, String> errorInfoMap = new HashMap<String, String>();
                errorInfoMap.put("event", "error");
                errorInfoMap.put("error.object", ex.getClass().getName());
                span.log(errorInfoMap);
                throw ex;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private boolean isJaxRsMethod(InvocationContext invocationContext) {
        for (Class httpMethod : HTTP_METHODS) {
            if (OpenTracingCdiUtils.getAnnotation(this.beanManager, httpMethod, invocationContext) == null) continue;
            return true;
        }
        return false;
    }

    private boolean isWebServiceMethod(InvocationContext invocationContext, InvocationManager invocationManager) {
        return invocationContext.getMethod().equals(invocationManager.peekWebServiceMethod());
    }

    private String getOperationName(InvocationContext invocationContext, Traced traced) {
        String operationName = OpenTracingCdiUtils.getConfigOverrideValue(Traced.class, "operationName", invocationContext, String.class).orElse(traced.operationName());
        if (operationName.isEmpty()) {
            return invocationContext.getMethod().getDeclaringClass().getCanonicalName() + "." + invocationContext.getMethod().getName();
        }
        return operationName;
    }
}

