/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.opentracing.jaxrs;

import fish.payara.microprofile.opentracing.cdi.OpenTracingCdiUtils;
import fish.payara.opentracing.OpenTracingService;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import io.opentracing.tag.Tags;
import java.net.MalformedURLException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.ws.rs.Path;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.opentracing.Traced;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;

public class OpenTracingRequestEventListener
implements RequestEventListener {
    private static final Logger LOG = Logger.getLogger(OpenTracingRequestEventListener.class.getName());
    private final String applicationName;
    private final ResourceInfo resourceInfo;
    private final OpenTracingService openTracing;

    public OpenTracingRequestEventListener(String applicationName, ResourceInfo resourceInfo, OpenTracingService openTracing) {
        this.applicationName = applicationName;
        this.resourceInfo = resourceInfo;
        this.openTracing = openTracing;
    }

    @Override
    public void onEvent(RequestEvent event) {
        LOG.fine(() -> "onEvent(event.type=" + (Object)((Object)event.getType()) + ", path=" + this.getPath(event) + ")");
        if (Arrays.asList(RequestEvent.Type.START, RequestEvent.Type.MATCHING_START).contains((Object)event.getType())) {
            return;
        }
        try {
            if (event.getType() == RequestEvent.Type.REQUEST_MATCHED) {
                Traced tracedAnnotation = this.getTracedAnnotation();
                ContainerRequest requestContext = event.getContainerRequest();
                if (!this.canTrace(requestContext, tracedAnnotation)) {
                    LOG.finest(() -> "canTrace(...) returned false, nothing to do.");
                    return;
                }
                String operationName = this.determineOperationName(requestContext, tracedAnnotation);
                this.onIncomingRequest(event, operationName);
                return;
            }
            Scope activeScope = this.openTracing.getTracer(this.applicationName).scopeManager().active();
            if (activeScope == null) {
                LOG.finest(() -> "Could not find any active scope, nothing to do.");
                return;
            }
            if (event.getType() == RequestEvent.Type.ON_EXCEPTION) {
                this.onException(event);
            } else if (event.getType() == RequestEvent.Type.RESP_FILTERS_FINISHED) {
                this.onOutgoingResponse(event);
            } else if (event.getType() == RequestEvent.Type.FINISHED) {
                this.finish(event);
            }
        }
        catch (RuntimeException e) {
            LOG.log(Level.CONFIG, "Exception thrown by the listener!", e);
            throw e;
        }
    }

    private String getPath(RequestEvent event) {
        return event.getUriInfo() == null ? "<unknown>" : event.getUriInfo().getPath();
    }

    private void onIncomingRequest(RequestEvent event, String operationName) {
        LOG.fine(() -> "onIncomingRequest(event=" + (Object)((Object)event.getType()) + ", operationName=" + operationName + ")");
        ContainerRequest requestContext = event.getContainerRequest();
        Tracer tracer = this.openTracing.getTracer(this.applicationName);
        Tracer.SpanBuilder spanBuilder = tracer.buildSpan(operationName).withTag(Tags.SPAN_KIND.getKey(), "server").withTag(Tags.HTTP_METHOD.getKey(), requestContext.getMethod()).withTag(Tags.HTTP_URL.getKey(), this.toString(requestContext.getUriInfo())).withTag(Tags.COMPONENT.getKey(), "jaxrs");
        SpanContext spanContext = this.findSpanContext(requestContext, tracer);
        if (spanContext != null) {
            spanBuilder.asChildOf(spanContext);
        }
        spanBuilder.startActive(true);
        LOG.fine(() -> "Request tracing enabled for request=" + requestContext.getRequest() + " to application=" + this.applicationName + " on uri=" + this.toString(requestContext.getUriInfo()));
    }

    private void onException(RequestEvent event) {
        LOG.fine(() -> "onException(event=" + (Object)((Object)event.getType()) + ")");
        Scope activeScope = this.getAlreadyActiveScope();
        Span activeSpan = activeScope.span();
        activeSpan.setTag(Tags.ERROR.getKey(), true);
        activeSpan.setTag(Tags.HTTP_STATUS.getKey(), (Number)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        activeSpan.log(Collections.singletonMap("event", "error"));
        activeSpan.log(Collections.singletonMap("error.object", event.getException()));
    }

    private void onOutgoingResponse(RequestEvent event) {
        LOG.fine(() -> "onOutgoingRequest(event=" + (Object)((Object)event.getType()) + ")");
        ContainerResponse response = Objects.requireNonNull(event.getContainerResponse(), "response");
        Response.StatusType statusInfo = response.getStatusInfo();
        LOG.fine(() -> "Response context: status code=" + statusInfo.getStatusCode() + ", hasEntity=" + response.hasEntity());
        Scope activeScope = this.getAlreadyActiveScope();
        LOG.finest("Setting the HTTP response status etc. to the active span...");
        Span activeSpan = activeScope.span();
        activeSpan.setTag(Tags.HTTP_STATUS.getKey(), (Number)statusInfo.getStatusCode());
        if (statusInfo.getFamily() == Response.Status.Family.CLIENT_ERROR || statusInfo.getFamily() == Response.Status.Family.SERVER_ERROR) {
            activeSpan.setTag(Tags.ERROR.getKey(), true);
            activeSpan.log(Collections.singletonMap("event", "error"));
            if (response.hasEntity() && response.getEntity() instanceof Throwable) {
                activeSpan.log(Collections.singletonMap("error.object", response.getEntity()));
            }
        }
    }

    private void finish(RequestEvent event) {
        LOG.fine(() -> "finish(event=" + (Object)((Object)event.getType()) + ")");
        Scope activeScope = this.openTracing.getTracer(this.applicationName).scopeManager().active();
        if (activeScope == null) {
            LOG.finest("Active scope is null, nothing to do.");
            return;
        }
        activeScope.close();
        LOG.finest("Finished.");
    }

    private Traced getTracedAnnotation() {
        BeanManager beanManager = this.getBeanManager();
        if (beanManager == null) {
            return null;
        }
        return OpenTracingCdiUtils.getAnnotation(beanManager, Traced.class, this.resourceInfo);
    }

    private BeanManager getBeanManager() {
        try {
            return CDI.current().getBeanManager();
        }
        catch (IllegalStateException ise) {
            LOG.log(Level.FINE, "Error getting Bean Manager, presumably due to this application not using CDI", ise);
            return null;
        }
    }

    private boolean canTrace(ContainerRequest request, Traced tracedAnnotation) {
        Optional skipPatternOptional;
        if (request == null || this.resourceInfo.getResourceClass() == null || this.resourceInfo.getResourceMethod() == null) {
            return false;
        }
        String uriPath = "/" + request.getUriInfo().getPath();
        if (uriPath.equals("/health") || uriPath.equals("/metrics") || uriPath.contains("/metrics/base") || uriPath.contains("/metrics/vendor") || uriPath.contains("/metrics/application")) {
            return false;
        }
        Config config = this.getConfig();
        if (config != null && (skipPatternOptional = config.getOptionalValue("mp.opentracing.server.skip-pattern", String.class)).isPresent()) {
            String[] splitSkipPatterns;
            String skipPatterns = (String)skipPatternOptional.get();
            for (String skipPattern : splitSkipPatterns = skipPatterns.split("\\|")) {
                if (!uriPath.matches(skipPattern)) continue;
                return false;
            }
        }
        return tracedAnnotation == null || this.getTracingFromConfig().orElse(tracedAnnotation.value()) != false;
    }

    private Config getConfig() {
        try {
            return ConfigProvider.getConfig();
        }
        catch (IllegalArgumentException ex) {
            LOG.log(Level.CONFIG, "No config could be found", ex);
            return null;
        }
    }

    private Optional<Boolean> getTracingFromConfig() {
        return OpenTracingCdiUtils.getConfigOverrideValue(Traced.class, "value", this.resourceInfo, Boolean.class);
    }

    private Scope getAlreadyActiveScope() {
        Scope activeScope = this.openTracing.getTracer(this.applicationName).scopeManager().active();
        if (activeScope == null) {
            throw new IllegalStateException("Active scope is null, something closed it.");
        }
        return activeScope;
    }

    private String determineOperationName(ContainerRequestContext request, Traced tracedAnnotation) {
        Optional operationNameProviderOptional;
        if (tracedAnnotation != null) {
            String operationName = OpenTracingCdiUtils.getConfigOverrideValue(Traced.class, "operationName", this.resourceInfo, String.class).orElse(tracedAnnotation.operationName());
            if (operationName.equals("")) {
                operationName = request.getMethod() + ":" + this.resourceInfo.getResourceClass().getCanonicalName() + "." + this.resourceInfo.getResourceMethod().getName();
            }
            return operationName;
        }
        Config config = this.getConfig();
        Optional optional = operationNameProviderOptional = config == null ? Optional.empty() : config.getOptionalValue("mp.opentracing.server.operation-name-provider", String.class);
        if (operationNameProviderOptional.isPresent()) {
            String operationNameProvider = (String)operationNameProviderOptional.get();
            Path classLevelAnnotation = this.resourceInfo.getResourceClass().getAnnotation(Path.class);
            Path methodLevelAnnotation = this.resourceInfo.getResourceMethod().getAnnotation(Path.class);
            if (operationNameProvider.equals("http-path") && classLevelAnnotation != null) {
                String operationName = request.getMethod() + ":";
                operationName = classLevelAnnotation.value().startsWith("/") ? operationName + classLevelAnnotation.value() : operationName + "/" + classLevelAnnotation.value();
                if (methodLevelAnnotation != null) {
                    operationName = methodLevelAnnotation.value().startsWith("/") ? operationName + methodLevelAnnotation.value() : operationName + "/" + methodLevelAnnotation.value();
                }
                return operationName;
            }
        }
        return request.getMethod() + ":" + this.resourceInfo.getResourceClass().getCanonicalName() + "." + this.resourceInfo.getResourceMethod().getName();
    }

    private SpanContext findSpanContext(ContainerRequestContext requestContext, Tracer tracer) {
        try {
            return tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new MultivaluedMapToTextMap((MultivaluedMap<String, String>)requestContext.getHeaders()));
        }
        catch (IllegalArgumentException e) {
            LOG.log(Level.WARNING, e.getMessage());
            return null;
        }
    }

    private String toString(UriInfo uriInfo) {
        try {
            return uriInfo.getRequestUri().toURL().toString();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid uriInfo: " + uriInfo, e);
        }
    }

    private class MultivaluedMapIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, List<V>>> mapIterator;
        private Map.Entry<K, List<V>> mapEntry;
        private Iterator<V> mapEntryIterator;

        public MultivaluedMapIterator(Set<Map.Entry<K, List<V>>> multiValuesEntrySet) {
            this.mapIterator = multiValuesEntrySet.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.mapEntryIterator != null && this.mapEntryIterator.hasNext() || this.mapIterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.mapEntry == null || !this.mapEntryIterator.hasNext() && this.mapIterator.hasNext()) {
                this.mapEntry = this.mapIterator.next();
                this.mapEntryIterator = this.mapEntry.getValue().iterator();
            }
            if (this.mapEntryIterator.hasNext()) {
                return new AbstractMap.SimpleImmutableEntry<K, V>(this.mapEntry.getKey(), this.mapEntryIterator.next());
            }
            return new AbstractMap.SimpleImmutableEntry<K, Object>(this.mapEntry.getKey(), null);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class MultivaluedMapToTextMap
    implements TextMap {
        private final MultivaluedMap<String, String> map;

        public MultivaluedMapToTextMap(MultivaluedMap<String, String> map) {
            this.map = map;
        }

        public Iterator<Map.Entry<String, String>> iterator() {
            return new MultivaluedMapIterator<String, String>(this.map.entrySet());
        }

        public void put(String key, String value) {
            this.map.add((Object)key, (Object)value);
        }
    }
}

