/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.opentracing.jaxrs.client;

import fish.payara.microprofile.opentracing.jaxrs.client.AsyncContextPropagator;
import fish.payara.microprofile.opentracing.jaxrs.client.TracedMethodFilter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.spi.RestClientListener;

public class RestClientTracingListener
implements RestClientListener {
    static final String REST_CLIENT_INVOKED_METHOD = "org.eclipse.microprofile.rest.client.invokedMethod";
    private static final Logger logger = Logger.getLogger(RestClientTracingListener.class.getName());

    public void onNewClient(Class<?> aClass, RestClientBuilder restClientBuilder) {
        restClientBuilder.property("fish.payara.requesttracing.jaxrs.client.decorators.EarlyBuilderInit", (Object)true);
        restClientBuilder.register((Object)new AsyncContextPropagator.Factory());
        restClientBuilder.property("fish.payara.requesttracing.jaxrs.client.TracingPredicate", (Object)new TracedMethodFilter(this.obtainConfig(), aClass));
    }

    private Config obtainConfig() {
        try {
            return ConfigProvider.getConfig();
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.INFO, "No config could be found", ex);
            return null;
        }
    }
}

