/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import java.util.Arrays;

public final class UsernamePasswordStore {
    private static final boolean isPerThreadAuth = Boolean.getBoolean("com.sun.appserv.iiopclient.perthreadauth");
    private static ThreadLocal localUpc = isPerThreadAuth ? new ThreadLocal() : null;
    private static UsernamePasswordStore sharedUpc;
    private final String username;
    private final char[] password;

    private UsernamePasswordStore(String username, char[] password) {
        char[] passwordCopy = password == null ? null : Arrays.copyOf(password, password.length);
        this.password = passwordCopy;
        this.username = username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UsernamePasswordStore get() {
        if (isPerThreadAuth) {
            return (UsernamePasswordStore)localUpc.get();
        }
        Class<UsernamePasswordStore> clazz = UsernamePasswordStore.class;
        synchronized (UsernamePasswordStore.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sharedUpc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void set(String username, char[] password) {
        if (isPerThreadAuth) {
            localUpc.set(new UsernamePasswordStore(username, password));
            return;
        }
        Class<UsernamePasswordStore> clazz = UsernamePasswordStore.class;
        synchronized (UsernamePasswordStore.class) {
            sharedUpc = new UsernamePasswordStore(username, password);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void reset() {
        if (isPerThreadAuth) {
            localUpc.set(null);
            return;
        }
        Class<UsernamePasswordStore> clazz = UsernamePasswordStore.class;
        synchronized (UsernamePasswordStore.class) {
            sharedUpc = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void resetThreadLocalOnly() {
        if (isPerThreadAuth) {
            localUpc.set(null);
        }
    }

    public static String getUsername() {
        UsernamePasswordStore usernamePasswordStore = UsernamePasswordStore.get();
        if (usernamePasswordStore == null) {
            return null;
        }
        return usernamePasswordStore.username;
    }

    public static char[] getPassword() {
        UsernamePasswordStore usernamePasswordStore = UsernamePasswordStore.get();
        if (usernamePasswordStore == null) {
            return null;
        }
        return usernamePasswordStore.password == null ? null : Arrays.copyOf(usernamePasswordStore.password, usernamePasswordStore.password.length);
    }
}

