/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.login;

import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.security.UsernamePasswordStore;
import com.sun.enterprise.security.auth.login.common.PasswordCredential;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.glassfish.security.common.PrincipalImpl;

public class ClientPasswordLoginModule
implements LoginModule {
    private static final Logger _logger = SecurityLoggerInfo.getLogger();
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ClientPasswordLoginModule.class);
    public static final String LOGIN_NAME = "j2eelogin.name";
    public static final String LOGIN_PASSWORD = "j2eelogin.password";
    private static final String DEFAULT_REALMNAME = "default";
    private Subject subject;
    private CallbackHandler callbackHandler;
    private String username;
    private char[] password;
    private boolean succeeded;
    private boolean commitSucceeded;
    private PrincipalImpl userPrincipal;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
    }

    @Override
    public boolean login() throws LoginException {
        this.callbackHandlerNonNull();
        String incomingUsername = UsernamePasswordStore.getUsername();
        char[] incomingPassword = UsernamePasswordStore.getPassword();
        boolean doSet = false;
        if (incomingUsername == null) {
            incomingUsername = System.getProperty(LOGIN_NAME);
            doSet = true;
        }
        if (incomingPassword == null) {
            if (System.getProperty(LOGIN_PASSWORD) != null) {
                incomingPassword = System.getProperty(LOGIN_PASSWORD).toCharArray();
            }
            doSet = true;
        }
        if (doSet) {
            UsernamePasswordStore.set(incomingUsername, incomingPassword);
        }
        if (incomingUsername != null && incomingPassword != null) {
            this.username = incomingUsername;
            this.password = ClientPasswordLoginModule.copyPassword(incomingPassword);
        } else {
            Callback[] callbacks = new Callback[]{this.createNameCallback(), this.createPasswordCallback()};
            try {
                this.callbackHandler.handle(callbacks);
                this.username = ((NameCallback)callbacks[0]).getName();
                this.usernameNonNull();
                char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
                if (tmpPassword == null) {
                    tmpPassword = new char[]{};
                }
                this.password = ClientPasswordLoginModule.copyPassword(tmpPassword);
                ((PasswordCallback)callbacks[1]).clearPassword();
            }
            catch (IOException ioe) {
                throw new LoginException(ioe.toString());
            }
            catch (UnsupportedCallbackException uce) {
                throw new LoginException(localStrings.getLocalString("login.callback", "Error: Callback not available to garner authentication information from user(CallbackName):") + uce.getCallback().toString());
            }
        }
        _logger.log(Level.FINEST, "\t\t[ClientPasswordLoginModule] authentication succeeded");
        this.succeeded = true;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        this.userPrincipal = new PrincipalImpl(this.username);
        if (!this.subject.getPrincipals().contains(this.userPrincipal)) {
            this.subject.getPrincipals().add((Principal)this.userPrincipal);
        }
        _logger.log(Level.FINE, "\t\t[ClientPasswordLoginModule] added PrincipalImpl to Subject");
        String realm = DEFAULT_REALMNAME;
        PasswordCredential passwordCredential = new PasswordCredential(this.username, this.password, realm);
        if (!this.subject.getPrivateCredentials().contains(passwordCredential)) {
            this.subject.getPrivateCredentials().add(passwordCredential);
        }
        this.username = null;
        for (int i = 0; i < this.password.length; ++i) {
            this.password[i] = 32;
        }
        this.password = null;
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.username = null;
            if (this.password != null) {
                for (int i = 0; i < this.password.length; ++i) {
                    this.password[i] = 32;
                }
                this.password = null;
            }
            this.userPrincipal = null;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.userPrincipal);
        this.succeeded = this.commitSucceeded;
        this.username = null;
        if (this.password != null) {
            for (int i = 0; i < this.password.length; ++i) {
                this.password[i] = 32;
            }
            this.password = null;
        }
        this.userPrincipal = null;
        return true;
    }

    private void callbackHandlerNonNull() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException(localStrings.getLocalString("login.nocallback", "Error: no CallbackHandler available to garner authentication information from the user"));
        }
    }

    private void usernameNonNull() throws LoginException {
        if (this.username == null) {
            throw new LoginException(localStrings.getLocalString("login.nousername", "No user specified"));
        }
    }

    private static char[] copyPassword(char[] incomingPassword) {
        char[] copy = new char[incomingPassword.length];
        System.arraycopy(incomingPassword, 0, copy, 0, incomingPassword.length);
        return copy;
    }

    private Callback createNameCallback() {
        NameCallback nameCallback = new NameCallback(localStrings.getLocalString("login.username", "ClientPasswordModule username"));
        String defaultUname = System.getProperty("user.name");
        if (defaultUname != null) {
            nameCallback = new NameCallback(localStrings.getLocalString("login.username", "ClientPasswordModule username"), defaultUname);
        }
        return nameCallback;
    }

    private Callback createPasswordCallback() {
        return new PasswordCallback(localStrings.getLocalString("login.password", "ClientPasswordModule password: "), false);
    }
}

