/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.login;

import com.sun.enterprise.security.BasePasswordLoginModule;
import com.sun.enterprise.security.auth.realm.solaris.SolarisRealm;
import java.util.logging.Level;
import javax.security.auth.login.LoginException;

public class SolarisLoginModule
extends BasePasswordLoginModule {
    @Override
    protected void authenticateUser() throws LoginException {
        SolarisRealm solarisRealm = this.getRealm(SolarisRealm.class, "solarislm.badrealm");
        if (this._username == null || this._username.length() == 0) {
            throw new LoginException(sm.getString("solarislm.nulluser"));
        }
        String[] groups = solarisRealm.authenticate(this._username, this.getPasswordChar());
        if (groups == null) {
            throw new LoginException(sm.getString("solarislm.loginfail", (Object)this._username));
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Solaris login succeeded for: " + this._username);
        }
        this.commitUserAuthentication(groups);
    }
}

